/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity;

import com.synopsys.integration.coverity.exception.CoverityIntegrationException;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityGlobalConfig;
import com.synopsys.integration.log.IntLogger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;

public class GlobalValueHelper {
    public static Optional<CoverityConnectInstance> getCoverityInstanceWithUrl(IntLogger logger, String coverityInstanceUrl) {
        CoverityGlobalConfig coverityGlobalConfig = GlobalValueHelper.getCoverityGlobalConfig();
        if (coverityGlobalConfig == null) {
            return Optional.empty();
        }
        List<CoverityConnectInstance> coverityInstances = coverityGlobalConfig.getCoverityConnectInstances();
        if (null != coverityInstances && !coverityInstances.isEmpty()) {
            return coverityInstances.stream().filter(coverityInstance -> coverityInstance.getUrl().equals(coverityInstanceUrl)).findFirst();
        }
        logger.error("[ERROR] No Coverity Connect instances are configured in the Jenkins system config.");
        return Optional.empty();
    }

    public static CoverityConnectInstance getCoverityInstanceWithUrlOrDie(IntLogger logger, String coverityInstanceUrl) throws CoverityIntegrationException {
        return GlobalValueHelper.getCoverityInstanceWithUrl(logger, coverityInstanceUrl).orElseThrow(() -> new CoverityIntegrationException("No Coverity Connect instance is configured with the url " + coverityInstanceUrl));
    }

    public static List<CoverityConnectInstance> getGlobalCoverityConnectInstances() {
        return Optional.ofNullable(GlobalValueHelper.getCoverityGlobalConfig()).map(CoverityGlobalConfig::getCoverityConnectInstances).orElseGet(Collections::emptyList);
    }

    private static CoverityGlobalConfig getCoverityGlobalConfig() {
        return (CoverityGlobalConfig)((Object)GlobalConfiguration.all().get(CoverityGlobalConfig.class));
    }
}

