/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity;

import hudson.scm.ChangeLogSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetFilter {
    private final Logger logger = LoggerFactory.getLogger(ChangeSetFilter.class);
    private final Set<String> excludedSet;
    private final Set<String> includedSet;

    public ChangeSetFilter(String toExclude, String toInclude) {
        this(ChangeSetFilter.createSetFromString(toExclude), ChangeSetFilter.createSetFromString(toInclude));
    }

    private ChangeSetFilter(Set<String> excludedSet, Set<String> includedSet) {
        this.excludedSet = excludedSet;
        this.includedSet = includedSet;
    }

    public static ChangeSetFilter createAcceptAllFilter() {
        return new ChangeSetFilter(Collections.emptySet(), Collections.emptySet());
    }

    private static Set<String> createSetFromString(String s) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(StringUtils.trimToEmpty((String)s), ",");
        while (stringTokenizer.hasMoreTokens()) {
            set.add(StringUtils.trimToEmpty((String)stringTokenizer.nextToken()));
        }
        return set;
    }

    public boolean shouldInclude(ChangeLogSet.AffectedFile affectedFile) {
        String affectedFilePath = affectedFile.getPath();
        String affectedEditType = affectedFile.getEditType().getName();
        boolean shouldInclude = this.shouldInclude(affectedFilePath);
        if (shouldInclude) {
            this.logger.debug(String.format("Type: %s File Path: %s Included in change set", affectedEditType, affectedFilePath));
        } else {
            this.logger.debug(String.format("Type: %s File Path: %s Excluded from change set", affectedEditType, affectedFilePath));
        }
        return shouldInclude;
    }

    private boolean shouldInclude(String filePath) {
        String fileName = filePath.contains("/") ? filePath.substring(filePath.lastIndexOf("/")) : filePath;
        Predicate<String> caseInsensitiveWildcardMatch = pattern -> FilenameUtils.wildcardMatch((String)fileName, (String)pattern, (IOCase)IOCase.INSENSITIVE);
        boolean excluded = this.excludedSet.stream().anyMatch(caseInsensitiveWildcardMatch);
        boolean included = this.includedSet.isEmpty() || this.includedSet.stream().anyMatch(caseInsensitiveWildcardMatch);
        return included && !excluded;
    }
}

