/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.executable.CoverityToolEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.ChangeSetFilter;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.extensions.ConfigureChangeSetPatterns;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.rest.RestConstants;
import com.synopsys.integration.stepworkflow.AbstractConsumingSubStep;
import com.synopsys.integration.stepworkflow.SubStepResponse;
import com.synopsys.integration.util.IntEnvironmentVariables;
import hudson.scm.ChangeLogSet;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;

public class SetUpCoverityEnvironment
extends AbstractConsumingSubStep<String> {
    private final CoverityJenkinsIntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final List<ChangeLogSet<?>> changeLogSets;
    private final ConfigureChangeSetPatterns configureChangeSetPatterns;
    private final String coverityInstanceUrl;
    private final String coverityCredentialsId;
    private final String coverityUsername;
    private final String coverityPassword;
    private final String projectName;
    private final String streamName;
    private final String viewName;
    private final String intermediateDirectoryPath;
    private final String coverityToolHomeBin;

    public SetUpCoverityEnvironment(CoverityJenkinsIntLogger logger, IntEnvironmentVariables intEnvironmentVariables, List<ChangeLogSet<?>> changeLogSets, ConfigureChangeSetPatterns configureChangeSetPatterns, String coverityInstanceUrl, String coverityCredentialsId, String coverityUsername, String coverityPassphrase, String projectName, String streamName, String viewName, String intermediateDirectoryPath, String coverityToolHomeBin) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.changeLogSets = changeLogSets;
        this.configureChangeSetPatterns = configureChangeSetPatterns;
        this.coverityInstanceUrl = coverityInstanceUrl;
        this.coverityCredentialsId = coverityCredentialsId;
        this.coverityUsername = coverityUsername;
        this.coverityPassword = coverityPassphrase;
        this.projectName = projectName;
        this.streamName = streamName;
        this.viewName = viewName;
        this.intermediateDirectoryPath = intermediateDirectoryPath;
        this.coverityToolHomeBin = coverityToolHomeBin;
    }

    public SubStepResponse<Object> run(String authKeyFilePath) {
        ChangeSetFilter changeSetFilter;
        this.logger.debug("Computing $CHANGE_SET");
        if (this.configureChangeSetPatterns == null) {
            changeSetFilter = ChangeSetFilter.createAcceptAllFilter();
            this.logger.alwaysLog("-- No change set inclusion or exclusion patterns set");
        } else {
            changeSetFilter = this.configureChangeSetPatterns.createChangeSetFilter();
            this.logger.alwaysLog("-- Change set inclusion patterns: " + this.configureChangeSetPatterns.getChangeSetInclusionPatterns());
            this.logger.alwaysLog("-- Change set exclusion patterns: " + this.configureChangeSetPatterns.getChangeSetExclusionPatterns());
        }
        List changeSet = this.changeLogSets.stream().filter(changeLogSet -> !changeLogSet.isEmptySet()).flatMap(this::toEntries).peek(this::logEntry).flatMap(this::toAffectedFiles).filter(changeSetFilter::shouldInclude).map(ChangeLogSet.AffectedFile::getPath).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.logger.alwaysLog("Computed a $CHANGE_SET of " + changeSet.size() + " files");
        this.intEnvironmentVariables.put("PATH+COVERITYTOOLBIN", this.coverityToolHomeBin);
        this.intEnvironmentVariables.put(CoverityToolEnvironmentVariable.USER.toString(), this.coverityUsername);
        this.intEnvironmentVariables.put(CoverityToolEnvironmentVariable.PASSPHRASE.toString(), this.coverityPassword);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.TEMPORARY_AUTH_KEY_PATH.toString(), authKeyFilePath);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.COVERITY_URL.toString(), this.coverityInstanceUrl);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.CREDENTIALS_ID.toString(), this.coverityCredentialsId);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.COVERITY_PROJECT.toString(), this.projectName);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.COVERITY_STREAM.toString(), this.streamName);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.COVERITY_VIEW.toString(), this.viewName);
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.CHANGE_SET.toString(), String.join((CharSequence)" ", changeSet));
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.CHANGE_SET_SIZE.toString(), String.valueOf(changeSet.size()));
        this.intEnvironmentVariables.put(JenkinsCoverityEnvironmentVariable.COVERITY_INTERMEDIATE_DIRECTORY.toString(), this.intermediateDirectoryPath);
        this.logger.alwaysLog("Synopsys Coverity environment:");
        this.logger.alwaysLog("-- Synopsys Coverity static analysis tool home: " + this.coverityToolHomeBin);
        this.logger.alwaysLog("-- Synopsys Coverity username: " + this.coverityUsername);
        Arrays.stream(JenkinsCoverityEnvironmentVariable.values()).map(JenkinsCoverityEnvironmentVariable::toString).map(environmentVariable -> String.format("-- $%s=%s", environmentVariable, this.intEnvironmentVariables.getValue(environmentVariable))).forEach(arg_0 -> ((CoverityJenkinsIntLogger)this.logger).alwaysLog(arg_0));
        return SubStepResponse.SUCCESS();
    }

    private Stream<? extends ChangeLogSet.Entry> toEntries(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        return StreamSupport.stream(changeLogSet.spliterator(), false);
    }

    private Stream<? extends ChangeLogSet.AffectedFile> toAffectedFiles(ChangeLogSet.Entry entry) {
        return entry.getAffectedFiles().stream();
    }

    private void logEntry(ChangeLogSet.Entry entry) {
        if (this.logger.getLogLevel().isLoggable(LogLevel.DEBUG)) {
            Date date = new Date(entry.getTimestamp());
            this.logger.debug(String.format("Commit %s by %s on %s: %s", entry.getCommitId(), entry.getAuthor(), RestConstants.formatDate((Date)date), entry.getMsg()));
        }
    }
}

