/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.stepworkflow;

import com.synopsys.integration.coverity.config.CoverityServerConfig;
import com.synopsys.integration.coverity.exception.CoverityIntegrationException;
import com.synopsys.integration.coverity.ws.ConfigurationServiceWrapper;
import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.coverity.ws.view.ViewService;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.JenkinsCoverityEnvironmentVariable;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.ConfigureChangeSetPatterns;
import com.synopsys.integration.jenkins.coverity.extensions.OnCommandFailure;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.CoverityRunConfiguration;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityGlobalConfig;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CreateMissingProjectsAndStreams;
import com.synopsys.integration.jenkins.coverity.stepworkflow.GetCoverityCommands;
import com.synopsys.integration.jenkins.coverity.stepworkflow.GetIssuesInView;
import com.synopsys.integration.jenkins.coverity.stepworkflow.RunCoverityCommands;
import com.synopsys.integration.jenkins.coverity.stepworkflow.SetUpCoverityEnvironment;
import com.synopsys.integration.jenkins.coverity.stepworkflow.ValidateCoverityInstallation;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.stepworkflow.SubStep;
import com.synopsys.integration.stepworkflow.jenkins.RemoteSubStep;
import com.synopsys.integration.util.IntEnvironmentVariables;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import org.apache.commons.lang3.StringUtils;

public class CoverityWorkflowStepFactory {
    private final EnvVars envVars;
    private final Node node;
    private final Launcher launcher;
    private final TaskListener listener;
    private IntEnvironmentVariables _intEnvironmentVariables = null;
    private final Supplier<IntEnvironmentVariables> initializedIntEnvrionmentVariables = this::getOrCreateEnvironmentVariables;
    private final ThrowingSupplier<String, CoverityJenkinsAbortException> validatedCoverityToolHome = this::getCoverityToolHomeFromEnvironment;
    private CoverityJenkinsIntLogger _logger = null;
    private final Supplier<CoverityJenkinsIntLogger> initializedLogger = this::getOrCreateLogger;
    private VirtualChannel _virtualChannel = null;
    private final ThrowingSupplier<VirtualChannel, CoverityJenkinsAbortException> initializedVirtualChannel = this::getOrCreateVirtualChannel;

    public CoverityWorkflowStepFactory(EnvVars envVars, Node node, Launcher launcher, TaskListener listener) {
        this.envVars = envVars;
        this.node = node;
        this.launcher = launcher;
        this.listener = listener;
    }

    public CreateMissingProjectsAndStreams createStepCreateMissingProjectsAndStreams(String coverityServerUrl, String credentialsId, String projectName, String streamName) throws CoverityJenkinsAbortException {
        ConfigurationServiceWrapper configurationServiceWrapper;
        WebServiceFactory webServiceFactory = this.getWebServiceFactoryFromUrl(coverityServerUrl, credentialsId);
        try {
            configurationServiceWrapper = webServiceFactory.createConfigurationServiceWrapper();
        }
        catch (MalformedURLException malformedURLException) {
            throw CoverityJenkinsAbortException.fromMalformedUrlException(coverityServerUrl + "/ws/v9/configurationservice?wsdl", malformedURLException);
        }
        return new CreateMissingProjectsAndStreams(this.initializedLogger.get(), configurationServiceWrapper, projectName, streamName);
    }

    public GetCoverityCommands createStepGetCoverityCommands(CoverityRunConfiguration coverityRunConfiguration) {
        return new GetCoverityCommands((IntLogger)this.initializedLogger.get(), this.initializedIntEnvrionmentVariables.get(), coverityRunConfiguration);
    }

    public GetIssuesInView createStepGetIssuesInView(String coverityServerUrl, String credentialsId, String projectName, String viewName) throws CoverityJenkinsAbortException {
        ConfigurationServiceWrapper configurationServiceWrapper;
        WebServiceFactory webServiceFactory = this.getWebServiceFactoryFromUrl(coverityServerUrl, credentialsId);
        try {
            configurationServiceWrapper = webServiceFactory.createConfigurationServiceWrapper();
        }
        catch (MalformedURLException malformedURLException) {
            throw CoverityJenkinsAbortException.fromMalformedUrlException(coverityServerUrl + "/ws/v9/configurationservice?wsdl", malformedURLException);
        }
        ViewService viewService = webServiceFactory.createViewService();
        return new GetIssuesInView(this.initializedLogger.get(), configurationServiceWrapper, viewService, projectName, viewName);
    }

    public RunCoverityCommands createStepRunCoverityCommands(String workspaceRemotePath, OnCommandFailure onCommandFailure) throws CoverityJenkinsAbortException {
        return new RunCoverityCommands(this.initializedLogger.get(), this.initializedIntEnvrionmentVariables.get(), workspaceRemotePath, onCommandFailure, (VirtualChannel)this.initializedVirtualChannel.get());
    }

    public SubStep<Object, String> createStepCreateAuthenticationKeyFile(String workspaceRemotePath, String coverityServerUrl, String credentialsId) throws CoverityJenkinsAbortException {
        CoverityJenkinsIntLogger logger = this.initializedLogger.get();
        CoverityConnectInstance coverityConnectInstance = this.getCoverityConnectInstanceFromUrl(coverityServerUrl);
        Optional<String> authKeyContents = coverityConnectInstance.getAuthenticationKeyFileContents((IntLogger)logger, credentialsId);
        FilePath workspace = new FilePath((VirtualChannel)this.initializedVirtualChannel.get(), workspaceRemotePath);
        return SubStep.ofSupplier(() -> {
            if (authKeyContents.isPresent()) {
                FilePath authKeyFile = workspace.createTextTempFile("auth-key", ".txt", (String)authKeyContents.get());
                authKeyFile.chmod(384);
                return authKeyFile.getRemote();
            }
            return "";
        });
    }

    public SetUpCoverityEnvironment createStepSetUpCoverityEnvironment(List<ChangeLogSet<?>> changeLogSets, ConfigureChangeSetPatterns configureChangeSetPatterns, String workspaceRemotePath, String coverityServerUrl, String credentialsId, String projectName, String streamName, String viewName) throws CoverityJenkinsAbortException {
        CoverityJenkinsIntLogger logger = this.initializedLogger.get();
        IntEnvironmentVariables intEnvironmentVariables = this.initializedIntEnvrionmentVariables.get();
        VirtualChannel virtualChannel = (VirtualChannel)this.initializedVirtualChannel.get();
        FilePath intermediateDirectory = this.getIntermediateDirectory(workspaceRemotePath);
        String remoteIntermediateDirectory = intermediateDirectory.getRemote();
        CoverityConnectInstance coverityConnectInstance = this.getCoverityConnectInstanceFromUrl(coverityServerUrl);
        String coverityUsername = coverityConnectInstance.getUsername((IntLogger)logger, credentialsId).orElse(null);
        String coverityPassphrase = coverityConnectInstance.getPassphrase(credentialsId).orElse(null);
        String coverityToolHomeBin = new FilePath(virtualChannel, (String)this.validatedCoverityToolHome.get()).child("bin").getRemote();
        return new SetUpCoverityEnvironment(logger, intEnvironmentVariables, changeLogSets, configureChangeSetPatterns, coverityServerUrl, credentialsId, coverityUsername, coverityPassphrase, projectName, streamName, viewName, remoteIntermediateDirectory, coverityToolHomeBin);
    }

    public RemoteSubStep<Boolean> createStepValidateCoverityInstallation(boolean shouldValidateVersion) throws CoverityJenkinsAbortException {
        String coverityToolHome = (String)this.validatedCoverityToolHome.get();
        ValidateCoverityInstallation validateCoverityInstallation = new ValidateCoverityInstallation(this.initializedLogger.get(), shouldValidateVersion, coverityToolHome);
        return RemoteSubStep.of((VirtualChannel)((VirtualChannel)this.initializedVirtualChannel.get()), (Callable)validateCoverityInstallation);
    }

    public SubStep<Object, Object> createStepPopulateEnvVars(BiConsumer<String, String> environmentPopulator) {
        IntEnvironmentVariables intEnvironmentVariables = this.initializedIntEnvrionmentVariables.get();
        return SubStep.ofExecutor(() -> intEnvironmentVariables.getVariables().forEach(environmentPopulator));
    }

    public CoverityJenkinsIntLogger getOrCreateLogger() {
        IntEnvironmentVariables intEnvironmentVariables = this.getOrCreateEnvironmentVariables();
        if (this._logger == null) {
            JenkinsVersionHelper jenkinsVersionHelper = JenkinsWrapper.initializeFromJenkinsJVM().getVersionHelper();
            this._logger = CoverityJenkinsIntLogger.initializeLogger(this.listener, intEnvironmentVariables);
            this._logger.logInitializationMessage(jenkinsVersionHelper);
        }
        return this._logger;
    }

    public IntEnvironmentVariables getOrCreateEnvironmentVariables() {
        if (this._intEnvironmentVariables == null) {
            this._intEnvironmentVariables = IntEnvironmentVariables.empty();
            this._intEnvironmentVariables.putAll((Map)this.envVars);
        }
        return this._intEnvironmentVariables;
    }

    @Nonnull
    public String getCoverityToolHomeFromEnvironment() throws CoverityJenkinsAbortException {
        IntEnvironmentVariables intEnvironmentVariables = this.initializedIntEnvrionmentVariables.get();
        String coverityToolHome = intEnvironmentVariables.getValue(JenkinsCoverityEnvironmentVariable.COVERITY_TOOL_HOME.toString());
        if (StringUtils.isBlank((CharSequence)coverityToolHome)) {
            throw new CoverityJenkinsAbortException(String.format("Environment variable $%1$s is not set. Please set $%1$s to the path to your Coverity tool installation.", JenkinsCoverityEnvironmentVariable.COVERITY_TOOL_HOME.toString()));
        }
        return coverityToolHome;
    }

    public CoverityConnectInstance getCoverityConnectInstanceFromUrl(String coverityServerUrl) throws CoverityJenkinsAbortException {
        CoverityGlobalConfig coverityGlobalConfig = (CoverityGlobalConfig)((Object)GlobalConfiguration.all().get(CoverityGlobalConfig.class));
        if (coverityGlobalConfig == null) {
            throw new CoverityJenkinsAbortException("No Coverity global configuration detected in the Jenkins system configuration.");
        }
        List<CoverityConnectInstance> coverityConnectInstances = coverityGlobalConfig.getCoverityConnectInstances();
        if (coverityConnectInstances.isEmpty()) {
            throw new CoverityJenkinsAbortException("No Coverity connect instances are configured in the Jenkins system configuration.");
        }
        return coverityConnectInstances.stream().filter(instance -> instance.getUrl().equals(coverityServerUrl)).findFirst().orElseThrow(() -> new CoverityJenkinsAbortException("No Coverity conect instance with the url '" + coverityServerUrl + "' could be  found in the Jenkins system configuration."));
    }

    public WebServiceFactory getWebServiceFactoryFromUrl(String coverityServerUrl, String credentialsId) throws CoverityJenkinsAbortException {
        CoverityConnectInstance coverityConnectInstance = this.getCoverityConnectInstanceFromUrl(coverityServerUrl);
        CoverityJenkinsIntLogger logger = this.getOrCreateLogger();
        CoverityServerConfig coverityServerConfig = coverityConnectInstance.getCoverityServerConfig((IntLogger)logger, credentialsId);
        WebServiceFactory webServiceFactory = coverityServerConfig.createWebServiceFactory((IntLogger)logger);
        try {
            webServiceFactory.connect();
        }
        catch (CoverityIntegrationException e) {
            throw new CoverityJenkinsAbortException("An error occurred when connecting to Coverity Connect. Please ensure that you can connect properly.");
        }
        catch (MalformedURLException e) {
            throw CoverityJenkinsAbortException.fromMalformedUrlException(coverityServerUrl + "/ws/v9/configurationservice?wsdl", e);
        }
        return webServiceFactory;
    }

    public FilePath getIntermediateDirectory(String workspaceRemotePath) throws CoverityJenkinsAbortException {
        return new FilePath((VirtualChannel)this.initializedVirtualChannel.get(), workspaceRemotePath).child("idir");
    }

    public VirtualChannel getOrCreateVirtualChannel() throws CoverityJenkinsAbortException {
        block4: {
            block6: {
                block5: {
                    if (this._virtualChannel != null) break block4;
                    if (this.launcher != null) break block5;
                    if (this.node == null) break block6;
                }
                this._virtualChannel = Optional.ofNullable(this.launcher).map(Launcher::getChannel).orElseGet(() -> ((Node)this.node).getChannel());
            }
            if (this._virtualChannel == null) {
                throw new CoverityJenkinsAbortException("Node was either not connected or offline.");
            }
        }
        return this._virtualChannel;
    }
}

