/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.api.ws.configuration.ProjectDataObj;
import com.synopsys.integration.coverity.api.ws.configuration.StreamDataObj;
import com.synopsys.integration.coverity.exception.CoverityIntegrationException;
import com.synopsys.integration.jenkins.coverity.GlobalValueHelper;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.utils.ConnectionCachingFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.ProjectStreamCache;
import com.synopsys.integration.log.IntLogger;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProjectStreamFieldHelper
extends ConnectionCachingFieldHelper<ProjectStreamCache> {
    public ProjectStreamFieldHelper(IntLogger logger) {
        super(logger, () -> new ProjectStreamCache(logger));
    }

    public ComboBoxModel getProjectNamesForComboBox(String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId) throws InterruptedException {
        return this.doFillProjectNameItems(ComboBoxModel::new, Function.identity(), coverityInstanceUrl, overrideDefaultCredentialsId, credentialsId);
    }

    public ListBoxModel getProjectNamesForListBox(String coverityConnectUrl, Boolean overrideDefaultCredentialsId, String credentialsId) throws InterruptedException {
        return this.doFillProjectNameItems(ListBoxModel::new, this::wrapAsListBoxModelOption, coverityConnectUrl, overrideDefaultCredentialsId, credentialsId);
    }

    public ComboBoxModel getStreamNamesForComboBox(String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId, String selectedProjectName) throws InterruptedException {
        try {
            return this.getStreams(coverityInstanceUrl, overrideDefaultCredentialsId, credentialsId, selectedProjectName).stream().map(this::toStreamName).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(ComboBoxModel::new));
        }
        catch (CoverityIntegrationException ignored) {
            return new ComboBoxModel();
        }
    }

    public FormValidation checkForProjectInCache(String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId, String projectName) {
        try {
            return this.getProjects(coverityInstanceUrl, overrideDefaultCredentialsId, credentialsId).stream().map(this::toProjectName).filter(projectName::equals).findFirst().map(ignored -> FormValidation.ok()).orElseGet(() -> FormValidation.warning((String)String.format("If project '%s' does not exist it will be created with defaults the next time this job is run.", projectName)));
        }
        catch (CoverityIntegrationException e) {
            return FormValidation.error((Throwable)e, (String)e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FormValidation.error((Throwable)e, (String)e.getMessage());
        }
    }

    public FormValidation checkForStreamInCache(String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId, String projectName, String streamName) {
        try {
            return this.getStreams(coverityInstanceUrl, overrideDefaultCredentialsId, credentialsId, projectName).stream().map(this::toStreamName).filter(streamName::equals).findFirst().map(ignored -> FormValidation.ok()).orElseGet(() -> FormValidation.warning((String)String.format("If stream '%s' does not exist in project '%s' it will be created with defaults the next time this job is run", streamName, projectName)));
        }
        catch (CoverityIntegrationException e) {
            return FormValidation.error((Throwable)e, (String)e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FormValidation.error((Throwable)e, (String)e.getMessage());
        }
    }

    private <T, R extends Collection<T>> R doFillProjectNameItems(Supplier<R> supplier, Function<String, T> itemWrapper, String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId) throws InterruptedException {
        try {
            return (R)((Collection)this.getProjects(coverityInstanceUrl, overrideDefaultCredentialsId, credentialsId).stream().map(this::toProjectName).filter(StringUtils::isNotBlank).map(itemWrapper).collect(Collectors.toCollection(supplier)));
        }
        catch (CoverityIntegrationException ignored) {
            return (R)((Collection)supplier.get());
        }
    }

    private List<StreamDataObj> getStreams(String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId, String projectName) throws CoverityIntegrationException, InterruptedException {
        return this.getProjects(coverityInstanceUrl, overrideDefaultCredentialsId, credentialsId).stream().filter(projectDataObj -> this.isMatchingProject((ProjectDataObj)projectDataObj, projectName)).map(ProjectDataObj::getStreams).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ProjectDataObj> getProjects(String coverityInstanceUrl, Boolean overrideDefaultCredentialsId, String credentialsId) throws CoverityIntegrationException, InterruptedException {
        List<ProjectDataObj> projectDataObjs;
        CoverityConnectInstance coverityConnectInstance = GlobalValueHelper.getCoverityInstanceWithUrlOrDie(this.logger, coverityInstanceUrl);
        if (Boolean.TRUE.equals(overrideDefaultCredentialsId)) {
            ProjectStreamCache projectStreamCache = (ProjectStreamCache)this.getCache(coverityInstanceUrl, credentialsId);
            projectDataObjs = (List<ProjectDataObj>)projectStreamCache.getData(coverityConnectInstance, credentialsId);
        } else {
            ProjectStreamCache projectStreamCache = (ProjectStreamCache)this.getCache(coverityInstanceUrl, coverityConnectInstance.getDefaultCredentialsId());
            projectDataObjs = (List)projectStreamCache.getData(coverityConnectInstance, coverityConnectInstance.getDefaultCredentialsId());
        }
        return projectDataObjs != null ? projectDataObjs : Collections.emptyList();
    }

    private Boolean isMatchingProject(ProjectDataObj projectDataObj, String selectedProjectName) {
        return null != projectDataObj && null != projectDataObj.getId() && null != projectDataObj.getId().getName() && projectDataObj.getId().getName().equals(selectedProjectName);
    }

    private String toStreamName(StreamDataObj streamDataObj) {
        if (streamDataObj != null && streamDataObj.getId() != null) {
            return streamDataObj.getId().getName();
        }
        return null;
    }

    private String toProjectName(ProjectDataObj projectDataObj) {
        if (projectDataObj != null && projectDataObj.getId() != null) {
            return projectDataObj.getId().getName();
        }
        return null;
    }
}

