/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.api.ws.configuration.ConfigurationService;
import com.synopsys.integration.coverity.api.ws.configuration.CovRemoteServiceException_Exception;
import com.synopsys.integration.coverity.api.ws.configuration.ProjectDataObj;
import com.synopsys.integration.coverity.api.ws.configuration.ProjectFilterSpecDataObj;
import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectDataCache;
import com.synopsys.integration.log.IntLogger;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;

public class ProjectStreamCache
extends CoverityConnectDataCache<List<ProjectDataObj>> {
    public ProjectStreamCache(IntLogger logger) {
        super(logger);
    }

    @Override
    protected List<ProjectDataObj> getFreshData(WebServiceFactory webServiceFactory) {
        List projects = Collections.emptyList();
        try {
            this.logger.info("Attempting retrieval of Coverity Projects.");
            ConfigurationService configurationService = webServiceFactory.createConfigurationService();
            ProjectFilterSpecDataObj projectFilterSpecDataObj = new ProjectFilterSpecDataObj();
            projects = configurationService.getProjects(projectFilterSpecDataObj);
            this.logger.info("Completed retrieval of Coverity Projects.");
        }
        catch (CovRemoteServiceException_Exception | MalformedURLException e) {
            this.logger.error(e.getMessage());
            this.logger.trace("Stack trace:", e);
        }
        return projects;
    }

    @Override
    protected List<ProjectDataObj> getEmptyData() {
        return Collections.emptyList();
    }
}

