/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.exception.CoverityIntegrationException;
import com.synopsys.integration.jenkins.coverity.GlobalValueHelper;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.utils.ConnectionCachingFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.IssueViewCache;
import com.synopsys.integration.log.IntLogger;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class IssueViewFieldHelper
extends ConnectionCachingFieldHelper<IssueViewCache> {
    public IssueViewFieldHelper(IntLogger logger) {
        super(logger, () -> new IssueViewCache(logger));
    }

    public ListBoxModel getViewNamesForListBox(String coverityConnectUrl, Boolean overrideDefaultCredentials, String credentialsId) throws InterruptedException {
        try {
            return this.getViews(coverityConnectUrl, overrideDefaultCredentials, credentialsId).stream().filter(StringUtils::isNotBlank).map(this::wrapAsListBoxModelOption).collect(Collectors.toCollection(ListBoxModel::new));
        }
        catch (CoverityIntegrationException ignored) {
            return new ListBoxModel();
        }
    }

    private List<String> getViews(String coverityConnectUrl, Boolean overrideDefaultCredentials, String credentialsId) throws CoverityIntegrationException, InterruptedException {
        CoverityConnectInstance coverityConnectInstance = GlobalValueHelper.getCoverityInstanceWithUrlOrDie(this.logger, coverityConnectUrl);
        if (Boolean.TRUE.equals(overrideDefaultCredentials)) {
            IssueViewCache issueViewCache = (IssueViewCache)this.getCache(coverityConnectUrl, credentialsId);
            return (List)issueViewCache.getData(coverityConnectInstance, credentialsId);
        }
        IssueViewCache issueViewCache = (IssueViewCache)this.getCache(coverityConnectUrl, coverityConnectInstance.getDefaultCredentialsId());
        return (List)issueViewCache.getData(coverityConnectInstance, coverityConnectInstance.getDefaultCredentialsId());
    }
}

