/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.api.rest.ViewType;
import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.coverity.ws.view.ViewService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectDataCache;
import com.synopsys.integration.log.IntLogger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class IssueViewCache
extends CoverityConnectDataCache<List<String>> {
    public IssueViewCache(IntLogger logger) {
        super(logger);
    }

    @Override
    protected List<String> getFreshData(WebServiceFactory webServiceFactory) {
        List<String> data = Collections.emptyList();
        try {
            this.logger.info("Attempting retrieval of Coverity Views.");
            ViewService viewService = webServiceFactory.createViewService();
            data = viewService.getAllViewsOfType(ViewType.ISSUES).stream().map(view -> view.name).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            this.logger.info("Completed retrieval of Coverity Views.");
        }
        catch (IntegrationException | IOException e) {
            this.logger.error(e.getMessage());
            this.logger.trace("Stack trace:", e);
        }
        return data;
    }

    @Override
    protected List<String> getEmptyData() {
        return Collections.emptyList();
    }
}

