/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.utils;

import com.synopsys.integration.coverity.config.CoverityServerConfig;
import com.synopsys.integration.coverity.exception.CoverityIntegrationException;
import com.synopsys.integration.jenkins.coverity.GlobalValueHelper;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.utils.FieldHelper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.client.ConnectionResult;
import com.synopsys.integration.rest.credentials.Credentials;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.stream.Collectors;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;

public class CoverityConnectionFieldHelper
extends FieldHelper {
    public CoverityConnectionFieldHelper(IntLogger logger) {
        super(logger);
    }

    public ListBoxModel doFillCoverityInstanceUrlItems() {
        ListBoxModel listBoxModel = GlobalValueHelper.getGlobalCoverityConnectInstances().stream().map(CoverityConnectInstance::getUrl).map(this::wrapAsListBoxModelOption).collect(Collectors.toCollection(ListBoxModel::new));
        listBoxModel.add("- none -", "");
        return listBoxModel;
    }

    public FormValidation doCheckCoverityInstanceUrl(String coverityInstance, Boolean overrideDefaultCredentials, String credentialsId) {
        if (GlobalValueHelper.getGlobalCoverityConnectInstances().isEmpty()) {
            return FormValidation.error((String)"There are no Coverity instances configured");
        }
        if (StringUtils.isBlank((CharSequence)coverityInstance)) {
            return FormValidation.error((String)"Please choose one of the Coverity instances");
        }
        if (Boolean.TRUE.equals(overrideDefaultCredentials)) {
            return this.testConnectionIgnoreSuccessMessage(coverityInstance, credentialsId);
        }
        return this.testConnectionIgnoreSuccessMessage(coverityInstance);
    }

    public FormValidation doCheckCoverityInstanceUrlIgnoreMessage(String coverityInstance, Boolean overrideDefaultCredentials, String credentialsId) {
        FormValidation formValidation = this.doCheckCoverityInstanceUrl(coverityInstance, overrideDefaultCredentials, credentialsId);
        if (formValidation.kind.equals((Object)FormValidation.Kind.ERROR)) {
            return FormValidation.error((String)"Could not connect to selected Coverity instance.");
        }
        return FormValidation.ok();
    }

    public FormValidation testConnectionIgnoreSuccessMessage(String jenkinsCoverityInstanceUrl) {
        return GlobalValueHelper.getCoverityInstanceWithUrl(this.logger, jenkinsCoverityInstanceUrl).map(coverityConnectInstance -> this.testConnectionIgnoreSuccessMessage((CoverityConnectInstance)((Object)coverityConnectInstance), coverityConnectInstance.getDefaultCredentialsId())).orElse(FormValidation.error((String)"There are no Coverity instances configured with the name %s", (Object[])new Object[]{jenkinsCoverityInstanceUrl}));
    }

    public FormValidation testConnectionIgnoreSuccessMessage(String jenkinsCoverityInstanceUrl, String credentialsId) {
        return GlobalValueHelper.getCoverityInstanceWithUrl(this.logger, jenkinsCoverityInstanceUrl).map(coverityConnectInstance -> this.testConnectionIgnoreSuccessMessage((CoverityConnectInstance)((Object)coverityConnectInstance), credentialsId)).orElse(FormValidation.error((String)"There are no Coverity instances configured with the name %s", (Object[])new Object[]{jenkinsCoverityInstanceUrl}));
    }

    public FormValidation testConnectionToCoverityInstance(CoverityConnectInstance coverityConnectInstance, String credentialsId) {
        String url = coverityConnectInstance.getCoverityURL().map(URL::toString).orElse("");
        Credentials credentials = coverityConnectInstance.getCoverityServerCredentials(this.logger, credentialsId);
        return this.testConnectionTo(url, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormValidation testConnectionTo(String url, Credentials credentials) {
        FormValidation formValidation;
        Thread thread = Thread.currentThread();
        ClassLoader threadClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            CoverityServerConfig coverityServerConfig = CoverityServerConfig.newBuilder().setUrl(url).setCredentials(credentials).build();
            coverityServerConfig.createWebServiceFactory(this.logger).connect();
            ConnectionResult connectionResult = coverityServerConfig.attemptConnection(this.logger);
            if (connectionResult.isFailure()) {
                FormValidation formValidation2 = FormValidation.error((String)String.format("Could not connect to %s: %s (Status code: %s)", url, connectionResult.getFailureMessage().orElse(""), connectionResult.getHttpStatusCode()));
                return formValidation2;
            }
            FormValidation formValidation3 = FormValidation.ok((String)("Successfully connected to " + url));
            return formValidation3;
        }
        catch (MalformedURLException e) {
            formValidation = FormValidation.error((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
            return formValidation;
        }
        catch (WebServiceException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Unauthorized")) {
                formValidation = FormValidation.error((Throwable)e, (String)String.format("Web service error occurred when attempting to connect to %s%s%s: %s", url, System.lineSeparator(), ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()));
                return formValidation;
            }
            formValidation = FormValidation.error((Throwable)e, (String)String.format("User authentication failed when attempting to connect to %s%s%s: %s", url, System.lineSeparator(), ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()));
            return formValidation;
        }
        catch (CoverityIntegrationException | IllegalArgumentException e) {
            formValidation = FormValidation.error((Throwable)e, (String)e.getMessage());
            return formValidation;
        }
        catch (Exception e) {
            formValidation = FormValidation.error((Throwable)e, (String)String.format("An unexpected error occurred when attempting to connect to %s%s%s: %s", url, System.lineSeparator(), e.getClass().getSimpleName(), e.getMessage()));
            return formValidation;
        }
        finally {
            thread.setContextClassLoader(threadClassLoader);
        }
    }

    private FormValidation testConnectionIgnoreSuccessMessage(CoverityConnectInstance coverityConnectInstance, String credentialsId) {
        FormValidation connectionTest = this.testConnectionToCoverityInstance(coverityConnectInstance, credentialsId);
        if (FormValidation.Kind.OK.equals((Object)connectionTest.kind)) {
            return FormValidation.ok();
        }
        return connectionTest;
    }
}

