/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.global;

import com.synopsys.integration.coverity.config.CoverityServerConfig;
import com.synopsys.integration.jenkins.coverity.SynopsysCoverityCredentialsHelper;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectionFieldHelper;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.Slf4jIntLogger;
import com.synopsys.integration.rest.credentials.Credentials;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.LoggerFactory;

public class CoverityConnectInstance
extends AbstractDescribableImpl<CoverityConnectInstance> {
    private final String url;
    private final String defaultCredentialsId;
    private transient String credentialId;

    @DataBoundConstructor
    public CoverityConnectInstance(String url, String defaultCredentialsId) {
        this.url = url;
        this.defaultCredentialsId = defaultCredentialsId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getDefaultCredentialsId() {
        if (this.credentialId != null) {
            return this.credentialId;
        }
        return this.defaultCredentialsId;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<URL> getCoverityURL() {
        URL coverityUrl = null;
        if (this.url != null) {
            try {
                coverityUrl = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return Optional.ofNullable(coverityUrl);
    }

    public CoverityServerConfig getCoverityServerConfig(IntLogger logger, String credentialsId) throws IllegalArgumentException, IllegalStateException {
        return CoverityServerConfig.newBuilder().setUrl(this.url).setCredentials(this.getCoverityServerCredentials(logger, credentialsId)).build();
    }

    public Credentials getCoverityServerCredentials(IntLogger logger, String credentialId) {
        SynopsysCoverityCredentialsHelper synopsysCoverityCredentialsHelper = new SynopsysCoverityCredentialsHelper(logger, JenkinsWrapper.initializeFromJenkinsJVM());
        return synopsysCoverityCredentialsHelper.getIntegrationCredentialsById(credentialId);
    }

    public Optional<String> getUsername(IntLogger logger, String credentialId) {
        SynopsysCoverityCredentialsHelper synopsysCoverityCredentialsHelper = new SynopsysCoverityCredentialsHelper(logger, JenkinsWrapper.initializeFromJenkinsJVM());
        return synopsysCoverityCredentialsHelper.getCoverityUsernameById(credentialId);
    }

    public Optional<String> getPassphrase(String credentialId) {
        SynopsysCoverityCredentialsHelper synopsysCoverityCredentialsHelper = SynopsysCoverityCredentialsHelper.silentHelper(JenkinsWrapper.initializeFromJenkinsJVM());
        return synopsysCoverityCredentialsHelper.getCoverityPassphraseById(credentialId);
    }

    public Optional<String> getAuthenticationKeyFileContents(IntLogger logger, String credentialId) throws CoverityJenkinsAbortException {
        SynopsysCoverityCredentialsHelper synopsysCoverityCredentialsHelper = new SynopsysCoverityCredentialsHelper(logger, JenkinsWrapper.initializeFromJenkinsJVM());
        Optional<FileCredentials> authenticationKeyFileCredentials = synopsysCoverityCredentialsHelper.getAuthenticationKeyFileCredentialsById(credentialId);
        String contents = null;
        if (authenticationKeyFileCredentials.isPresent()) {
            try (InputStream inputStream = authenticationKeyFileCredentials.get().getContent();){
                contents = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new CoverityJenkinsAbortException("Authentication Key File could not be read from the Synopsys Coverity for Jenkins global configuration.");
            }
        }
        return Optional.ofNullable(contents);
    }

    public boolean isEmpty() {
        return null == this.url && null == this.defaultCredentialsId;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CoverityConnectInstance> {
        private final CoverityConnectionFieldHelper coverityConnectionFieldHelper;
        private final SynopsysCoverityCredentialsHelper credentialsHelper;

        public DescriptorImpl() {
            super(CoverityConnectInstance.class);
            this.load();
            Slf4jIntLogger slf4jIntLogger = new Slf4jIntLogger(LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
            this.coverityConnectionFieldHelper = new CoverityConnectionFieldHelper((IntLogger)slf4jIntLogger);
            this.credentialsHelper = new SynopsysCoverityCredentialsHelper((IntLogger)slf4jIntLogger, JenkinsWrapper.initializeFromJenkinsJVM());
        }

        public FormValidation doCheckUrl(@QueryParameter(value="url") String url) {
            JenkinsWrapper.initializeFromJenkinsJVM().getJenkins().ifPresent(jenkins -> jenkins.checkPermission(Jenkins.ADMINISTER));
            if (StringUtils.isBlank((CharSequence)url)) {
                return FormValidation.error((String)"Please provide a URL for the Coverity Connect instance.");
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)String.format("The provided URL for the Coverity Connect instance is not a valid URL. Error: %s", e.getMessage()));
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillDefaultCredentialsIdItems() {
            return this.credentialsHelper.listSupportedCredentials();
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="url") String url, @QueryParameter(value="defaultCredentialsId") String defaultCredentialsId) {
            JenkinsWrapper.initializeFromJenkinsJVM().getJenkins().ifPresent(jenkins -> jenkins.checkPermission(Jenkins.ADMINISTER));
            FormValidation urlValidation = this.doCheckUrl(url);
            if (!FormValidation.Kind.OK.equals((Object)urlValidation.kind)) {
                return urlValidation;
            }
            if (StringUtils.isBlank((CharSequence)defaultCredentialsId)) {
                return FormValidation.error((String)"Please specify the credentials for the Coverity Connect instance.");
            }
            CoverityConnectInstance coverityConnectInstance = new CoverityConnectInstance(url, defaultCredentialsId);
            return this.coverityConnectionFieldHelper.testConnectionToCoverityInstance(coverityConnectInstance, defaultCredentialsId);
        }
    }
}

