/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.buildstep;

import com.synopsys.integration.jenkins.coverity.extensions.CoverityAnalysisType;
import com.synopsys.integration.jenkins.coverity.extensions.CoverityCaptureType;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.CommandArguments;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.CoverityRunConfiguration;
import com.synopsys.integration.jenkins.extensions.JenkinsSelectBoxEnum;
import com.synopsys.integration.jenkins.wrapper.JenkinsSerializationHelper;
import hudson.Extension;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SimpleCoverityRunConfiguration
extends CoverityRunConfiguration {
    private final CommandArguments commandArguments;
    private final CoverityAnalysisType coverityAnalysisType;
    private final String sourceArgument;
    @Nullable
    private String customWorkingDirectory;
    @Nullable
    private CoverityCaptureType coverityCaptureType;
    @Nullable
    private Integer changeSetAnalysisThreshold;

    @DataBoundConstructor
    public SimpleCoverityRunConfiguration(CoverityAnalysisType coverityAnalysisType, String sourceArgument, CommandArguments commandArguments) {
        this.coverityAnalysisType = coverityAnalysisType;
        this.sourceArgument = sourceArgument;
        this.commandArguments = commandArguments;
    }

    public static SimpleCoverityRunConfiguration DEFAULT_CONFIGURATION() {
        SimpleCoverityRunConfiguration defaultCoverityRunConfiguration = new SimpleCoverityRunConfiguration(CoverityAnalysisType.COV_ANALYZE, "", null);
        defaultCoverityRunConfiguration.setCoverityCaptureType(CoverityCaptureType.COV_BUILD);
        defaultCoverityRunConfiguration.setChangeSetAnalysisThreshold(100);
        return defaultCoverityRunConfiguration;
    }

    public String getSourceArgument() {
        return this.sourceArgument;
    }

    public CommandArguments getCommandArguments() {
        return this.commandArguments;
    }

    public CoverityAnalysisType getCoverityAnalysisType() {
        return this.coverityAnalysisType;
    }

    public CoverityAnalysisType getDefaultCoverityAnalysisType() {
        return CoverityAnalysisType.COV_ANALYZE;
    }

    public int getChangeSetAnalysisThreshold() {
        if (this.changeSetAnalysisThreshold == null) {
            return 0;
        }
        return this.changeSetAnalysisThreshold;
    }

    @DataBoundSetter
    public void setChangeSetAnalysisThreshold(Integer changeSetAnalysisThreshold) {
        this.changeSetAnalysisThreshold = changeSetAnalysisThreshold;
    }

    public String getCustomWorkingDirectory() {
        return this.customWorkingDirectory;
    }

    @DataBoundSetter
    public void setCustomWorkingDirectory(String customWorkingDirectory) {
        this.customWorkingDirectory = customWorkingDirectory;
    }

    public CoverityCaptureType getCoverityCaptureType() {
        return this.coverityCaptureType;
    }

    @DataBoundSetter
    public void setCoverityCaptureType(CoverityCaptureType coverityCaptureType) {
        this.coverityCaptureType = coverityCaptureType;
    }

    public CoverityCaptureType getDefaultCoverityCaptureType() {
        return CoverityCaptureType.COV_BUILD;
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public CoverityRunConfiguration.RunConfigurationType getRunConFigurationType() {
        return CoverityRunConfiguration.RunConfigurationType.SIMPLE;
    }

    static {
        JenkinsSerializationHelper.migrateFieldFrom((String)"buildCommand", SimpleCoverityRunConfiguration.class, (String)"sourceArgument");
    }

    @Extension
    public static class DescriptorImpl
    extends CoverityRunConfiguration.RunConfigurationDescriptor {
        public DescriptorImpl() {
            super(SimpleCoverityRunConfiguration.class);
            this.load();
        }

        public ListBoxModel doFillCoverityCaptureTypeItems() {
            return JenkinsSelectBoxEnum.toListBoxModel((JenkinsSelectBoxEnum[])CoverityCaptureType.values());
        }

        public ListBoxModel doFillCoverityAnalysisTypeItems() {
            return JenkinsSelectBoxEnum.toListBoxModel((JenkinsSelectBoxEnum[])CoverityAnalysisType.values());
        }

        @Nonnull
        public String getDisplayName() {
            return CoverityRunConfiguration.RunConfigurationType.SIMPLE.getDisplayName();
        }
    }
}

