/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.coverity.extensions.buildstep;

import com.synopsys.integration.coverity.ws.WebServiceFactory;
import com.synopsys.integration.function.ThrowingSupplier;
import com.synopsys.integration.jenkins.coverity.CoverityJenkinsIntLogger;
import com.synopsys.integration.jenkins.coverity.SynopsysCoverityCredentialsHelper;
import com.synopsys.integration.jenkins.coverity.exception.CoverityJenkinsAbortException;
import com.synopsys.integration.jenkins.coverity.extensions.CheckForIssuesInView;
import com.synopsys.integration.jenkins.coverity.extensions.CleanUpAction;
import com.synopsys.integration.jenkins.coverity.extensions.ConfigureChangeSetPatterns;
import com.synopsys.integration.jenkins.coverity.extensions.OnCommandFailure;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.CoverityBuildStepWorkflow;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.CoverityRunConfiguration;
import com.synopsys.integration.jenkins.coverity.extensions.buildstep.SimpleCoverityRunConfiguration;
import com.synopsys.integration.jenkins.coverity.extensions.global.CoverityConnectInstance;
import com.synopsys.integration.jenkins.coverity.extensions.utils.CoverityConnectionFieldHelper;
import com.synopsys.integration.jenkins.coverity.extensions.utils.ProjectStreamFieldHelper;
import com.synopsys.integration.jenkins.coverity.stepworkflow.CoverityWorkflowStepFactory;
import com.synopsys.integration.jenkins.extensions.JenkinsSelectBoxEnum;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.Slf4jIntLogger;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.LoggerFactory;

public class CoverityBuildStep
extends Builder {
    public static final String FIELD_COVERITY_INSTANCE_URL = "coverityInstanceUrl";
    public static final String FIELD_PROJECT_NAME = "projectName";
    public static final String FIELD_STREAM_NAME = "streamName";
    public static final String NESTED_DESCRIPTOR_CHECK_FOR_ISSUES = "checkForIssuesInView";
    public static final String NESTED_DESCRIPTOR_CONFIGURE_CHANGE_SET_PATTERNS = "configureChangeSetPatterns";
    public static final String NESTED_DESCRIPTOR_COVERITY_RUN_CONFIGURATION = "coverityRunConfiguration";
    public static final String FIELD_ON_COMMAND_FAILURE = "onCommandFailure";
    public static final String FIELD_CLEAN_UP_ACTION = "cleanUpAction";
    public static final String FIELD_OVERRIDE_CREDENTIALS = "overrideDefaultCredentials";
    public static final String FIELD_CREDENTIALS_ID = "credentialsId";
    private final String coverityInstanceUrl;
    private final String projectName;
    private final String streamName;
    private final CheckForIssuesInView checkForIssuesInView;
    private final ConfigureChangeSetPatterns configureChangeSetPatterns;
    private final CoverityRunConfiguration coverityRunConfiguration;
    private final OnCommandFailure onCommandFailure;
    @Nullable
    private CleanUpAction cleanUpAction;
    @Nullable
    private String credentialsId;
    @Nullable
    private Boolean overrideDefaultCredentials;

    @DataBoundConstructor
    public CoverityBuildStep(String coverityInstanceUrl, String onCommandFailure, String projectName, String streamName, CheckForIssuesInView checkForIssuesInView, ConfigureChangeSetPatterns configureChangeSetPatterns, CoverityRunConfiguration coverityRunConfiguration) {
        this.coverityInstanceUrl = coverityInstanceUrl;
        this.projectName = projectName;
        this.streamName = streamName;
        this.checkForIssuesInView = checkForIssuesInView;
        this.configureChangeSetPatterns = configureChangeSetPatterns;
        this.coverityRunConfiguration = coverityRunConfiguration;
        this.onCommandFailure = OnCommandFailure.valueOf(onCommandFailure);
    }

    public CleanUpAction getCleanUpAction() {
        return this.cleanUpAction;
    }

    @DataBoundSetter
    public void setCleanUpAction(CleanUpAction cleanUpAction) {
        this.cleanUpAction = cleanUpAction;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public Boolean getOverrideDefaultCredentials() {
        return this.overrideDefaultCredentials;
    }

    @DataBoundSetter
    public void setOverrideDefaultCredentials(Boolean overrideDefaultCredentials) {
        this.overrideDefaultCredentials = overrideDefaultCredentials;
    }

    public String getCoverityInstanceUrl() {
        return this.coverityInstanceUrl;
    }

    public OnCommandFailure getOnCommandFailure() {
        return this.onCommandFailure;
    }

    public ConfigureChangeSetPatterns getConfigureChangeSetPatterns() {
        return this.configureChangeSetPatterns;
    }

    public CheckForIssuesInView getCheckForIssuesInView() {
        return this.checkForIssuesInView;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public CoverityRunConfiguration getCoverityRunConfiguration() {
        return this.coverityRunConfiguration;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String resolvedCredentialsId;
        String remoteWorkingDirectoryPath = this.computeRemoteWorkingDirectory(this.coverityRunConfiguration, build.getWorkspace(), build.getProject());
        CoverityWorkflowStepFactory coverityWorkflowStepFactory = new CoverityWorkflowStepFactory(build.getEnvironment((TaskListener)listener), build.getBuiltOn(), launcher, (TaskListener)listener);
        CoverityJenkinsIntLogger logger = coverityWorkflowStepFactory.getOrCreateLogger();
        JenkinsVersionHelper jenkinsVersionHelper = JenkinsWrapper.initializeFromJenkinsJVM().getVersionHelper();
        if (Boolean.TRUE.equals(this.overrideDefaultCredentials)) {
            resolvedCredentialsId = this.credentialsId;
        } else {
            CoverityConnectInstance coverityConnectInstance = coverityWorkflowStepFactory.getCoverityConnectInstanceFromUrl(this.coverityInstanceUrl);
            resolvedCredentialsId = coverityConnectInstance.getDefaultCredentialsId();
        }
        CoverityBuildStepWorkflow coverityBuildStepWorkflow = new CoverityBuildStepWorkflow(logger, jenkinsVersionHelper, (ThrowingSupplier<WebServiceFactory, CoverityJenkinsAbortException>)((ThrowingSupplier)() -> coverityWorkflowStepFactory.getWebServiceFactoryFromUrl(this.coverityInstanceUrl, resolvedCredentialsId)), coverityWorkflowStepFactory, build, remoteWorkingDirectoryPath, this.coverityInstanceUrl, resolvedCredentialsId, this.projectName, this.streamName, this.coverityRunConfiguration, this.configureChangeSetPatterns, this.checkForIssuesInView, this.onCommandFailure, this.cleanUpAction);
        return coverityBuildStepWorkflow.perform();
    }

    private String computeRemoteWorkingDirectory(CoverityRunConfiguration coverityRunConfiguration, FilePath buildWorkspace, AbstractProject<?, ?> project) {
        String customWorkingDirectory;
        boolean isDefaultCoverityWorkflow = CoverityRunConfiguration.RunConfigurationType.SIMPLE.equals((Object)coverityRunConfiguration.getRunConFigurationType());
        String string = customWorkingDirectory = isDefaultCoverityWorkflow ? ((SimpleCoverityRunConfiguration)coverityRunConfiguration).getCustomWorkingDirectory() : null;
        if (StringUtils.isNotBlank((String)customWorkingDirectory)) {
            return customWorkingDirectory;
        }
        if (buildWorkspace != null) {
            return buildWorkspace.getRemote();
        }
        return project.getCustomWorkspace();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private final CoverityConnectionFieldHelper coverityConnectionFieldHelper;
        private final ProjectStreamFieldHelper projectStreamFieldHelper;
        private final SynopsysCoverityCredentialsHelper credentialsHelper;

        public DescriptorImpl() {
            super(CoverityBuildStep.class);
            this.load();
            Slf4jIntLogger slf4jIntLogger = new Slf4jIntLogger(LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
            this.coverityConnectionFieldHelper = new CoverityConnectionFieldHelper((IntLogger)slf4jIntLogger);
            this.projectStreamFieldHelper = new ProjectStreamFieldHelper((IntLogger)slf4jIntLogger);
            this.credentialsHelper = new SynopsysCoverityCredentialsHelper((IntLogger)slf4jIntLogger, JenkinsWrapper.initializeFromJenkinsJVM());
        }

        @Nonnull
        public String getDisplayName() {
            return "Execute Synopsys Coverity static analysis";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillCoverityInstanceUrlItems() {
            return this.coverityConnectionFieldHelper.doFillCoverityInstanceUrlItems();
        }

        public ListBoxModel doFillCredentialsIdItems() {
            return this.credentialsHelper.listSupportedCredentials();
        }

        public FormValidation doCheckCoverityInstanceUrl(@QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="overrideDefaultCredentials") Boolean overrideDefaultCredentials, @QueryParameter(value="credentialsId") String credentialsId) {
            return this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrl(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
        }

        public ComboBoxModel doFillProjectNameItems(@QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="overrideDefaultCredentials") Boolean overrideDefaultCredentials, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="updateNow") boolean updateNow) throws InterruptedException {
            if (updateNow) {
                this.projectStreamFieldHelper.updateNow(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
            }
            return this.projectStreamFieldHelper.getProjectNamesForComboBox(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
        }

        public FormValidation doCheckProjectName(@QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="overrideDefaultCredentials") Boolean overrideDefaultCredentials, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="projectName") String projectName) {
            FormValidation urlValidation = this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrlIgnoreMessage(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
            if (urlValidation.kind == FormValidation.Kind.ERROR) {
                return urlValidation;
            }
            return this.projectStreamFieldHelper.checkForProjectInCache(coverityInstanceUrl, overrideDefaultCredentials, credentialsId, projectName);
        }

        public ComboBoxModel doFillStreamNameItems(@QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="overrideDefaultCredentials") Boolean overrideDefaultCredentials, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="projectName") String projectName) throws InterruptedException {
            return this.projectStreamFieldHelper.getStreamNamesForComboBox(coverityInstanceUrl, overrideDefaultCredentials, credentialsId, projectName);
        }

        public FormValidation doCheckStreamName(@QueryParameter(value="coverityInstanceUrl") String coverityInstanceUrl, @QueryParameter(value="overrideDefaultCredentials") Boolean overrideDefaultCredentials, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="streamName") String streamName) {
            FormValidation urlValidation = this.coverityConnectionFieldHelper.doCheckCoverityInstanceUrlIgnoreMessage(coverityInstanceUrl, overrideDefaultCredentials, credentialsId);
            if (urlValidation.kind == FormValidation.Kind.ERROR) {
                return urlValidation;
            }
            return this.projectStreamFieldHelper.checkForStreamInCache(coverityInstanceUrl, overrideDefaultCredentials, credentialsId, projectName, streamName);
        }

        public ListBoxModel doFillOnCommandFailureItems() {
            return JenkinsSelectBoxEnum.toListBoxModel((JenkinsSelectBoxEnum[])OnCommandFailure.values());
        }

        public ListBoxModel doFillCleanUpActionItems() {
            return JenkinsSelectBoxEnum.toListBoxModel((JenkinsSelectBoxEnum[])CleanUpAction.values());
        }

        public CoverityRunConfiguration getDefaultCoverityRunConfiguration() {
            return SimpleCoverityRunConfiguration.DEFAULT_CONFIGURATION();
        }
    }
}

