/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.swarm.KeepSwarmClientNodeProperty;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class SwarmLauncher
extends JNLPLauncher {
    private static final Logger LOGGER = Logger.getLogger(SwarmLauncher.class.getName());

    public SwarmLauncher() {
        super(false);
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        block5: {
            super.afterDisconnect(computer, listener);
            Slave node = computer.getNode();
            if (node != null) {
                String nodeName = node.getNodeName();
                try {
                    KeepSwarmClientNodeProperty keepClientProp = (KeepSwarmClientNodeProperty)node.getNodeProperty(KeepSwarmClientNodeProperty.class);
                    if (keepClientProp == null) {
                        LOGGER.log(Level.INFO, "Removing Swarm Node for computer [{0}]", nodeName);
                        Jenkins.get().removeNode((Node)node);
                        break block5;
                    }
                    listener.getLogger().printf("Skipping removal of Node for computer [%1$s]", nodeName);
                    LOGGER.log(Level.INFO, "Skipping removal of Node for computer [{0}]", nodeName);
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error("Failed to remove node [%1$s]", new Object[]{nodeName}));
                    LOGGER.log(Level.WARNING, String.format("Failed to remove node [%1$s] %n%2$s", nodeName, Functions.printThrowable((Throwable)e).trim()));
                }
            } else {
                listener.getLogger().printf("Node for computer [%1$s] appears to have been removed already%n", computer);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @NonNull
        public String getDisplayName() {
            return "Launch Swarm agent";
        }
    }
}

