/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.Plugin;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.swarm.KeepSwarmClientNodeProperty;
import hudson.plugins.swarm.SwarmSlave;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationNodeProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class PluginImpl
extends Plugin {
    private Node getNodeByName(String name, StaplerResponse rsp) throws IOException {
        Jenkins jenkins = Jenkins.get();
        Node node = jenkins.getNode(name);
        if (node == null) {
            rsp.setStatus(404);
            rsp.setContentType("text/plain; UTF-8");
            rsp.getWriter().printf("Agent \"%s\" does not exist.%n", name);
            return null;
        }
        return node;
    }

    public void doGetSlaveLabels(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name) throws IOException {
        Node node = this.getNodeByName(name, rsp);
        if (node == null) {
            return;
        }
        this.normalResponse(req, rsp, node.getLabelString());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive for try-with-resources in Java 11")
    private void normalResponse(StaplerRequest req, StaplerResponse rsp, String sLabelList) throws IOException {
        rsp.setContentType("text/xml");
        try (Writer writer = rsp.getCompressedWriter((HttpServletRequest)req);){
            writer.write("<labelResponse><labels>" + sLabelList + "</labels></labelResponse>");
        }
    }

    @POST
    public void doAddSlaveLabels(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String labels) throws IOException {
        Node node = this.getNodeByName(name, rsp);
        if (node == null) {
            return;
        }
        node.checkPermission(Computer.CONFIGURE);
        LinkedHashSet<String> currentLabels = PluginImpl.stringToSet(node.getLabelString());
        LinkedHashSet<String> labelsToAdd = PluginImpl.stringToSet(labels);
        currentLabels.addAll(labelsToAdd);
        node.setLabelString(PluginImpl.setToString(currentLabels));
        this.normalResponse(req, rsp, node.getLabelString());
    }

    private static String setToString(Set<String> labels) {
        return String.join((CharSequence)" ", labels);
    }

    private static LinkedHashSet<String> stringToSet(String labels) {
        return new LinkedHashSet<String>(Arrays.asList(labels.split("\\s+")));
    }

    @POST
    public void doRemoveSlaveLabels(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String labels) throws IOException {
        Node node = this.getNodeByName(name, rsp);
        if (node == null) {
            return;
        }
        node.checkPermission(Computer.CONFIGURE);
        LinkedHashSet<String> currentLabels = PluginImpl.stringToSet(node.getLabelString());
        LinkedHashSet<String> labelsToRemove = PluginImpl.stringToSet(labels);
        currentLabels.removeAll(labelsToRemove);
        node.setLabelString(PluginImpl.setToString(currentLabels));
        this.normalResponse(req, rsp, node.getLabelString());
    }

    @POST
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive for try-with-resources in Java 11")
    public void doCreateSlave(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter(fixEmpty=true) String description, @QueryParameter int executors, @QueryParameter String remoteFsRoot, @QueryParameter String labels, @QueryParameter Node.Mode mode, @QueryParameter(fixEmpty=true) String hash, @QueryParameter boolean deleteExistingClients, @QueryParameter boolean keepDisconnectedClients) throws IOException {
        Computer computer;
        Node node;
        Object[] environmentVariables;
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Computer.CREATE);
        ArrayList<Object> nodeProperties = new ArrayList<Object>();
        Object[] toolLocations = req.getParameterValues("toolLocation");
        if (!ArrayUtils.isEmpty((Object[])toolLocations)) {
            List<ToolLocationNodeProperty.ToolLocation> parsedToolLocations = PluginImpl.parseToolLocations((String[])toolLocations);
            nodeProperties.add(new ToolLocationNodeProperty(parsedToolLocations));
        }
        if (!ArrayUtils.isEmpty((Object[])(environmentVariables = req.getParameterValues("environmentVariable")))) {
            List<EnvironmentVariablesNodeProperty.Entry> parsedEnvironmentVariables = PluginImpl.parseEnvironmentVariables((String[])environmentVariables);
            nodeProperties.add(new EnvironmentVariablesNodeProperty(parsedEnvironmentVariables));
        }
        if (keepDisconnectedClients) {
            nodeProperties.add((Object)new KeepSwarmClientNodeProperty());
        }
        if (hash == null && jenkins.getNode(name) != null && !deleteExistingClients) {
            rsp.setStatus(409);
            rsp.setContentType("text/plain; UTF-8");
            rsp.getWriter().printf("Agent \"%s\" already exists.%n", name);
            return;
        }
        if (hash != null) {
            name = name + '-' + hash;
        }
        if ((node = jenkins.getNode(name)) != null && !deleteExistingClients && (computer = node.toComputer()) != null && computer.isOnline()) {
            rsp.setStatus(409);
            rsp.setContentType("text/plain; UTF-8");
            rsp.getWriter().printf("Agent \"%s\" is already created and on-line.%n", name);
            return;
        }
        try {
            String nodeDescription = "Swarm agent from " + req.getRemoteHost();
            if (description != null) {
                nodeDescription = nodeDescription + ": " + description;
            }
            SwarmSlave agent = new SwarmSlave(name, nodeDescription, remoteFsRoot, String.valueOf(executors), mode, "swarm " + Util.fixNull((String)labels), nodeProperties);
            jenkins.addNode((Node)agent);
            rsp.setContentType("text/plain; charset=iso-8859-1");
            try (OutputStream outputStream = rsp.getCompressedOutputStream((HttpServletRequest)req);){
                Properties props = new Properties();
                props.put("name", name);
                props.store(outputStream, "");
            }
        }
        catch (Descriptor.FormException e) {
            Functions.printStackTrace((Throwable)e, (PrintStream)System.err);
        }
    }

    private static List<ToolLocationNodeProperty.ToolLocation> parseToolLocations(String[] toolLocations) {
        ArrayList<ToolLocationNodeProperty.ToolLocation> result = new ArrayList<ToolLocationNodeProperty.ToolLocation>();
        for (String toolLocKeyValue : toolLocations) {
            boolean found = false;
            String[] toolLoc = toolLocKeyValue.split(":", 2);
            for (ToolDescriptor desc : ToolInstallation.all()) {
                for (ToolInstallation inst : desc.getInstallations()) {
                    if (!inst.getName().equals(toolLoc[0])) continue;
                    found = true;
                    String location = toolLoc[1];
                    ToolLocationNodeProperty.ToolLocation toolLocation = new ToolLocationNodeProperty.ToolLocation(desc, inst.getName(), location);
                    result.add(toolLocation);
                }
            }
            if (found) continue;
            throw new RuntimeException("No tool '" + toolLoc[0] + "' is defined on Jenkins.");
        }
        return result;
    }

    private static List<EnvironmentVariablesNodeProperty.Entry> parseEnvironmentVariables(String[] environmentVariables) {
        ArrayList<EnvironmentVariablesNodeProperty.Entry> result = new ArrayList<EnvironmentVariablesNodeProperty.Entry>();
        for (String environmentVariable : environmentVariables) {
            String[] keyValue = environmentVariable.split(":", 2);
            EnvironmentVariablesNodeProperty.Entry var = new EnvironmentVariablesNodeProperty.Entry(keyValue[0], keyValue[1]);
            result.add(var);
        }
        return result;
    }
}

