/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Plugin;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.swarm.SwarmSlave;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.SlaveComputer;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationNodeProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PluginImpl
extends Plugin {
    private static final UUID secret = UUID.randomUUID();

    private Node getNodeByName(String name, StaplerResponse rsp) throws IOException {
        Jenkins jenkins = Jenkins.get();
        try {
            Node n = jenkins.getNode(name);
            if (n == null) {
                rsp.setStatus(404);
                rsp.setContentType("text/plain; UTF-8");
                rsp.getWriter().printf("A slave called '%s' does not exist.%n", name);
                return null;
            }
            return n;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void doGetSlaveLabels(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String secret) throws IOException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        Node nn = this.getNodeByName(name, rsp);
        if (nn == null) {
            return;
        }
        this.normalResponse(req, rsp, nn.getLabelString());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive for try-with-resources in Java 11")
    private void normalResponse(StaplerRequest req, StaplerResponse rsp, String sLabelList) throws IOException {
        rsp.setContentType("text/xml");
        try (Writer w = rsp.getCompressedWriter((HttpServletRequest)req);){
            w.write("<labelResponse><labels>" + sLabelList + "</labels></labelResponse>");
        }
    }

    public void doAddSlaveLabels(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String secret, @QueryParameter String labels) throws IOException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        Node nn = this.getNodeByName(name, rsp);
        if (nn == null) {
            return;
        }
        String sCurrentLabels = nn.getLabelString();
        List<String> lCurrentLabels = Arrays.asList(sCurrentLabels.split("\\s+"));
        HashSet<String> hs = new HashSet<String>(lCurrentLabels);
        List<String> lNewLabels = Arrays.asList(labels.split("\\s+"));
        hs.addAll(lNewLabels);
        nn.setLabelString(PluginImpl.setToString(hs));
        nn.getAssignedLabels();
        this.normalResponse(req, rsp, nn.getLabelString());
    }

    private static String setToString(Set<String> labels) {
        return String.join((CharSequence)" ", labels);
    }

    public void doRemoveSlaveLabels(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String secret, @QueryParameter String labels) throws IOException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        Node nn = this.getNodeByName(name, rsp);
        if (nn == null) {
            return;
        }
        String sCurrentLabels = nn.getLabelString();
        List<String> lCurrentLabels = Arrays.asList(sCurrentLabels.split("\\s+"));
        HashSet<String> hs = new HashSet<String>(lCurrentLabels);
        List<String> lBadLabels = Arrays.asList(labels.split("\\s+"));
        hs.removeAll(lBadLabels);
        nn.setLabelString(PluginImpl.setToString(hs));
        nn.getAssignedLabels();
        this.normalResponse(req, rsp, nn.getLabelString());
    }

    public void doCreateSlave(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String description, @QueryParameter int executors, @QueryParameter String remoteFsRoot, @QueryParameter String labels, @QueryParameter String secret, @QueryParameter Node.Mode mode, @QueryParameter(fixEmpty=true) String hash, @QueryParameter boolean deleteExistingClients) throws IOException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        try {
            Computer c;
            Node n;
            Object[] environmentVariables;
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(SlaveComputer.CREATE);
            ArrayList<Object> nodeProperties = new ArrayList<Object>();
            Object[] toolLocations = req.getParameterValues("toolLocation");
            if (!ArrayUtils.isEmpty((Object[])toolLocations)) {
                List<ToolLocationNodeProperty.ToolLocation> parsedToolLocations = PluginImpl.parseToolLocations((String[])toolLocations);
                nodeProperties.add(new ToolLocationNodeProperty(parsedToolLocations));
            }
            if (!ArrayUtils.isEmpty((Object[])(environmentVariables = req.getParameterValues("environmentVariable")))) {
                List<EnvironmentVariablesNodeProperty.Entry> parsedEnvironmentVariables = PluginImpl.parseEnvironmentVariables((String[])environmentVariables);
                nodeProperties.add(new EnvironmentVariablesNodeProperty(parsedEnvironmentVariables));
            }
            if (hash == null && jenkins.getNode(name) != null && !deleteExistingClients) {
                rsp.setStatus(409);
                rsp.setContentType("text/plain; UTF-8");
                rsp.getWriter().printf("A slave called '%s' already exists and legacy clients do not support name disambiguation%n", name);
                return;
            }
            if (hash != null) {
                name = name + '-' + hash;
            }
            if ((n = jenkins.getNode(name)) != null && !deleteExistingClients && (c = n.toComputer()) != null && c.isOnline()) {
                rsp.setStatus(409);
                rsp.setContentType("text/plain; UTF-8");
                rsp.getWriter().printf("A slave called '%s' is already created and on-line%n", name);
                return;
            }
            SwarmSlave slave = new SwarmSlave(name, "Swarm slave from " + req.getRemoteHost() + (description == null || description.isEmpty() ? "" : ": " + description), remoteFsRoot, String.valueOf(executors), mode, "swarm " + Util.fixNull((String)labels), nodeProperties);
            jenkins.addNode((Node)slave);
            rsp.setContentType("text/plain; charset=iso-8859-1");
            Properties props = new Properties();
            props.put("name", name);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            props.store(bos, "");
            byte[] response = bos.toByteArray();
            rsp.setContentLength(response.length);
            ServletOutputStream outputStream = rsp.getOutputStream();
            outputStream.write(response);
            outputStream.flush();
        }
        catch (Descriptor.FormException e) {
            e.printStackTrace();
        }
    }

    private static List<ToolLocationNodeProperty.ToolLocation> parseToolLocations(String[] toolLocations) {
        ArrayList<ToolLocationNodeProperty.ToolLocation> result = new ArrayList<ToolLocationNodeProperty.ToolLocation>();
        for (String toolLocKeyValue : toolLocations) {
            boolean found = false;
            String[] toolLoc = toolLocKeyValue.split(":", 2);
            for (ToolDescriptor desc : ToolInstallation.all()) {
                for (ToolInstallation inst : desc.getInstallations()) {
                    if (!inst.getName().equals(toolLoc[0])) continue;
                    found = true;
                    String location = toolLoc[1];
                    ToolLocationNodeProperty.ToolLocation toolLocation = new ToolLocationNodeProperty.ToolLocation(desc, inst.getName(), location);
                    result.add(toolLocation);
                }
            }
            if (found) continue;
            throw new RuntimeException("No tool '" + toolLoc[0] + "' is defined on Jenkins.");
        }
        return result;
    }

    private static List<EnvironmentVariablesNodeProperty.Entry> parseEnvironmentVariables(String[] environmentVariables) {
        ArrayList<EnvironmentVariablesNodeProperty.Entry> result = new ArrayList<EnvironmentVariablesNodeProperty.Entry>();
        for (String environmentVariable : environmentVariables) {
            String[] keyValue = environmentVariable.split(":", 2);
            EnvironmentVariablesNodeProperty.Entry var = new EnvironmentVariablesNodeProperty.Entry(keyValue[0], keyValue[1]);
            result.add(var);
        }
        return result;
    }

    private static String getSwarmSecret() {
        return secret.toString();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive for try-with-resources in Java 11")
    public void doSlaveInfo(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(SlaveComputer.CREATE);
        rsp.setContentType("text/xml");
        try (Writer w = rsp.getCompressedWriter((HttpServletRequest)req);){
            w.write("<slaveInfo><swarmSecret>" + PluginImpl.getSwarmSecret() + "</swarmSecret></slaveInfo>");
        }
    }
}

