/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver;
import org.jenkinsci.remoting.util.KeyUtils;
import org.jenkinsci.remoting.util.ThrowableUtils;

public class JnlpAgentEndpoint {
    @Nonnull
    private final String host;
    private final int port;
    @CheckForNull
    private final RSAPublicKey publicKey;
    @CheckForNull
    private final Set<String> protocols;
    @CheckForNull
    private final URL serviceUrl;

    @Deprecated
    public JnlpAgentEndpoint(@Nonnull String host, int port, @CheckForNull RSAPublicKey publicKey, @CheckForNull Set<String> protocols) {
        this(host, port, publicKey, protocols, null);
    }

    public JnlpAgentEndpoint(@Nonnull String host, int port, @CheckForNull RSAPublicKey publicKey, @CheckForNull Set<String> protocols, @CheckForNull URL serviceURL) {
        if (port <= 0 || 65536 <= port) {
            throw new IllegalArgumentException("Port " + port + " is not in the range 1-65535");
        }
        this.host = host;
        this.port = port;
        this.publicKey = publicKey;
        this.protocols = protocols == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(protocols));
        this.serviceUrl = serviceURL;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @CheckForNull
    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    @Nonnull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @CheckForNull
    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @CheckForNull
    public Set<String> getProtocols() {
        return this.protocols;
    }

    public boolean isProtocolSupported(@Nonnull String name) {
        return this.protocols == null || this.protocols.contains(name);
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Unsafe endline symbol is a pert of the protocol. Unsafe to fix it. See TODO below")
    public Socket open(int socketTimeout) throws IOException {
        boolean isHttpProxy = false;
        InetSocketAddress targetAddress = null;
        AbstractInterruptibleChannel channel = null;
        try {
            targetAddress = JnlpAgentEndpointResolver.getResolvedHttpProxyAddress(this.host, this.port);
            if (targetAddress == null) {
                targetAddress = new InetSocketAddress(this.host, this.port);
            } else {
                isHttpProxy = true;
            }
            channel = SocketChannel.open(targetAddress);
            Socket socket = ((SocketChannel)channel).socket();
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(socketTimeout);
            if (isHttpProxy) {
                String connectCommand = String.format("CONNECT %s:%s HTTP/1.1\r\nHost: %s\r\n\r\n", this.host, this.port, this.host);
                socket.getOutputStream().write(connectCommand.getBytes("UTF-8"));
                BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
                String line = EngineUtil.readLine(is);
                String[] responseLineParts = line.split(" ");
                if (responseLineParts.length < 2 || !responseLineParts[1].equals("200")) {
                    throw new IOException("Got a bad response from proxy: " + line);
                }
                while (!EngineUtil.readLine(is).isEmpty()) {
                }
            }
            return socket;
        }
        catch (IOException e) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException suppressed) {
                    e = ThrowableUtils.addSuppressed(e, suppressed);
                }
            }
            String suffix = "";
            if (isHttpProxy) {
                suffix = " through proxy " + targetAddress.toString();
            }
            throw new IOException("Failed to connect to " + this.host + ':' + this.port + suffix, e);
        }
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JnlpAgentEndpoint that = (JnlpAgentEndpoint)o;
        if (this.port != that.port) {
            return false;
        }
        if (!KeyUtils.equals(this.publicKey, that.publicKey)) {
            return false;
        }
        if (this.protocols == null ? that.protocols != null : !this.protocols.equals(that.protocols)) {
            return false;
        }
        if (this.host.equals(that.host)) {
            return true;
        }
        InetAddress thisAddr = this.getAddress().getAddress();
        InetAddress thatAddr = that.getAddress().getAddress();
        if (!thisAddr.getClass().equals(thatAddr.getClass())) {
            return false;
        }
        if (thisAddr.isAnyLocalAddress()) {
            return thatAddr.isLinkLocalAddress() || thatAddr.isLoopbackAddress() || thatAddr.isAnyLocalAddress();
        }
        if (thatAddr.isAnyLocalAddress()) {
            return thisAddr.isLinkLocalAddress() || thisAddr.isLoopbackAddress();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JnlpAgentEndpoint{");
        sb.append("host=").append(this.host);
        sb.append(", port=").append(this.port);
        sb.append(", publicKey=").append(KeyUtils.fingerprint(this.publicKey));
        sb.append(", protocols=").append(this.protocols);
        sb.append('}');
        return sb.toString();
    }
}

