/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerSplitter;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jenkinsci.remoting.engine.Jnlp4ConnectionState;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;
import org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.engine.JnlpProtocolHandlerFactory;
import org.jenkinsci.remoting.engine.WorkDirManager;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.cert.BlindTrustX509ExtendedTrustManager;
import org.jenkinsci.remoting.protocol.cert.DelegatingX509ExtendedTrustManager;
import org.jenkinsci.remoting.protocol.cert.PublicKeyMatchingX509ExtendedTrustManager;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.util.KeyUtils;

@NotThreadSafe
public class Engine
extends Thread {
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(final Runnable r) {
            Thread t = this.defaultFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    CURRENT.set(Engine.this);
                    r.run();
                }
            });
            t.setDaemon(true);
            return t;
        }
    });
    @Deprecated
    public final EngineListener listener;
    private final EngineListenerSplitter events = new EngineListenerSplitter();
    private List<URL> candidateUrls;
    private List<X509Certificate> candidateCertificates;
    @CheckForNull
    private URL hudsonUrl;
    private final String secretKey;
    public final String slaveName;
    private String credentials;
    private String proxyCredentials = System.getProperty("proxyCredentials");
    private String tunnel;
    private boolean noReconnect;
    private boolean keepAlive = true;
    @CheckForNull
    private JarCache jarCache = null;
    @CheckForNull
    private Path agentLog;
    @CheckForNull
    private Path loggingConfigFilePath = null;
    @CheckForNull
    public Path workDir = null;
    @Nonnull
    public String internalDir = WorkDirManager.DirType.INTERNAL_DIR.getDefaultLocation();
    @Nonnull
    public boolean failIfWorkDirIsMissing = false;
    private DelegatingX509ExtendedTrustManager agentTrustManager = new DelegatingX509ExtendedTrustManager(new BlindTrustX509ExtendedTrustManager());
    private static final ThreadLocal<Engine> CURRENT = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    static final int SOCKET_TIMEOUT = Integer.getInteger(Engine.class.getName() + ".socketTimeout", 1800000);

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String slaveName) {
        this.listener = listener;
        this.events.add(listener);
        this.candidateUrls = hudsonUrls;
        this.secretKey = secretKey;
        this.slaveName = slaveName;
        if (this.candidateUrls.isEmpty()) {
            throw new IllegalArgumentException("No URLs given");
        }
    }

    public synchronized void startEngine() throws IOException {
        this.startEngine(false);
    }

    void startEngine(boolean dryRun) throws IOException {
        File jarCacheDirectory = null;
        if (this.workDir != null) {
            WorkDirManager workDirManager = WorkDirManager.getInstance();
            if (this.jarCache != null) {
                workDirManager.disable(WorkDirManager.DirType.JAR_CACHE_DIR);
            }
            if (this.loggingConfigFilePath != null) {
                workDirManager.setLoggingConfig(this.loggingConfigFilePath.toFile());
            }
            Path path = workDirManager.initializeWorkDir(this.workDir.toFile(), this.internalDir, this.failIfWorkDirIsMissing);
            jarCacheDirectory = workDirManager.getLocation(WorkDirManager.DirType.JAR_CACHE_DIR);
            workDirManager.setupLogging(path, this.agentLog);
        } else if (this.jarCache == null) {
            LOGGER.log(Level.WARNING, "No Working Directory. Using the legacy JAR Cache location: {0}", JarCache.DEFAULT_NOWS_JAR_CACHE_LOCATION);
            jarCacheDirectory = JarCache.DEFAULT_NOWS_JAR_CACHE_LOCATION;
        }
        if (this.jarCache == null) {
            if (jarCacheDirectory == null) {
                throw new IOException("Cannot find the JAR Cache location");
            }
            LOGGER.log(Level.FINE, "Using standard File System JAR Cache. Root Directory is {0}", jarCacheDirectory);
            try {
                this.jarCache = new FileSystemJarCache(jarCacheDirectory, true);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Failed to initialize FileSystem JAR Cache in " + jarCacheDirectory, ex);
            }
        } else {
            LOGGER.log(Level.INFO, "Using custom JAR Cache: {0}", this.jarCache);
        }
        if (!dryRun) {
            this.start();
        }
    }

    public void setJarCache(@Nonnull JarCache jarCache) {
        this.jarCache = jarCache;
    }

    public void setLoggingConfigFile(@Nonnull Path filePath) {
        this.loggingConfigFilePath = filePath;
    }

    @CheckForNull
    public URL getHudsonUrl() {
        return this.hudsonUrl;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setCredentials(String creds) {
        this.credentials = creds;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setNoReconnect(boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    public void setAgentLog(@CheckForNull Path agentLog) {
        this.agentLog = agentLog;
    }

    public void setWorkDir(@CheckForNull Path workDir) {
        this.workDir = workDir;
    }

    public void setInternalDir(@Nonnull String internalDir) {
        this.internalDir = internalDir;
    }

    public void setFailIfWorkDirIsMissing(boolean failIfWorkDirIsMissing) {
        this.failIfWorkDirIsMissing = failIfWorkDirIsMissing;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setCandidateCertificates(List<X509Certificate> candidateCertificates) {
        this.candidateCertificates = candidateCertificates == null ? null : new ArrayList<X509Certificate>(candidateCertificates);
    }

    public void addCandidateCertificate(X509Certificate certificate) {
        if (this.candidateCertificates == null) {
            this.candidateCertificates = new ArrayList<X509Certificate>();
        }
        this.candidateCertificates.add(certificate);
    }

    public void addListener(EngineListener el) {
        this.events.add(el);
    }

    public void removeListener(EngineListener el) {
        this.events.remove(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (IOHub hub = IOHub.create(this.executor);){
            KeyManagerFactory kmf;
            KeyStore store;
            SSLContext context;
            try {
                context = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Java runtime specification requires support for TLS algorithm", e);
            }
            char[] password = "password".toCharArray();
            try {
                store = KeyStore.getInstance("JKS");
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("Java runtime specification requires support for JKS key store", e);
            }
            try {
                store.load(null, password);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Java runtime specification requires support for JKS key store", e);
            }
            catch (CertificateException e) {
                throw new IllegalStateException("Empty keystore", e);
            }
            try {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Java runtime specification requires support for default key manager", e);
            }
            try {
                kmf.init(store, password);
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IllegalStateException(e);
            }
            try {
                context.init(kmf.getKeyManagers(), new TrustManager[]{this.agentTrustManager}, null);
            }
            catch (KeyManagementException e) {
                this.events.error(e);
                hub.close();
                return;
            }
            this.innerRun(hub, context, this.executor);
        }
        catch (IOException e) {
            this.events.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRun(IOHub hub, SSLContext context, ExecutorService service) {
        List<JnlpProtocolHandler> protocols = new JnlpProtocolHandlerFactory(service).withIOHub(hub).withSSLContext(context).withPreferNonBlockingIO(false).handlers();
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Node-Name", this.slaveName);
        headers.put("Secret-Key", this.secretKey);
        ArrayList<String> jenkinsUrls = new ArrayList<String>();
        for (URL url : this.candidateUrls) {
            jenkinsUrls.add(url.toExternalForm());
        }
        JnlpAgentEndpointResolver resolver = new JnlpAgentEndpointResolver(jenkinsUrls);
        resolver.setCredentials(this.credentials);
        resolver.setProxyCredentials(this.proxyCredentials);
        resolver.setTunnel(this.tunnel);
        try {
            resolver.setSslSocketFactory(this.getSSLSocketFactory());
        }
        catch (Exception e) {
            this.events.error(e);
        }
        try {
            boolean first = true;
            while (true) {
                JnlpAgentEndpoint endpoint;
                if (first) {
                    first = false;
                } else if (this.noReconnect) {
                    return;
                }
                this.events.status("Locating server among " + this.candidateUrls);
                try {
                    endpoint = resolver.resolve();
                }
                catch (Exception e) {
                    this.events.error(e);
                    return;
                }
                if (endpoint == null) {
                    this.events.status("Could not resolve server among " + this.candidateUrls);
                    return;
                }
                this.hudsonUrl = endpoint.getServiceUrl();
                this.events.status(String.format("Agent discovery successful%n  Agent address: %s%n  Agent port:    %d%n  Identity:      %s", endpoint.getHost(), endpoint.getPort(), KeyUtils.fingerprint(endpoint.getPublicKey())));
                PublicKeyMatchingX509ExtendedTrustManager delegate = new PublicKeyMatchingX509ExtendedTrustManager(new PublicKey[0]);
                RSAPublicKey publicKey = endpoint.getPublicKey();
                if (publicKey != null) {
                    delegate.add(publicKey);
                }
                this.agentTrustManager.setDelegate(delegate);
                this.events.status("Handshaking");
                Socket jnlpSocket = this.connect(endpoint);
                Channel channel = null;
                try {
                    boolean triedAtLeastOneProtocol = false;
                    for (JnlpProtocolHandler protocol : protocols) {
                        if (!protocol.isEnabled()) {
                            this.events.status("Protocol " + protocol.getName() + " is not enabled, skipping");
                            continue;
                        }
                        if (jnlpSocket == null) {
                            jnlpSocket = this.connect(endpoint);
                        }
                        if (!endpoint.isProtocolSupported(protocol.getName())) {
                            this.events.status("Server reports protocol " + protocol.getName() + " not supported, skipping");
                            continue;
                        }
                        triedAtLeastOneProtocol = true;
                        this.events.status("Trying protocol: " + protocol.getName());
                        try {
                            channel = protocol.connect(jnlpSocket, headers, new JnlpConnectionStateListener(){

                                @Override
                                public void beforeProperties(@Nonnull JnlpConnectionState event) {
                                    X509Certificate certificate;
                                    if (event instanceof Jnlp4ConnectionState && (certificate = ((Jnlp4ConnectionState)event).getCertificate()) != null) {
                                        String fingerprint = KeyUtils.fingerprint(certificate.getPublicKey());
                                        if (!KeyUtils.equals(endpoint.getPublicKey(), certificate.getPublicKey())) {
                                            event.reject(new ConnectionRefusalException("Expecting identity " + fingerprint));
                                        }
                                        Engine.this.events.status("Remote identity confirmed: " + fingerprint);
                                    }
                                }

                                @Override
                                public void afterProperties(@Nonnull JnlpConnectionState event) {
                                    event.approve();
                                }

                                @Override
                                public void beforeChannel(@Nonnull JnlpConnectionState event) {
                                    ChannelBuilder bldr = event.getChannelBuilder().withMode(Channel.Mode.BINARY);
                                    if (Engine.this.jarCache != null) {
                                        bldr.withJarCache(Engine.this.jarCache);
                                    }
                                }

                                @Override
                                public void afterChannel(@Nonnull JnlpConnectionState event) {
                                    String cookie = event.getProperty("Cookie");
                                    if (cookie == null) {
                                        headers.remove("Cookie");
                                    } else {
                                        headers.put("Cookie", cookie);
                                    }
                                }
                            }).get();
                        }
                        catch (IOException ioe) {
                            this.events.status("Protocol " + protocol.getName() + " failed to establish channel", ioe);
                        }
                        catch (RuntimeException e) {
                            this.events.status("Protocol " + protocol.getName() + " encountered a runtime error", e);
                        }
                        catch (Error e) {
                            this.events.status("Protocol " + protocol.getName() + " could not be completed due to an error", e);
                        }
                        catch (Throwable e) {
                            this.events.status("Protocol " + protocol.getName() + " encountered an unexpected exception", e);
                        }
                        if (channel != null) break;
                        jnlpSocket.close();
                        jnlpSocket = null;
                    }
                    if (channel == null) {
                        if (triedAtLeastOneProtocol) {
                            this.onConnectionRejected("None of the protocols were accepted");
                            continue;
                        }
                        this.onConnectionRejected("None of the protocols are enabled");
                        return;
                    }
                    this.events.status("Connected");
                    channel.join();
                    this.events.status("Terminated");
                }
                finally {
                    if (jnlpSocket == null) continue;
                    try {
                        jnlpSocket.close();
                    }
                    catch (IOException e) {
                        this.events.status("Failed to close socket", e);
                    }
                    continue;
                }
                if (this.noReconnect) {
                    return;
                }
                this.events.onDisconnect();
                resolver.waitForReady();
                this.events.onReconnect();
            }
        }
        catch (Throwable e) {
            this.events.error(e);
            return;
        }
    }

    private void onConnectionRejected(String greeting) throws InterruptedException {
        this.events.error(new Exception("The server rejected the connection: " + greeting));
        Thread.sleep(10000L);
    }

    private Socket connect(@Nonnull JnlpAgentEndpoint endpoint) throws IOException, InterruptedException {
        String msg = "Connecting to " + endpoint.getHost() + ':' + endpoint.getPort();
        this.events.status(msg);
        int retry = 1;
        while (true) {
            try {
                Socket s = endpoint.open(SOCKET_TIMEOUT);
                s.setKeepAlive(this.keepAlive);
                return s;
            }
            catch (IOException e) {
                if (retry++ > 10) {
                    throw e;
                }
                Thread.sleep(10000L);
                this.events.status(msg + " (retrying:" + retry + ")", e);
                continue;
            }
            break;
        }
    }

    public static Engine current() {
        return CURRENT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore getCacertsKeyStore() throws PrivilegedActionException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException, IOException {
        Map<String, String> properties = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() throws Exception {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                result.put("javaHome", System.getProperty("java.home"));
                result.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                result.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                result.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return result;
            }
        });
        KeyStore keystore = null;
        try (FileInputStream trustStoreStream = null;){
            String trustStore = properties.get("trustStore");
            if (!"NONE".equals(trustStore)) {
                File trustStoreFile;
                if (trustStore != null) {
                    trustStoreFile = new File(trustStore);
                    trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                } else {
                    String javaHome = properties.get("javaHome");
                    trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts");
                    trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                    if (trustStoreStream == null) {
                        trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
                        trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                    }
                }
                trustStore = trustStoreStream != null ? trustStoreFile.getPath() : "No File Available, using empty keystore.";
            }
            String trustStoreType = properties.get("trustStoreType");
            String trustStoreProvider = properties.get("trustStoreProvider");
            LOGGER.log(Level.FINE, "trustStore is: {0}", trustStore);
            LOGGER.log(Level.FINE, "trustStore type is: {0}", trustStoreType);
            LOGGER.log(Level.FINE, "trustStore provider is: {0}", trustStoreProvider);
            if (trustStoreType.length() != 0) {
                LOGGER.log(Level.FINE, "init truststore");
                keystore = trustStoreProvider.length() == 0 ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
                char[] trustStorePasswdChars = null;
                String trustStorePasswd = properties.get("trustStorePasswd");
                if (trustStorePasswd.length() != 0) {
                    trustStorePasswdChars = trustStorePasswd.toCharArray();
                }
                keystore.load(trustStoreStream, trustStorePasswdChars);
                if (trustStorePasswdChars != null) {
                    for (int i = 0; i < trustStorePasswdChars.length; ++i) {
                        trustStorePasswdChars[i] = '\u0000';
                    }
                }
            }
        }
        return keystore;
    }

    @CheckForNull
    private static FileInputStream getFileInputStream(final File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    return file.exists() ? new FileInputStream(file) : null;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        });
    }

    private SSLSocketFactory getSSLSocketFactory() throws PrivilegedActionException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLSocketFactory sslSocketFactory = null;
        if (this.candidateCertificates != null && !this.candidateCertificates.isEmpty()) {
            KeyStore keyStore = Engine.getCacertsKeyStore();
            keyStore.load(null, null);
            int i = 0;
            for (X509Certificate c : this.candidateCertificates) {
                keyStore.setCertificateEntry(String.format("alias-%d", i++), c);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagerFactory.getTrustManagers(), null);
            sslSocketFactory = ctx.getSocketFactory();
        }
        return sslSocketFactory;
    }
}

