/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import javax.annotation.CheckForNull;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ThrowableUtils {
    private ThrowableUtils() {
        throw new IllegalAccessError("Utility class");
    }

    @IgnoreJRERequirement
    @Restricted(value={NoExternalUse.class})
    public static <T extends Throwable> T addSuppressed(T primary, Throwable suppressed) {
        try {
            primary.addSuppressed(suppressed);
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return primary;
    }

    @CheckForNull
    public static <T extends Throwable, T1 extends T, T2 extends T> T chain(@CheckForNull T1 e1, @CheckForNull T2 e2) {
        return (T)(e1 == null ? e2 : (e2 == null ? e1 : ThrowableUtils.addSuppressed(e1, e2)));
    }
}

