/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.remoting.shaded.org.kohsuke.args4j.spi;

import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.ConfigElement;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.OptionHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationImpl
implements Annotation {
    private final Class<? extends Annotation> annotationType;
    public String[] aliases;
    public Class<? extends OptionHandler> handler;
    public String metaVar;
    public boolean multiValued;
    public boolean required;
    public boolean help;
    public boolean hidden;
    public String usage;
    public int index;

    protected AnnotationImpl(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    protected AnnotationImpl(Class<? extends Annotation> annotationType, ConfigElement ce) throws ClassNotFoundException {
        this(annotationType);
        this.aliases = ce.aliases != null ? ce.aliases : new String[]{};
        this.handler = ce.handler != null ? Class.forName(ce.handler) : OptionHandler.class;
        this.metaVar = ce.metavar != null ? ce.metavar : "";
        this.multiValued = ce.multiValued;
        this.required = ce.required;
        this.hidden = ce.hidden;
        this.usage = ce.usage != null ? ce.usage : "";
    }

    public String[] aliases() {
        return Arrays.copyOf(this.aliases, this.aliases.length);
    }

    public Class<? extends OptionHandler> handler() {
        return this.handler;
    }

    public String metaVar() {
        return this.metaVar;
    }

    public boolean multiValued() {
        return this.multiValued;
    }

    public boolean required() {
        return this.required;
    }

    public boolean help() {
        return this.help;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public String usage() {
        return this.usage;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public int index() {
        return this.index;
    }
}

