/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.RemoteClassLoader;
import java.io.IOException;
import java.net.URL;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

final class PreloadJarTask2
implements DelegatingCallable<Boolean, IOException> {
    private final URL[] jars;
    private final byte[][] contents;
    @CheckForNull
    private transient ClassLoader target = null;
    private static final long serialVersionUID = -773448303394727271L;

    PreloadJarTask2(URL[] jars, byte[][] contents, @CheckForNull ClassLoader target) {
        if (jars.length != contents.length) {
            throw new IllegalArgumentException("Got " + jars.length + " jars and " + contents.length + " contents");
        }
        this.jars = jars;
        this.contents = contents;
        this.target = target;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.target;
    }

    @Override
    public Boolean call() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            if (!(cl instanceof RemoteClassLoader)) {
                return false;
            }
            RemoteClassLoader rcl = (RemoteClassLoader)cl;
            boolean r = false;
            for (int i = 0; i < this.jars.length; ++i) {
                r |= rcl.prefetch(this.jars[i], this.contents[i]);
            }
            return r;
        }
        catch (IllegalAccessError iae) {
            throw new IOException(iae);
        }
    }

    @Override
    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Role.UNKNOWN);
    }
}

