/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpProtocol4Handler;
import org.jenkinsci.remoting.engine.JnlpProtocol4ProxyHandler;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.nio.NioChannelHub;
import org.jenkinsci.remoting.protocol.IOHub;

public class JnlpProtocolHandlerFactory {
    private boolean needClientAuth;
    @CheckForNull
    private IOHub ioHub;
    @CheckForNull
    private SSLContext context;
    @CheckForNull
    private JnlpClientDatabase clientDatabase;
    @NonNull
    private final ExecutorService threadPool;
    private boolean preferNio = true;

    public JnlpProtocolHandlerFactory(@NonNull ExecutorService threadPool) {
        this.threadPool = threadPool;
        this.needClientAuth = false;
    }

    public JnlpProtocolHandlerFactory withNioChannelHub(@CheckForNull NioChannelHub nioChannelHub) {
        return this;
    }

    public JnlpProtocolHandlerFactory withIOHub(@CheckForNull IOHub ioHub) {
        this.ioHub = ioHub;
        return this;
    }

    public JnlpProtocolHandlerFactory withSSLContext(@CheckForNull SSLContext context) {
        this.context = context;
        return this;
    }

    public JnlpProtocolHandlerFactory withSSLClientAuthRequired(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public JnlpProtocolHandlerFactory withPreferNonBlockingIO(boolean preferNio) {
        this.preferNio = preferNio;
        return this;
    }

    public JnlpProtocolHandlerFactory withClientDatabase(@CheckForNull JnlpClientDatabase clientDatabase) {
        this.clientDatabase = clientDatabase;
        return this;
    }

    @NonNull
    public List<JnlpProtocolHandler<? extends JnlpConnectionState>> handlers() {
        ArrayList<JnlpProtocolHandler<? extends JnlpConnectionState>> result = new ArrayList<JnlpProtocolHandler<? extends JnlpConnectionState>>();
        if (this.ioHub != null && this.context != null) {
            JnlpProtocol4Handler jnlpProtocol4Handler = new JnlpProtocol4Handler(this.clientDatabase, this.threadPool, this.ioHub, this.context, this.needClientAuth, this.preferNio);
            result.add(new JnlpProtocol4ProxyHandler(jnlpProtocol4Handler));
            result.add(jnlpProtocol4Handler);
        }
        return result;
    }
}

