/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.util.IOUtils;

final class ProxyInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(ProxyInputStream.class.getName());
    private Channel channel;
    private int oid;

    public ProxyInputStream(Channel channel, int oid) throws IOException {
        this.channel = channel;
        this.oid = oid;
    }

    @Override
    public int read() throws IOException {
        try {
            Buffer buf = this._read(1);
            if (buf.len == 1) {
                return buf.buf[0] & 0xFF;
            }
            return -1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            return -1;
        }
    }

    private synchronized Buffer _read(int len) throws IOException, InterruptedException {
        return (Buffer)new Chunk(this.oid, len).call(this.channel);
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        try {
            Buffer buf = this._read(len);
            if (buf.len == -1) {
                return -1;
            }
            System.arraycopy(buf.buf, 0, b, off, buf.len);
            return buf.len;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            return -1;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.channel != null) {
            this.channel.send(new EOF(this.oid));
            this.channel = null;
            this.oid = -1;
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public EOF(int oid) {
            this.oid = oid;
        }

        @Override
        protected void execute(Channel channel) {
            InputStream in = (InputStream)channel.getExportedObjectOrNull(this.oid);
            if (in == null) {
                LOGGER.log(Level.FINE, "InputStream with oid=%s has been already unexported", this.oid);
                return;
            }
            channel.unexport(this.oid, this.createdAt, false);
            IOUtils.closeQuietly(in);
        }

        @Override
        public String toString() {
            return "ProxyInputStream.EOF(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Request<Buffer, IOException> {
        private final int oid;
        private final int len;
        private static final long serialVersionUID = 1L;

        public Chunk(int oid, int len) {
            this.oid = oid;
            this.len = len;
        }

        @Override
        protected Buffer perform(Channel channel) throws IOException {
            InputStream in;
            try {
                in = (InputStream)channel.getExportedObject(this.oid);
            }
            catch (ExecutionException ex) {
                throw new IOException(ex);
            }
            Buffer buf = new Buffer(this.len);
            buf.read(in);
            return buf;
        }

        @Override
        public String toString() {
            return "ProxyInputStream.Chunk(len=" + this.len + ")";
        }
    }

    private static final class Buffer
    implements Serializable {
        byte[] buf;
        int len;
        private static final long serialVersionUID = 1L;

        public Buffer(int len) {
            this.buf = new byte[len];
        }

        public void read(InputStream in) throws IOException {
            this.len = in.read(this.buf, 0, this.buf.length);
        }
    }
}

