/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.Future;
import hudson.remoting.FutureAdapter;
import hudson.remoting.JarCache;
import hudson.remoting.ResourceImageRef;
import hudson.remoting.URLish;
import hudson.remoting.Util;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

class ResourceImageInJar
extends ResourceImageRef {
    final long sum1;
    final long sum2;
    final String path;
    private static final long serialVersionUID = 1L;

    ResourceImageInJar(long sum1, long sum2, String path) {
        this.sum1 = sum1;
        this.sum2 = sum2;
        this.path = path;
    }

    ResourceImageInJar(Checksum sum, String path) {
        this(sum.sum1, sum.sum2, path);
    }

    @Override
    Future<byte[]> resolve(Channel channel, final String resourcePath) throws IOException, InterruptedException {
        return new FutureAdapter<byte[], URL>(this._resolveJarURL(channel)){

            @Override
            @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="This is only used for managing the jar cache as files.")
            protected byte[] adapt(URL jar) throws ExecutionException {
                try {
                    return Util.readFully(ResourceImageInJar.this.toResourceURL(jar, resourcePath).openStream());
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    @Override
    Future<URLish> resolveURL(Channel channel, final String resourcePath) throws IOException, InterruptedException {
        return new FutureAdapter<URLish, URL>(this._resolveJarURL(channel)){

            @Override
            protected URLish adapt(URL jar) throws ExecutionException {
                try {
                    return URLish.from(ResourceImageInJar.this.toResourceURL(jar, resourcePath));
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    @NonNull
    private URL toResourceURL(URL jar, String resourcePath) throws IOException {
        if (this.path != null) {
            resourcePath = this.path;
        }
        return new URL("jar:" + jar + "!/" + resourcePath);
    }

    Future<URL> _resolveJarURL(Channel channel) throws IOException, InterruptedException {
        JarCache c = channel.getJarCache();
        if (c == null) {
            throw new IOException(String.format("Failed to resolve a jar %016x%016x. JAR Cache is disabled for the channel %s", this.sum1, this.sum2, channel.getName()));
        }
        return c.resolve(channel, this.sum1, this.sum2);
    }
}

