/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.remoting.shaded.org.kohsuke.args4j.spi;

import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.Getter;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.Setter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldSetter
implements Getter,
Setter {
    private final Field f;
    private final Object bean;

    public FieldSetter(Object bean, Field f) {
        this.bean = bean;
        this.f = f;
    }

    public Class getType() {
        return this.f.getType();
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public FieldSetter asFieldSetter() {
        return new FieldSetter(this.bean, this.f);
    }

    @Override
    public AnnotatedElement asAnnotatedElement() {
        return this.f;
    }

    public void addValue(Object value) {
        try {
            this.f.set(this.bean, value);
        }
        catch (IllegalAccessException ex) {
            this.f.setAccessible(true);
            try {
                this.f.set(this.bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    public Object getValue() {
        try {
            return this.f.get(this.bean);
        }
        catch (IllegalAccessException ex) {
            this.f.setAccessible(true);
            try {
                return this.f.get(this.bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    public List<Object> getValueList() {
        return this.asList(this.getValue());
    }

    private List<Object> asList(Object o) {
        if (o != null) {
            return Collections.singletonList(o);
        }
        return Collections.emptyList();
    }
}

