/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import com.sun.net.httpserver.HttpServer;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.remoting.Launcher;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.CookieManager;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SwarmClient {
    private static final Logger logger = Logger.getLogger(SwarmClient.class.getName());
    private final Options options;
    private final String hash;
    private String name;
    private HttpServer prometheusServer = null;

    public SwarmClient(Options options) {
        this.options = options;
        this.hash = !options.disableClientsUniqueId ? SwarmClient.hash(options.fsroot) : "";
        this.name = options.name;
        if (options.labelsFile != null) {
            logger.info("Loading labels from " + options.labelsFile + "...");
            try {
                String labels = Files.readString(Paths.get(options.labelsFile, new String[0]), StandardCharsets.UTF_8);
                options.labels.addAll(List.of(labels.trim().split("\\s+")));
                logger.info("Labels found in file: " + labels);
                logger.info("Effective label list: " + Arrays.toString(options.labels.toArray()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Problem reading labels from file " + options.labelsFile, e);
            }
        }
        if (options.prometheusPort > 0) {
            this.startPrometheusService(options.prometheusPort);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOptionsLabels() {
        return this.options.labels;
    }

    public URL getUrl() {
        logger.config("getUrl() invoked");
        if (!this.options.url.endsWith("/")) {
            this.options.url = this.options.url + "/";
        }
        try {
            return new URL(this.options.url);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(String.format("The URL %s is invalid", this.options.url), e);
        }
    }

    List<String> getJnlpArgs(URL url) throws IOException, RetryException {
        logger.fine("connect() invoked");
        Launcher launcher = new Launcher();
        launcher.noReconnect = true;
        launcher.agentJnlpURL = new URL(url + "computer/" + this.name + "/slave-agent.jnlp");
        if (this.options.username != null && this.options.password != null) {
            launcher.agentJnlpCredentials = this.options.username + ":" + this.options.password;
        }
        launcher.noCertificateCheck = this.options.disableSslVerification;
        try {
            return launcher.parseJnlpArguments();
        }
        catch (InterruptedException | RuntimeException | ParserConfigurationException | SAXException e) {
            throw new RetryException("Failed get JNLP arguments for " + url, e);
        }
    }

    void connect(List<String> jnlpArgs, URL url) throws IOException, RetryException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-url");
        args.add(url.toString());
        args.add("-secret");
        args.add(jnlpArgs.get(0));
        args.add("-name");
        args.add(this.name);
        if (this.options.disableSslVerification) {
            args.add("-noCertificateCheck");
        }
        if (this.options.tunnel != null) {
            args.add("-tunnel");
            args.add(this.options.tunnel);
            logger.fine("Using tunnel through " + this.options.tunnel);
        }
        if (this.options.username != null && this.options.password != null && !this.options.webSocket) {
            args.add("-credentials");
            args.add(this.options.username + ":" + this.options.password);
        }
        if (!this.options.disableWorkDir) {
            String workDirPath = this.options.workDir != null ? this.options.workDir.getPath() : this.options.fsroot.getPath();
            args.add("-workDir");
            args.add(workDirPath);
            if (this.options.internalDir != null) {
                args.add("-internalDir");
                args.add(this.options.internalDir.getPath());
            }
            if (this.options.failIfWorkDirIsMissing) {
                args.add("-failIfWorkDirIsMissing");
            }
        }
        if (this.options.jarCache != null) {
            args.add("-jar-cache");
            args.add(this.options.jarCache.getPath());
        }
        args.add("-headless");
        args.add("-noReconnect");
        if (this.options.webSocket) {
            args.add("-webSocket");
            if (this.options.webSocketHeaders != null) {
                for (Map.Entry entry : this.options.webSocketHeaders.entrySet()) {
                    args.add("-webSocketHeader");
                    args.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
        }
        try {
            Launcher.main(args.toArray(new String[0]));
        }
        catch (InterruptedException | RuntimeException e) {
            throw new RetryException("Failed to establish connection to " + url, e);
        }
    }

    static HttpClient createHttpClient(Options clientOptions) {
        logger.fine("createHttpClient() invoked");
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.cookieHandler(new CookieManager());
        if (clientOptions.disableSslVerification || !clientOptions.sslFingerprints.isEmpty()) {
            SSLContext sslContext;
            try {
                sslContext = SSLContext.getInstance("TLS");
                String trusted = clientOptions.disableSslVerification ? "" : clientOptions.sslFingerprints;
                sslContext.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager(trusted)}, new SecureRandom());
            }
            catch (GeneralSecurityException e) {
                logger.log(Level.SEVERE, "An error occurred", e);
                throw new IllegalStateException(e);
            }
            builder.sslContext(sslContext);
            SSLContext.setDefault(sslContext);
            if (clientOptions.disableSslVerification) {
                System.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.toString(true));
            }
        }
        return builder.build();
    }

    static void addAuthorizationHeader(HttpRequest.Builder builder, Options clientOptions) {
        logger.fine("addAuthorizationHeader() invoked");
        if (clientOptions.username != null && clientOptions.password != null) {
            logger.fine("Setting HttpClient credentials based on options passed");
            String auth = clientOptions.username + ":" + clientOptions.password;
            String encoded = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            builder.header("Authorization", encoded);
        }
    }

    private static synchronized Crumb getCsrfCrumb(HttpClient client, Options options, URL url) throws IOException, InterruptedException {
        logger.finer("getCsrfCrumb() invoked");
        URI uri = URI.create(url + "crumbIssuer/api/xml?xpath=" + URLEncoder.encode("concat(//crumbRequestField,\":\",//crumb)", StandardCharsets.UTF_8));
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).GET();
        SwarmClient.addAuthorizationHeader(builder, options);
        HttpRequest request = builder.build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            logger.log(Level.SEVERE, String.format("Could not obtain CSRF crumb. Response code: %s%n%s", response.statusCode(), response.body()));
            return null;
        }
        String crumbResponseString = response.body();
        String[] crumbResponse = crumbResponseString.split(":");
        if (crumbResponse.length != 2) {
            logger.log(Level.SEVERE, "Unexpected CSRF crumb response: " + crumbResponseString);
            return null;
        }
        return new Crumb(crumbResponse[0], crumbResponse[1]);
    }

    /*
     * WARNING - void declaration
     */
    void createSwarmAgent(URL url) throws IOException, InterruptedException, RetryException {
        HttpRequest request;
        HttpResponse<InputStream> response;
        void var5_10;
        String string;
        logger.fine("createSwarmAgent() invoked");
        String labelStr = String.join((CharSequence)" ", this.options.labels);
        StringBuilder toolLocationBuilder = new StringBuilder();
        if (this.options.toolLocations != null) {
            for (Map.Entry<String, String> entry : this.options.toolLocations.entrySet()) {
                toolLocationBuilder.append(SwarmClient.param("toolLocation", entry.getKey() + ":" + entry.getValue()));
            }
        }
        StringBuilder environmentVariablesBuilder = new StringBuilder();
        if (this.options.environmentVariables != null) {
            for (Map.Entry<String, String> entry : this.options.environmentVariables.entrySet()) {
                environmentVariablesBuilder.append(SwarmClient.param("environmentVariable", entry.getKey() + ":" + entry.getValue()));
            }
        }
        if ((string = labelStr).length() > 1000) {
            String string2 = "";
        }
        Properties properties = new Properties();
        HttpClient client = SwarmClient.createHttpClient(this.options);
        URI uri = URI.create(url + "plugin/swarm/createSlave?name=" + this.options.name + "&executors=" + this.options.executors + SwarmClient.param("remoteFsRoot", this.options.fsroot.getAbsolutePath()) + SwarmClient.param("description", this.options.description) + SwarmClient.param("labels", (String)var5_10) + toolLocationBuilder + environmentVariablesBuilder + SwarmClient.param("mode", this.options.mode.toUpperCase(Locale.ENGLISH)) + SwarmClient.param("hash", this.hash) + SwarmClient.param("deleteExistingClients", Boolean.toString(this.options.deleteExistingClients)) + SwarmClient.param("keepDisconnectedClients", Boolean.toString(this.options.keepDisconnectedClients)));
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.noBody());
        SwarmClient.addAuthorizationHeader(builder, this.options);
        Crumb csrfCrumb = SwarmClient.getCsrfCrumb(client, this.options, url);
        if (csrfCrumb != null) {
            builder.header(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        if ((response = client.send(request = builder.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode() != 200) {
            throw new RetryException(String.format("Failed to create a Swarm agent on Jenkins. Response code: %s%n%s", response.statusCode(), new String(response.body().readAllBytes(), StandardCharsets.UTF_8)));
        }
        try (InputStream stream = response.body();){
            properties.load(stream);
        }
        String name = properties.getProperty("name");
        if (name == null) {
            this.name = this.options.name;
            return;
        }
        if ((name = name.trim()).isEmpty()) {
            this.name = this.options.name;
            return;
        }
        this.name = name;
        if (var5_10.length() == 0 && labelStr.length() > 0) {
            String[] lLabels = labelStr.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String s : lLabels) {
                sb.append(s);
                sb.append(" ");
                if (sb.length() <= 1000) continue;
                SwarmClient.postLabelAppend(name, sb.toString(), client, this.options, url);
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                SwarmClient.postLabelAppend(name, sb.toString(), client, this.options, url);
            }
        }
    }

    static synchronized void postLabelRemove(String name, String labels, HttpClient client, Options options, URL url) throws IOException, InterruptedException, RetryException {
        HttpRequest request;
        HttpResponse<String> response;
        URI uri = URI.create(url + "plugin/swarm/removeSlaveLabels?name=" + name + SwarmClient.param("labels", labels));
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.noBody());
        SwarmClient.addAuthorizationHeader(builder, options);
        Crumb csrfCrumb = SwarmClient.getCsrfCrumb(client, options, url);
        if (csrfCrumb != null) {
            builder.header(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        if ((response = client.send(request = builder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() != 200) {
            throw new RetryException(String.format("Failed to remove agent labels. Response code: %s%n%s", response.statusCode(), response.body()));
        }
    }

    static synchronized void postLabelAppend(String name, String labels, HttpClient client, Options options, URL url) throws IOException, InterruptedException, RetryException {
        HttpRequest request;
        HttpResponse<String> response;
        URI uri = URI.create(url + "plugin/swarm/addSlaveLabels?name=" + name + SwarmClient.param("labels", labels));
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.noBody());
        SwarmClient.addAuthorizationHeader(builder, options);
        Crumb csrfCrumb = SwarmClient.getCsrfCrumb(client, options, url);
        if (csrfCrumb != null) {
            builder.header(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        if ((response = client.send(request = builder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() != 200) {
            throw new RetryException(String.format("Failed to update agent labels. Response code: %s%n%s", response.statusCode(), response.body()));
        }
    }

    private static synchronized String encode(String value) throws UnsupportedEncodingException {
        logger.finer("encode() invoked");
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private static synchronized String param(String name, String value) throws UnsupportedEncodingException {
        logger.finer("param() invoked");
        if (value == null) {
            return "";
        }
        return "&" + name + "=" + SwarmClient.encode(value);
    }

    static String getChildElementString(Element parent, String tagName) {
        logger.finer("getChildElementString() invoked");
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals(tagName)) continue;
            StringBuilder buf = new StringBuilder();
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Text)) continue;
                buf.append(node.getTextContent());
            }
            return buf.toString();
        }
        return null;
    }

    private static String hash(File remoteFsRoot) {
        MessageDigest md;
        logger.config("hash() invoked");
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(remoteFsRoot.getCanonicalPath()).append('\n');
        }
        catch (IOException e) {
            logger.log(Level.FINER, "hash() IOException - may be normal?", e);
            buf.append(remoteFsRoot.getAbsolutePath()).append('\n');
        }
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress ia : Collections.list(ni.getInetAddresses())) {
                    if (ia instanceof Inet4Address) {
                        buf.append(ia.getHostAddress()).append('\n');
                        continue;
                    }
                    if (!(ia instanceof Inet6Address)) continue;
                    buf.append(ia.getHostAddress()).append('\n');
                }
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (hardwareAddress == null) continue;
                buf.append(Arrays.toString(hardwareAddress));
            }
        }
        catch (SocketException e) {
            logger.log(Level.FINEST, "hash() SocketException - 'oh well we tried'", e);
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = md.digest(buf.toString().getBytes(StandardCharsets.UTF_8));
        return SwarmClient.encodeHex(digest).substring(0, 8);
    }

    private static String encodeHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public void exitWithStatus(int status) {
        if (this.prometheusServer != null) {
            this.prometheusServer.stop(1);
        }
        System.exit(status);
    }

    public void sleepSeconds(int waitTime) throws InterruptedException {
        TimeUnit.SECONDS.sleep(waitTime);
    }

    private void startPrometheusService(int port) {
        logger.fine("Starting Prometheus service on port " + port);
        PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        new ClassLoaderMetrics().bindTo(prometheusRegistry);
        new FileDescriptorMetrics().bindTo(prometheusRegistry);
        new JvmGcMetrics().bindTo(prometheusRegistry);
        new JvmHeapPressureMetrics().bindTo(prometheusRegistry);
        new JvmMemoryMetrics().bindTo(prometheusRegistry);
        new JvmThreadMetrics().bindTo(prometheusRegistry);
        new ProcessorMetrics().bindTo(prometheusRegistry);
        new UptimeMetrics().bindTo(prometheusRegistry);
        try {
            this.prometheusServer = HttpServer.create(new InetSocketAddress(port), 0);
            this.prometheusServer.createContext("/prometheus", httpExchange -> {
                String response = prometheusRegistry.scrape();
                byte[] responseContent = response.getBytes(StandardCharsets.UTF_8);
                httpExchange.sendResponseHeaders(200, responseContent.length);
                try (OutputStream os = httpExchange.getResponseBody();){
                    os.write(responseContent);
                }
            });
            new Thread(this.prometheusServer::start).start();
        }
        catch (IOException e) {
            logger.severe("Failed to start Prometheus service: " + e.getMessage());
            throw new UncheckedIOException(e);
        }
        logger.info("Started Prometheus service on port " + port);
    }

    private static class Crumb {
        final String crumb;
        final String crumbRequestField;

        Crumb(String crumbRequestField, String crumb) {
            this.crumbRequestField = crumbRequestField;
            this.crumb = crumb;
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        final List<String> allowedFingerprints = new ArrayList<String>();
        final List<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>();

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.allowedFingerprints.isEmpty()) {
                return;
            }
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (X509Certificate cert : x509Certificates) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
                byte[] digest = md.digest(cert.getEncoded());
                String fingerprint = SwarmClient.encodeHex(digest);
                logger.fine("Check fingerprint: " + fingerprint);
                if (!this.allowedFingerprints.contains(fingerprint)) continue;
                list.add(cert);
                logger.fine("Found allowed certificate: " + cert);
            }
            if (list.isEmpty()) {
                throw new CertificateException("Fingerprint mismatch");
            }
            this.acceptedIssuers.addAll(list);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.acceptedIssuers.toArray(new X509Certificate[0]);
        }

        public DefaultTrustManager(String fingerprints) {
            if (fingerprints.isEmpty()) {
                return;
            }
            for (String fingerprint : fingerprints.split("\\s+")) {
                String unified = fingerprint.toLowerCase().replace(":", "");
                logger.fine("Add allowed fingerprint: " + unified);
                this.allowedFingerprints.add(unified);
            }
        }
    }
}

