/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.protocol.FilterLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.protocol.impl.ConnectionHeaders;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.protocol.impl.PermanentConnectionRefusalException;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.ByteBufferUtils;
import org.jenkinsci.remoting.util.ThrowableUtils;

public class ConnectionHeadersFilterLayer
extends FilterLayer {
    private static final Logger LOGGER = Logger.getLogger(ConnectionHeadersFilterLayer.class.getName());
    private static final ByteBuffer ABORT_MESSAGE = ByteBufferUtils.wrapUTF8("BYE").asReadOnlyBuffer();
    private final ByteBuffer headerOutput;
    private ByteBuffer responseOutput;
    private final ByteBuffer headerInputLength;
    private ByteBuffer headerInputContent;
    private ByteBuffer responseInputLength;
    private ByteBuffer responseInputContent;
    private ByteBuffer abortConfirmationInput;
    private ConnectionRefusalException abortCause;
    private Future<?> abortConfirmationTimeout;
    private final ByteBufferQueue sendQueue = new ByteBufferQueue(8192);
    private final ByteBufferQueue recvQueue = new ByteBufferQueue(8192);
    private final Listener listener;
    private boolean finished;
    private final AtomicReference<ConnectionRefusalException> aborted = new AtomicReference();

    public ConnectionHeadersFilterLayer(Map<String, String> headers, Listener listener) {
        this.headerOutput = ByteBufferUtils.wrapUTF8(ConnectionHeaders.toString(headers));
        this.responseOutput = null;
        this.listener = listener;
        this.headerInputLength = ByteBuffer.allocate(2);
        this.headerInputContent = null;
    }

    @Override
    public synchronized void start() {
        try {
            this.doSend(EMPTY_BUFFER);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecv(@NonNull ByteBuffer data) throws IOException {
        ConnectionRefusalException aborted = this.aborted.get();
        if (aborted != null) {
            throw ConnectionHeadersFilterLayer.newAbortCause(aborted);
        }
        ConnectionHeadersFilterLayer connectionHeadersFilterLayer = this;
        synchronized (connectionHeadersFilterLayer) {
            int length;
            if (this.headerInputLength.hasRemaining()) {
                ByteBufferUtils.put(data, this.headerInputLength);
                if (this.headerInputLength.hasRemaining()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] expecting {1} more bytes of header length", new Object[]{this.stack().name(), this.headerInputLength.remaining()});
                    }
                    return;
                }
                ((Buffer)this.headerInputLength).flip();
                length = this.headerInputLength.asShortBuffer().get() & 0xFFFF;
                ((Buffer)this.headerInputLength).position(2);
                this.headerInputContent = ByteBuffer.allocate(length);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "[{0}] Expecting {1} bytes of headers", new Object[]{this.stack().name(), length});
                }
            }
            if (!data.hasRemaining()) {
                return;
            }
            if (this.headerInputContent.hasRemaining()) {
                ByteBufferUtils.put(data, this.headerInputContent);
                if (this.headerInputContent.hasRemaining()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] Expecting {1} more bytes of headers", new Object[]{this.stack().name(), this.headerInputContent.remaining()});
                    }
                    return;
                }
                byte[] headerBytes = new byte[this.headerInputContent.capacity()];
                ((Buffer)this.headerInputContent).flip();
                this.headerInputContent.get(headerBytes, 0, this.headerInputContent.remaining());
                String headerAsString = new String(headerBytes, StandardCharsets.UTF_8);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "[{0}] Received headers \"{1}\"", new Object[]{this.stack().name(), headerAsString});
                }
                try {
                    Map<String, String> headers = ConnectionHeaders.fromString(headerAsString);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "[{0}] Received headers {1}", new Object[]{this.stack().name(), headers});
                    }
                    this.listener.onReceiveHeaders(headers);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "[{0}] Accepting headers from remote", this.stack().name());
                    }
                }
                catch (ConnectionHeaders.ParseException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "[{0}] Remote headers \"{1}\" could not be parsed: {2}", new Object[]{this.stack().name(), headerAsString, e.getMessage()});
                    }
                    this.responseOutput = ByteBufferUtils.wrapUTF8("ERROR: Malformed connection header");
                    if (this.headerOutput.hasRemaining()) {
                        this.next().doSend(this.headerOutput);
                    }
                    this.doStartAbort(new ConnectionRefusalException("Malformed connection header"), ByteBuffer.allocate(ABORT_MESSAGE.capacity()));
                    this.next().doSend(this.responseOutput);
                    return;
                }
                catch (ConnectionRefusalException e) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "[{0}] {1} headers from remote: {2}", new Object[]{this.stack().name(), e instanceof PermanentConnectionRefusalException ? "Permanently refusing" : "Refusing", e.getMessage()});
                    }
                    this.responseOutput = ByteBufferUtils.wrapUTF8(String.format("%s: %s", e instanceof PermanentConnectionRefusalException ? "FATAL" : "ERROR", e.getMessage()));
                    if (this.headerOutput.hasRemaining()) {
                        this.next().doSend(this.headerOutput);
                    }
                    this.doStartAbort(e, ByteBuffer.allocate(ABORT_MESSAGE.capacity()));
                    this.next().doSend(this.responseOutput);
                    return;
                }
                this.responseOutput = ByteBufferUtils.wrapUTF8("OK");
                if (this.headerOutput.hasRemaining()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] Sending {1} bytes of headers", new Object[]{this.stack().name(), this.headerOutput.remaining()});
                    }
                    this.next().doSend(this.headerOutput);
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "[{0}] Sending {1} bytes of response", new Object[]{this.stack().name(), this.responseOutput.remaining()});
                }
                this.next().doSend(this.responseOutput);
                this.responseInputLength = ByteBuffer.allocate(2);
            }
            if (!data.hasRemaining()) {
                return;
            }
            assert (this.abortConfirmationInput != null || this.responseInputLength != null);
            if (this.abortConfirmationInput != null) {
                if (this.abortConfirmationInput.hasRemaining()) {
                    ByteBufferUtils.put(data, this.abortConfirmationInput);
                }
                if (this.abortConfirmationInput.hasRemaining()) {
                    return;
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "[{0}] Received confirmation of {1} headers", new Object[]{this.stack().name(), this.abortCause instanceof PermanentConnectionRefusalException ? "permanently refused" : "refused"});
                }
                this.abortConfirmationTimeout.cancel(false);
                this.onAbortCompleted();
                throw this.abortCause;
            }
            if (this.responseInputLength.hasRemaining()) {
                ByteBufferUtils.put(data, this.responseInputLength);
                if (this.responseInputLength.hasRemaining()) {
                    return;
                }
                ((Buffer)this.responseInputLength).flip();
                length = this.responseInputLength.asShortBuffer().get() & 0xFFFF;
                ((Buffer)this.responseInputLength).position(2);
                this.responseInputContent = ByteBuffer.allocate(length);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "[{0}] Expecting {1} bytes of response", new Object[]{this.stack().name(), length});
                }
            }
            if (!data.hasRemaining()) {
                return;
            }
            if (this.responseInputContent.hasRemaining()) {
                String message;
                ByteBufferUtils.put(data, this.responseInputContent);
                if (this.responseInputContent.hasRemaining()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] Expecting {1} more bytes of response", new Object[]{this.stack().name(), this.responseInputContent.remaining()});
                    }
                    return;
                }
                byte[] responseBytes = new byte[this.responseInputContent.capacity()];
                ((Buffer)this.responseInputContent).flip();
                this.responseInputContent.get(responseBytes, 0, this.responseInputContent.remaining());
                String response = new String(responseBytes, StandardCharsets.UTF_8);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Received response \"{1}\"", new Object[]{this.stack().name(), response});
                }
                this.finished = true;
                if (response.startsWith("ERROR: ")) {
                    message = response.substring("ERROR: ".length());
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "[{0}] Local headers refused by remote: {1}", new Object[]{this.stack().name(), message});
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] Confirming receipt of refused connection: {1}", new Object[]{this.stack().name(), message});
                    }
                    this.next().doSend(ABORT_MESSAGE.duplicate());
                    this.doStartAbort(new ConnectionRefusalException(message), EMPTY_BUFFER);
                    return;
                }
                if (response.startsWith("FATAL: ")) {
                    message = response.substring("FATAL: ".length());
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "[{0}] Local headers permanently rejected by remote: {1}", new Object[]{this.stack().name(), message});
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] Confirming receipt of permanently rejected connection: {1}", new Object[]{this.stack().name(), message});
                    }
                    this.next().doSend(ABORT_MESSAGE.duplicate());
                    this.doStartAbort(new PermanentConnectionRefusalException(message), EMPTY_BUFFER);
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Local headers accepted by remote", this.stack().name());
                }
            }
            if (this.sendQueue.hasRemaining()) {
                try {
                    this.flushSend(this.sendQueue);
                }
                catch (IOException e) {
                    this.recvQueue.put(data);
                    throw e;
                }
            }
            if (this.recvQueue.hasRemaining()) {
                this.recvQueue.put(data);
                this.flushRecv(this.recvQueue);
            } else if (data.hasRemaining()) {
                this.next().onRecv(data);
            }
            if (!this.sendQueue.hasRemaining() && !this.recvQueue.hasRemaining()) {
                this.complete();
            }
        }
    }

    protected void complete() {
        if (LOGGER.isLoggable(Level.FINE)) {
            String name = this.stack().name();
            this.completed();
            LOGGER.log(Level.FINE, "[{0}] Connection header exchange completed", name);
        } else {
            this.completed();
        }
    }

    private static ConnectionRefusalException newAbortCause(ConnectionRefusalException abortCause) {
        return abortCause instanceof PermanentConnectionRefusalException ? new PermanentConnectionRefusalException(abortCause.getMessage()) : new ConnectionRefusalException(abortCause.getMessage());
    }

    private synchronized void doStartAbort(ConnectionRefusalException cause, ByteBuffer buffer) {
        ProtocolStack<?> stack = this.stack();
        this.abortConfirmationInput = buffer;
        this.abortCause = cause;
        this.abortConfirmationTimeout = stack.executeLater(new Aborter(), stack.getHandshakingTimeout(), stack.getHandshakingUnits());
    }

    private synchronized void onAbortCompleted() {
        this.aborted.set(this.abortCause);
        this.abort(this.abortCause);
        try {
            this.next().doCloseSend();
            this.next().onRecvClosed(this.abortCause);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void onRecvClosed(IOException cause) throws IOException {
        if (this.headerInputLength.hasRemaining() || this.headerInputContent.hasRemaining()) {
            super.onRecvClosed(cause);
            return;
        }
        if (this.headerOutput.hasRemaining()) {
            super.onRecvClosed(cause);
            return;
        }
        ConnectionRefusalException aborted = this.aborted.get();
        if (aborted != null && !(cause instanceof ConnectionRefusalException)) {
            ConnectionRefusalException newCause = ConnectionHeadersFilterLayer.newAbortCause(aborted);
            super.onRecvClosed((IOException)ThrowableUtils.chain(newCause, cause));
            return;
        }
        if (this.abortCause != null) {
            ConnectionRefusalException newCause = ConnectionHeadersFilterLayer.newAbortCause(this.abortCause);
            super.onRecvClosed((IOException)ThrowableUtils.chain(newCause, cause));
            return;
        }
        if (cause instanceof ClosedChannelException) {
            ConnectionRefusalException newCause = new ConnectionRefusalException("Remote closed connection without specifying reason");
            super.onRecvClosed((IOException)ThrowableUtils.chain(newCause, cause));
        } else {
            super.onRecvClosed(cause);
        }
    }

    @Override
    public boolean isRecvOpen() {
        return this.aborted.get() == null && super.isRecvOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSend(@NonNull ByteBuffer data) throws IOException {
        ConnectionRefusalException aborted = this.aborted.get();
        if (aborted != null) {
            throw ConnectionHeadersFilterLayer.newAbortCause(aborted);
        }
        ConnectionHeadersFilterLayer connectionHeadersFilterLayer = this;
        synchronized (connectionHeadersFilterLayer) {
            if (this.headerOutput.hasRemaining()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "[{0}] Sending {1} bytes of headers", new Object[]{this.stack().name(), this.headerOutput.remaining()});
                }
                this.next().doSend(this.headerOutput);
                if (!this.headerOutput.hasRemaining() && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Headers sent", this.stack().name());
                }
            }
            if (this.responseOutput != null && this.responseOutput.hasRemaining()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "[{0}] Sending {1} bytes of response", new Object[]{this.stack().name(), this.responseOutput.remaining()});
                }
                this.next().doSend(this.responseOutput);
                if (!this.responseOutput.hasRemaining() && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Response sent", this.stack().name());
                }
            }
            if (this.abortCause != null) {
                ((Buffer)data).clear();
            } else if (this.finished) {
                if (this.sendQueue.hasRemaining()) {
                    this.sendQueue.put(data);
                    this.flushSend(this.sendQueue);
                } else if (this.next() != null) {
                    this.next().doSend(data);
                    if (!this.sendQueue.hasRemaining() && !this.recvQueue.hasRemaining()) {
                        this.complete();
                    }
                }
            } else {
                this.sendQueue.put(data);
            }
        }
    }

    @Override
    public boolean isSendOpen() {
        return this.aborted.get() == null && super.isSendOpen();
    }

    private class Aborter
    implements Runnable {
        private Aborter() {
        }

        @Override
        public void run() {
            ConnectionHeadersFilterLayer.this.onAbortCompleted();
        }
    }

    public static interface Listener {
        public void onReceiveHeaders(Map<String, String> var1) throws ConnectionRefusalException;
    }
}

