/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;

@NotThreadSafe
public class JnlpConnectionState {
    private static final ThreadLocal<Iterator<JnlpConnectionStateListener>> fireIterator = new ThreadLocal();
    public static final String SECRET_KEY = "Secret-Key";
    public static final String CLIENT_NAME_KEY = "Node-Name";
    public static final String COOKIE_KEY = "JnlpAgentProtocol.cookie";
    @CheckForNull
    private final Socket socket;
    @NonNull
    private String remoteEndpointDescription = "<unknown>";
    private final List<JnlpConnectionStateListener> listeners;
    @CheckForNull
    private Map<String, String> properties;
    @CheckForNull
    private ChannelBuilder channelBuilder;
    @CheckForNull
    private Channel channel;
    @CheckForNull
    private ConnectionRefusalException rejection;
    @CheckForNull
    private IOException closeCause;
    private State lifecycle = State.INITIALIZED;
    @CheckForNull
    private ListenerState stash;

    public JnlpConnectionState(@Nullable Socket socket, List<? extends JnlpConnectionStateListener> listeners) {
        this.socket = socket;
        this.listeners = new ArrayList<JnlpConnectionStateListener>(listeners);
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="just a stub")
    @NonNull
    public Socket getSocket() {
        return this.socket != null ? this.socket : new Socket();
    }

    @NonNull
    public String getRemoteEndpointDescription() {
        return this.socket != null ? String.valueOf(this.socket.getRemoteSocketAddress()) : this.remoteEndpointDescription;
    }

    public void setRemoteEndpointDescription(@NonNull String description) {
        this.remoteEndpointDescription = description;
    }

    public Map<String, String> getProperties() {
        if (this.lifecycle.compareTo(State.AFTER_PROPERTIES) < 0) {
            throw new IllegalStateException("The connection properties have not been exchanged yet");
        }
        return this.properties;
    }

    public String getProperty(String name) {
        if (this.lifecycle.compareTo(State.AFTER_PROPERTIES) < 0) {
            throw new IllegalStateException("The connection properties have not been exchanged yet");
        }
        return this.properties == null ? null : this.properties.get(name);
    }

    public ChannelBuilder getChannelBuilder() {
        if (this.lifecycle.compareTo(State.APPROVED) < 0) {
            throw new IllegalStateException("The connection has not been approved yet");
        }
        if (this.lifecycle.compareTo(State.AFTER_CHANNEL) >= 0) {
            throw new IllegalStateException("The channel has already been built");
        }
        return this.channelBuilder;
    }

    public Channel getChannel() {
        if (this.lifecycle.compareTo(State.AFTER_CHANNEL) < 0) {
            throw new IllegalStateException("The channel has not been built yet");
        }
        return this.channel;
    }

    @CheckForNull
    public IOException getCloseCause() {
        if (this.lifecycle.compareTo(State.CHANNEL_CLOSED) < 0) {
            throw new IllegalStateException("The channel has not been closed yet");
        }
        return this.closeCause;
    }

    public void ignore() {
        if (this.lifecycle.compareTo(State.AFTER_PROPERTIES) > 0) {
            throw new IllegalStateException("Events cannot be ignored after approval/rejection");
        }
        Iterator<JnlpConnectionStateListener> iterator = fireIterator.get();
        if (iterator == null) {
            throw new IllegalStateException("Events can only be ignored from within the JnlpConnectionStateListener notification methods");
        }
        iterator.remove();
    }

    public void approve() {
        if (this.lifecycle.compareTo(State.AFTER_PROPERTIES) > 0) {
            throw new IllegalStateException("Events cannot be approved after approval/rejection");
        }
        this.lifecycle = State.APPROVED;
    }

    public void reject(ConnectionRefusalException reason) {
        if (this.lifecycle.compareTo(State.AFTER_PROPERTIES) > 0) {
            throw new IllegalStateException("Events cannot be rejected after approval/rejection");
        }
        this.lifecycle = State.REJECTED;
        this.rejection = reason;
    }

    @CheckForNull
    public <S extends ListenerState> S getStash(Class<S> clazz) {
        if (this.lifecycle.compareTo(State.APPROVED) < 0) {
            throw new IllegalStateException("The connection has not been approved yet");
        }
        return (S)((ListenerState)clazz.cast(this.stash));
    }

    public <S extends ListenerState> void setStash(@CheckForNull S stash) {
        if (this.lifecycle.compareTo(State.APPROVED) < 0) {
            throw new IllegalStateException("The connection has not been approved yet");
        }
        this.stash = stash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(EventHandler handler) {
        Iterator<JnlpConnectionStateListener> iterator = this.listeners.iterator();
        fireIterator.set(iterator);
        try {
            State lifecycle = this.lifecycle;
            while (iterator.hasNext()) {
                JnlpConnectionStateListener current = iterator.next();
                handler.invoke(current, this);
                if (lifecycle == this.lifecycle) continue;
                this.listeners.retainAll(Set.of(current));
                return;
            }
        }
        finally {
            fireIterator.remove();
        }
    }

    public void fireBeforeProperties() throws ConnectionRefusalException {
        if (this.lifecycle != State.INITIALIZED) {
            throw new IllegalStateException("fireBeforeProperties cannot be invoked at lifecycle " + this.lifecycle);
        }
        this.lifecycle = State.BEFORE_PROPERTIES;
        this.fire(JnlpConnectionStateListener::beforeProperties);
        if (this.lifecycle == State.REJECTED || this.listeners.isEmpty()) {
            this.lifecycle = State.REJECTED;
            ConnectionRefusalException rejection = this.rejection;
            this.rejection = null;
            if (rejection != null) {
                throw rejection;
            }
            throw new ConnectionRefusalException("No listeners interested in connection");
        }
    }

    public void fireAfterProperties(@NonNull Map<String, String> properties) throws ConnectionRefusalException {
        if (this.lifecycle != State.BEFORE_PROPERTIES) {
            throw new IllegalStateException("fireAfterProperties cannot be invoked at lifecycle " + this.lifecycle);
        }
        this.properties = new HashMap<String, String>(properties);
        this.lifecycle = State.AFTER_PROPERTIES;
        this.fire(JnlpConnectionStateListener::afterProperties);
        if (this.lifecycle != State.APPROVED || this.listeners.isEmpty()) {
            this.lifecycle = State.REJECTED;
            ConnectionRefusalException rejection = this.rejection;
            this.rejection = null;
            if (rejection != null) {
                throw rejection;
            }
            throw new ConnectionRefusalException("No listeners interested in connection");
        }
    }

    public void fireBeforeChannel(ChannelBuilder builder) {
        if (this.lifecycle != State.APPROVED) {
            throw new IllegalStateException("fireBeforeChannel cannot be invoked at lifecycle " + this.lifecycle);
        }
        this.lifecycle = State.BEFORE_CHANNEL;
        this.channelBuilder = builder;
        this.fire(JnlpConnectionStateListener::beforeChannel);
    }

    public void fireAfterChannel(Channel channel) {
        if (this.lifecycle != State.BEFORE_CHANNEL) {
            throw new IllegalStateException("fireAfterChannel cannot be invoked at lifecycle " + this.lifecycle);
        }
        this.lifecycle = State.AFTER_CHANNEL;
        this.channelBuilder = null;
        this.channel = channel;
        this.fire(JnlpConnectionStateListener::afterChannel);
    }

    public void fireChannelClosed(@CheckForNull IOException cause) {
        if (this.lifecycle.compareTo(State.BEFORE_CHANNEL) < 0) {
            throw new IllegalStateException("fireChannelClosed cannot be invoked at lifecycle " + this.lifecycle);
        }
        this.closeCause = cause;
        this.lifecycle = State.CHANNEL_CLOSED;
        this.fire(JnlpConnectionStateListener::channelClosed);
    }

    public void fireAfterDisconnect() {
        if (this.lifecycle == State.AFTER_CHANNEL) {
            this.fireChannelClosed(null);
        }
        this.lifecycle = State.DISCONNECTED;
        this.fire(JnlpConnectionStateListener::afterDisconnect);
    }

    public static interface ListenerState {
    }

    private static enum State {
        INITIALIZED,
        BEFORE_PROPERTIES,
        AFTER_PROPERTIES,
        REJECTED,
        APPROVED,
        BEFORE_CHANNEL,
        AFTER_CHANNEL,
        CHANNEL_CLOSED,
        DISCONNECTED;

    }

    private static interface EventHandler {
        public void invoke(JnlpConnectionStateListener var1, JnlpConnectionState var2);
    }
}

