/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.jnlp;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Engine;
import hudson.remoting.EngineListener;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.Util;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.Argument;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.CmdLineException;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.CmdLineParser;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.Option;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.engine.WorkDirManager;
import org.jenkinsci.remoting.util.PathUtils;

public class Main {
    @Option(name="-tunnel", metaVar="HOST:PORT", usage="Connect to the specified host and port, instead of connecting directly to Jenkins. Useful when connection to Jenkins needs to be tunneled. Can be also HOST: or :PORT, in which case the missing portion will be auto-configured like the default behavior")
    public String tunnel;
    @Deprecated
    @Option(name="-headless", usage="(deprecated; now always headless)")
    public boolean headlessMode;
    @Option(name="-url", usage="Specify the Jenkins root URLs to connect to.")
    public List<URL> urls = new ArrayList<URL>();
    @Option(name="-webSocket", usage="Make a WebSocket connection to Jenkins rather than using the TCP port.", depends={"-url"}, forbids={"-direct", "-tunnel", "-credentials", "-proxyCredentials", "-cert", "-disableHttpsCertValidation", "-noKeepAlive"})
    public boolean webSocket;
    @Option(name="-webSocketHeader", usage="Additional WebSocket header to set, eg for authenticating with reverse proxies. To specify multiple headers, call this flag multiple times, one with each header", metaVar="NAME=VALUE", depends={"-webSocket"})
    public Map<String, String> webSocketHeaders;
    @Option(name="-credentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP requests.")
    public String credentials;
    @Option(name="-proxyCredentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP authenticated proxy requests.")
    public String proxyCredentials = null;
    @Option(name="-noreconnect", usage="If the connection ends, don't retry and just exit.")
    public boolean noReconnect = false;
    @Option(name="-noKeepAlive", usage="Disable TCP socket keep alive on connection to the controller.")
    public boolean noKeepAlive = false;
    @Option(name="-cert", usage="Specify additional X.509 encoded PEM certificates to trust when connecting to Jenkins root URLs. If starting with @ then the remainder is assumed to be the name of the certificate file to read.")
    public List<String> candidateCertificates;
    @Option(name="-disableHttpsCertValidation", usage="Ignore SSL validation errors - use as a last resort only.")
    public boolean disableHttpsCertValidation = false;
    @Option(name="-agentLog", usage="Local agent error log destination (overrides workDir)")
    @CheckForNull
    public File agentLog = null;
    @Option(name="-loggingConfig", usage="Path to the property file with java.util.logging settings")
    @CheckForNull
    public File loggingConfigFile = null;
    @Option(name="-workDir", usage="Declares the working directory of the remoting instance (stores cache and logs by default)")
    @CheckForNull
    public File workDir = null;
    @Option(name="-internalDir", usage="Specifies a name of the internal files within a working directory ('remoting' by default)", depends={"-workDir"})
    @NonNull
    public String internalDir = WorkDirManager.DirType.INTERNAL_DIR.getDefaultLocation();
    @Option(name="-failIfWorkDirIsMissing", usage="Fails the initialization if the requested workDir or internalDir are missing ('false' by default)", depends={"-workDir"})
    public boolean failIfWorkDirIsMissing = false;
    @Option(name="-jar-cache", metaVar="DIR", usage="Cache directory that stores jar files sent from the controller")
    public File jarCache = null;
    @Option(name="-direct", metaVar="HOST:PORT", aliases={"-directConnection"}, depends={"-instanceIdentity"}, forbids={"-url", "-tunnel"}, usage="Connect directly to this TCP agent port, skipping the HTTP(S) connection parameter download. For example, \"myjenkins:50000\".")
    public String directConnection;
    @Option(name="-instanceIdentity", depends={"-direct"}, usage="The base64 encoded InstanceIdentity byte array of the Jenkins controller. When this is set, the agent skips connecting to an HTTP(S) port for connection info.")
    public String instanceIdentity;
    @Option(name="-protocols", depends={"-direct"}, usage="Specify the remoting protocols to attempt when instanceIdentity is provided.")
    public List<String> protocols = new ArrayList<String>();
    @Option(name="-help", usage="Show this help message")
    public boolean showHelp = false;
    @Option(name="-version", usage="Shows the version of the remoting jar and then exits")
    public boolean showVersion = false;
    @Argument
    public List<String> args = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws IOException, InterruptedException {
        try {
            Main._main(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar agent.jar [options...] <secret key> <agent name>");
            new CmdLineParser(new Main()).printUsage(System.err);
        }
    }

    public static void _main(String[] args) throws IOException, InterruptedException, CmdLineException {
        Main m = new Main();
        CmdLineParser p = new CmdLineParser(m);
        p.parseArgument(args);
        if (m.showHelp && !m.showVersion) {
            p.printUsage(System.out);
            return;
        }
        if (m.showVersion) {
            System.out.println(Util.getVersion());
            return;
        }
        if (m.args.size() != 2) {
            throw new CmdLineException(p, "two arguments required, but got " + m.args, null);
        }
        if (m.urls.isEmpty() && m.directConnection == null) {
            throw new CmdLineException(p, "At least one -url option is required.", null);
        }
        if (m.webSocket) {
            assert (!m.urls.isEmpty());
            if (m.urls.size() > 1) {
                throw new CmdLineException(p, "-webSocket supports only a single -url", null);
            }
        }
        m.main();
    }

    public void main() throws IOException, InterruptedException {
        Engine engine = this.createEngine();
        engine.startEngine();
        try {
            engine.join();
            LOGGER.fine("Engine has died");
        }
        finally {
            engine.interrupt();
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Parameter supplied by user / administrator.")
    public Engine createEngine() {
        String agentName = this.args.get(1);
        LOGGER.log(Level.INFO, "Setting up agent: {0}", agentName);
        Engine engine = new Engine(new CuiListener(), this.urls, this.args.get(0), agentName, this.directConnection, this.instanceIdentity, new HashSet<String>(this.protocols));
        engine.setWebSocket(this.webSocket);
        if (this.webSocketHeaders != null) {
            engine.setWebSocketHeaders(this.webSocketHeaders);
        }
        if (this.tunnel != null) {
            engine.setTunnel(this.tunnel);
        }
        if (this.credentials != null) {
            engine.setCredentials(this.credentials);
        }
        if (this.proxyCredentials != null) {
            engine.setProxyCredentials(this.proxyCredentials);
        }
        if (this.jarCache != null) {
            engine.setJarCache(new FileSystemJarCache(this.jarCache, true));
        }
        engine.setNoReconnect(this.noReconnect);
        engine.setKeepAlive(!this.noKeepAlive);
        if (this.disableHttpsCertValidation) {
            LOGGER.log(Level.WARNING, "Certificate validation for HTTPs endpoints is disabled");
        }
        engine.setDisableHttpsCertValidation(this.disableHttpsCertValidation);
        if (this.agentLog != null) {
            try {
                engine.setAgentLog(PathUtils.fileToPath(this.agentLog));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot retrieve custom log destination", ex);
            }
        }
        if (this.loggingConfigFile != null) {
            try {
                engine.setLoggingConfigFile(PathUtils.fileToPath(this.loggingConfigFile));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Logging config file is invalid", ex);
            }
        }
        if (this.candidateCertificates != null && !this.candidateCertificates.isEmpty()) {
            CertificateFactory factory;
            try {
                factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new IllegalStateException("Java platform specification mandates support for X.509", e);
            }
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.candidateCertificates.size());
            for (String certOrAtFilename : this.candidateCertificates) {
                byte[] cert;
                block34: {
                    if ((certOrAtFilename = certOrAtFilename.trim()).startsWith("@")) {
                        long length;
                        File file = new File(certOrAtFilename.substring(1));
                        if (file.isFile() && (length = file.length()) < 65536L && length > (long)"-----BEGIN CERTIFICATE-----\n-----END CERTIFICATE-----".length()) {
                            try {
                                int read;
                                cert = new byte[(int)length];
                                try (FileInputStream fis = new FileInputStream(file);){
                                    read = fis.read(cert);
                                }
                                if (cert.length != read) {
                                    LOGGER.log(Level.WARNING, "Only read {0} bytes from {1}, expected to read {2}", new Object[]{read, file, cert.length});
                                }
                                break block34;
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, e, () -> "Could not read certificate from " + file);
                            }
                            continue;
                        }
                        if (file.isFile()) {
                            LOGGER.log(Level.WARNING, "Could not read certificate from {0}. File size is not within the expected range for a PEM encoded X.509 certificate", file.getAbsolutePath());
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "Could not read certificate from {0}. File not found", file.getAbsolutePath());
                        continue;
                    }
                    cert = certOrAtFilename.getBytes(StandardCharsets.US_ASCII);
                }
                try {
                    certificates.add((X509Certificate)factory.generateCertificate(new ByteArrayInputStream(cert)));
                }
                catch (ClassCastException e) {
                    LOGGER.log(Level.WARNING, "Expected X.509 certificate from " + certOrAtFilename, e);
                }
                catch (CertificateException e) {
                    LOGGER.log(Level.WARNING, "Could not parse X.509 certificate from " + certOrAtFilename, e);
                }
            }
            engine.setCandidateCertificates(certificates);
        }
        if (this.workDir != null) {
            try {
                engine.setWorkDir(PathUtils.fileToPath(this.workDir));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Work directory path is invalid", ex);
            }
        }
        engine.setInternalDir(this.internalDir);
        engine.setFailIfWorkDirIsMissing(this.failIfWorkDirIsMissing);
        return engine;
    }

    private static final class CuiListener
    implements EngineListener {
        private CuiListener() {
        }

        @Override
        public void status(String msg, Throwable t) {
            LOGGER.log(Level.INFO, msg, t);
        }

        @Override
        public void status(String msg) {
            this.status(msg, null);
        }

        @Override
        @SuppressFBWarnings(value={"DM_EXIT"}, justification="Yes, we really want to exit in the case of severe error")
        public void error(Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            System.exit(-1);
        }

        @Override
        public void onDisconnect() {
        }

        @Override
        public void onReconnect() {
        }
    }
}

