/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.AbstractByteBufferCommandTransport;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerSplitter;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import hudson.remoting.Launcher;
import io.jenkins.remoting.shaded.jakarta.websocket.ClientEndpointConfig;
import io.jenkins.remoting.shaded.jakarta.websocket.CloseReason;
import io.jenkins.remoting.shaded.jakarta.websocket.ContainerProvider;
import io.jenkins.remoting.shaded.jakarta.websocket.Endpoint;
import io.jenkins.remoting.shaded.jakarta.websocket.EndpointConfig;
import io.jenkins.remoting.shaded.jakarta.websocket.HandshakeResponse;
import io.jenkins.remoting.shaded.jakarta.websocket.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.remoting.engine.Jnlp4ConnectionState;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;
import org.jenkinsci.remoting.engine.JnlpAgentEndpointConfigurator;
import org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.JnlpEndpointResolver;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.engine.JnlpProtocolHandlerFactory;
import org.jenkinsci.remoting.engine.WorkDirManager;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.cert.BlindTrustX509ExtendedTrustManager;
import org.jenkinsci.remoting.protocol.cert.DelegatingX509ExtendedTrustManager;
import org.jenkinsci.remoting.protocol.cert.PublicKeyMatchingX509ExtendedTrustManager;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.util.KeyUtils;
import org.jenkinsci.remoting.util.VersionNumber;

@NotThreadSafe
public class Engine
extends Thread {
    public static final String REMOTING_MINIMUM_VERSION_HEADER = "X-Remoting-Minimum-Version";
    public static final String WEBSOCKET_COOKIE_HEADER = "Connection-Cookie";
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread thread = this.defaultFactory.newThread(() -> {
                CURRENT.set(Engine.this);
                r.run();
            });
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t, e) -> LOGGER.log(Level.SEVERE, e, () -> "Uncaught exception in thread " + t));
            return thread;
        }
    });
    @Deprecated
    public final EngineListener listener;
    private final EngineListenerSplitter events = new EngineListenerSplitter();
    private final List<URL> candidateUrls;
    private List<X509Certificate> candidateCertificates;
    @CheckForNull
    private URL hudsonUrl;
    private final String secretKey;
    private final String agentName;
    private boolean webSocket;
    private Map<String, String> webSocketHeaders;
    private String credentials;
    private String protocolName;
    private String proxyCredentials = System.getProperty("proxyCredentials");
    @CheckForNull
    private String tunnel;
    private boolean disableHttpsCertValidation = false;
    private boolean noReconnect = false;
    private boolean keepAlive = true;
    @CheckForNull
    private JarCache jarCache = null;
    @CheckForNull
    private Path agentLog;
    @CheckForNull
    private Path loggingConfigFilePath = null;
    @CheckForNull
    public Path workDir = null;
    @NonNull
    public String internalDir = WorkDirManager.DirType.INTERNAL_DIR.getDefaultLocation();
    public boolean failIfWorkDirIsMissing = false;
    private final DelegatingX509ExtendedTrustManager agentTrustManager = new DelegatingX509ExtendedTrustManager(new BlindTrustX509ExtendedTrustManager());
    private final String directConnection;
    private final String instanceIdentity;
    private final Set<String> protocols;
    private static final ThreadLocal<Engine> CURRENT = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    static final int SOCKET_TIMEOUT = Integer.getInteger(Engine.class.getName() + ".socketTimeout", 1800000);

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String agentName) {
        this(listener, hudsonUrls, secretKey, agentName, null, null, null);
    }

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String agentName, String directConnection, String instanceIdentity, Set<String> protocols) {
        this.listener = listener;
        this.directConnection = directConnection;
        this.events.add(listener);
        this.candidateUrls = hudsonUrls.stream().map(Engine::ensureTrailingSlash).collect(Collectors.toList());
        this.secretKey = secretKey;
        this.agentName = agentName;
        this.instanceIdentity = instanceIdentity;
        this.protocols = protocols;
        if (this.candidateUrls.isEmpty() && instanceIdentity == null) {
            throw new IllegalArgumentException("No URLs given");
        }
        this.setUncaughtExceptionHandler((t, e) -> {
            LOGGER.log(Level.SEVERE, e, () -> "Uncaught exception in Engine thread " + t);
            this.interrupt();
        });
    }

    private static URL ensureTrailingSlash(URL u) {
        if (u.toString().endsWith("/")) {
            return u;
        }
        try {
            return new URL(u + "/");
        }
        catch (MalformedURLException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public synchronized void startEngine() throws IOException {
        this.startEngine(false);
    }

    void startEngine(boolean dryRun) throws IOException {
        LOGGER.log(Level.INFO, "Using Remoting version: {0}", Launcher.VERSION);
        File jarCacheDirectory = null;
        if (this.workDir != null) {
            WorkDirManager workDirManager = WorkDirManager.getInstance();
            if (this.jarCache != null) {
                workDirManager.disable(WorkDirManager.DirType.JAR_CACHE_DIR);
            }
            if (this.loggingConfigFilePath != null) {
                workDirManager.setLoggingConfig(this.loggingConfigFilePath.toFile());
            }
            Path path = workDirManager.initializeWorkDir(this.workDir.toFile(), this.internalDir, this.failIfWorkDirIsMissing);
            jarCacheDirectory = workDirManager.getLocation(WorkDirManager.DirType.JAR_CACHE_DIR);
            workDirManager.setupLogging(path, this.agentLog);
        } else if (this.jarCache == null) {
            LOGGER.log(Level.WARNING, "No Working Directory. Using the legacy JAR Cache location: {0}", JarCache.DEFAULT_NOWS_JAR_CACHE_LOCATION);
            jarCacheDirectory = JarCache.DEFAULT_NOWS_JAR_CACHE_LOCATION;
        }
        if (this.jarCache == null) {
            if (jarCacheDirectory == null) {
                throw new IOException("Cannot find the JAR Cache location");
            }
            LOGGER.log(Level.FINE, "Using standard File System JAR Cache. Root Directory is {0}", jarCacheDirectory);
            try {
                this.jarCache = new FileSystemJarCache(jarCacheDirectory, true);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Failed to initialize FileSystem JAR Cache in " + jarCacheDirectory, ex);
            }
        } else {
            LOGGER.log(Level.INFO, "Using custom JAR Cache: {0}", this.jarCache);
        }
        if (!dryRun) {
            this.start();
        }
    }

    public void setJarCache(@NonNull JarCache jarCache) {
        this.jarCache = jarCache;
    }

    public void setLoggingConfigFile(@NonNull Path filePath) {
        this.loggingConfigFilePath = filePath;
    }

    @CheckForNull
    public URL getHudsonUrl() {
        return this.hudsonUrl;
    }

    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    public void setWebSocketHeaders(@NonNull Map<String, String> webSocketHeaders) {
        this.webSocketHeaders = webSocketHeaders;
    }

    public void setTunnel(@CheckForNull String tunnel) {
        this.tunnel = tunnel;
    }

    public void setCredentials(String creds) {
        this.credentials = creds;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setNoReconnect(boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    public boolean isDisableHttpsCertValidation() {
        return this.disableHttpsCertValidation;
    }

    public void setDisableHttpsCertValidation(boolean disableHttpsCertValidation) {
        this.disableHttpsCertValidation = disableHttpsCertValidation;
    }

    public void setAgentLog(@CheckForNull Path agentLog) {
        this.agentLog = agentLog;
    }

    public void setWorkDir(@CheckForNull Path workDir) {
        this.workDir = workDir;
    }

    public void setInternalDir(@NonNull String internalDir) {
        this.internalDir = internalDir;
    }

    public void setFailIfWorkDirIsMissing(boolean failIfWorkDirIsMissing) {
        this.failIfWorkDirIsMissing = failIfWorkDirIsMissing;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setCandidateCertificates(List<X509Certificate> candidateCertificates) {
        this.candidateCertificates = candidateCertificates == null ? null : new ArrayList<X509Certificate>(candidateCertificates);
    }

    public void addCandidateCertificate(X509Certificate certificate) {
        if (this.candidateCertificates == null) {
            this.candidateCertificates = new ArrayList<X509Certificate>();
        }
        this.candidateCertificates.add(certificate);
    }

    public void addListener(EngineListener el) {
        this.events.add(el);
    }

    public void removeListener(EngineListener el) {
        this.events.remove(el);
    }

    @Override
    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Password doesn't need to be protected.")
    public void run() {
        if (this.webSocket) {
            this.runWebSocket();
            return;
        }
        try {
            IOHub hub = IOHub.create(this.executor);
            try {
                KeyManagerFactory kmf;
                KeyStore store;
                SSLContext context;
                try {
                    context = SSLContext.getInstance("TLS");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Java runtime specification requires support for TLS algorithm", e);
                }
                char[] password = "password".toCharArray();
                try {
                    store = KeyStore.getInstance(KeyStore.getDefaultType());
                }
                catch (KeyStoreException e) {
                    throw new IllegalStateException("Java runtime specification requires support for JKS key store", e);
                }
                try {
                    store.load(null, password);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Java runtime specification requires support for JKS key store", e);
                }
                catch (CertificateException e) {
                    throw new IllegalStateException("Empty keystore", e);
                }
                try {
                    kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Java runtime specification requires support for default key manager", e);
                }
                try {
                    kmf.init(store, password);
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    throw new IllegalStateException(e);
                }
                try {
                    context.init(kmf.getKeyManagers(), new TrustManager[]{this.agentTrustManager}, null);
                }
                catch (KeyManagementException e) {
                    this.events.error(e);
                    if (hub != null) {
                        hub.close();
                    }
                    return;
                }
                this.innerRun(hub, context, this.executor);
            }
            finally {
                if (hub != null) {
                    try {
                        hub.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            this.events.error(e);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION", "URLCONNECTION_SSRF_FD"}, justification="checked exceptions were a mistake to begin with; connecting to Jenkins from agent")
    private void runWebSocket() {
        try {
            String localCap = new Capability().toASCII();
            final HashMap<String, List<String>> addedHeaders = new HashMap<String, List<String>>();
            addedHeaders.put("Node-Name", List.of(this.agentName));
            addedHeaders.put("Secret-Key", List.of(this.secretKey));
            addedHeaders.put("X-Remoting-Capability", List.of(localCap));
            if (this.webSocketHeaders != null) {
                for (Map.Entry<String, String> entry : this.webSocketHeaders.entrySet()) {
                    addedHeaders.put(entry.getKey(), List.of(entry.getValue()));
                }
            }
            while (true) {
                final AtomicReference ch = new AtomicReference();
                class HeaderHandler
                extends ClientEndpointConfig.Configurator {
                    Capability remoteCapability = new Capability();

                    HeaderHandler() {
                    }

                    @Override
                    public void beforeRequest(Map<String, List<String>> headers) {
                        headers.putAll(addedHeaders);
                        LOGGER.fine(() -> "Sending: " + headers);
                    }

                    @Override
                    public void afterResponse(HandshakeResponse hr) {
                        VersionNumber minimumSupportedVersion;
                        VersionNumber currentVersion;
                        LOGGER.fine(() -> "Receiving: " + hr.getHeaders());
                        List<String> remotingMinimumVersion = hr.getHeaders().get(Engine.REMOTING_MINIMUM_VERSION_HEADER);
                        if (remotingMinimumVersion != null && !remotingMinimumVersion.isEmpty() && (currentVersion = new VersionNumber(Launcher.VERSION)).isOlderThan(minimumSupportedVersion = new VersionNumber(remotingMinimumVersion.get(0)))) {
                            Engine.this.events.error(new IOException("Agent version " + minimumSupportedVersion + " or newer is required."));
                        }
                        try {
                            List<String> cookies = hr.getHeaders().get(Engine.WEBSOCKET_COOKIE_HEADER);
                            if (cookies != null && !cookies.isEmpty()) {
                                addedHeaders.put(Engine.WEBSOCKET_COOKIE_HEADER, List.of(cookies.get(0)));
                            } else {
                                addedHeaders.remove(Engine.WEBSOCKET_COOKIE_HEADER);
                            }
                            this.remoteCapability = Capability.fromASCII(hr.getHeaders().get("X-Remoting-Capability").get(0));
                            LOGGER.fine(() -> "received " + this.remoteCapability);
                        }
                        catch (IOException x) {
                            Engine.this.events.error(x);
                        }
                    }
                }
                final HeaderHandler headerHandler = new HeaderHandler();
                this.hudsonUrl = this.candidateUrls.get(0);
                String wsUrl = this.hudsonUrl.toString().replaceFirst("^http", "ws");
                class AgentEndpoint
                extends Endpoint {
                    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="just trust me here")
                    1AgentEndpoint.Transport transport;

                    AgentEndpoint() {
                    }

                    @Override
                    public void onOpen(Session session, EndpointConfig config) {
                        Engine.this.events.status("WebSocket connection open");
                        session.addMessageHandler(ByteBuffer.class, this::onMessage);
                        try {
                            this.transport = new 1AgentEndpoint.Transport(session);
                            ch.set(new ChannelBuilder(Engine.this.agentName, Engine.this.executor).withJarCacheOrDefault(Engine.this.jarCache).build(this.transport));
                        }
                        catch (IOException x) {
                            Engine.this.events.error(x);
                        }
                    }

                    private void onMessage(ByteBuffer message) {
                        try {
                            this.transport.receive(message);
                        }
                        catch (IOException x) {
                            Engine.this.events.error(x);
                        }
                        catch (InterruptedException x) {
                            Engine.this.events.error(x);
                            Thread.currentThread().interrupt();
                        }
                    }

                    @Override
                    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="We want the transport.terminate method to run asynchronously and don't want to wait for its status.")
                    public void onClose(Session session, CloseReason closeReason) {
                        LOGGER.fine(() -> "onClose: " + closeReason);
                        ((Channel)ch.get()).executor.submit(() -> this.transport.terminate(new ChannelClosedException((Channel)ch.get(), null)));
                    }

                    @Override
                    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="We want the transport.terminate method to run asynchronously and don't want to wait for its status.")
                    public void onError(Session session, Throwable x) {
                        LOGGER.log(Level.FINE, null, x);
                        ((Channel)ch.get()).executor.submit(() -> this.transport.terminate(new ChannelClosedException((Channel)ch.get(), x)));
                    }

                    class 1AgentEndpoint.Transport
                    extends AbstractByteBufferCommandTransport {
                        final Session session;

                        1AgentEndpoint.Transport(Session session) {
                            super(true);
                            this.session = session;
                        }

                        @Override
                        protected void write(ByteBuffer headerAndData) throws IOException {
                            LOGGER.finest(() -> "sending message of length " + (headerAndData.remaining() - 2));
                            try {
                                this.session.getAsyncRemote().sendBinary(headerAndData).get(5L, TimeUnit.MINUTES);
                            }
                            catch (Exception x) {
                                throw new IOException(x);
                            }
                        }

                        @Override
                        public Capability getRemoteCapability() {
                            return headerHandler.remoteCapability;
                        }

                        @Override
                        public void closeWrite() throws IOException {
                            Engine.this.events.status("Write side closed");
                            this.session.close();
                        }

                        @Override
                        public void closeRead() throws IOException {
                            Engine.this.events.status("Read side closed");
                            this.session.close();
                        }
                    }
                }
                ContainerProvider.getWebSocketContainer().connectToServer(new AgentEndpoint(), ClientEndpointConfig.Builder.create().configurator(headerHandler).build(), URI.create(wsUrl + "wsagents/"));
                while (ch.get() == null) {
                    Thread.sleep(100L);
                }
                this.protocolName = "WebSocket";
                this.events.status("Connected");
                ((Channel)ch.get()).join();
                this.events.status("Terminated");
                if (this.noReconnect) {
                    return;
                }
                this.events.onDisconnect();
                while (true) {
                    TimeUnit.SECONDS.sleep(10L);
                    URL ping = new URL(this.hudsonUrl, "login");
                    try {
                        HttpURLConnection conn = (HttpURLConnection)ping.openConnection();
                        int status = conn.getResponseCode();
                        conn.disconnect();
                        if (status == 200) break;
                        this.events.status(ping + " is not ready: " + status);
                    }
                    catch (IOException x) {
                        this.events.status(ping + " is not ready", x);
                    }
                }
                this.reconnect();
            }
        }
        catch (Exception e) {
            this.events.error(e);
            return;
        }
    }

    private void reconnect() {
        try {
            this.events.status("Performing onReconnect operation.");
            this.events.onReconnect();
            this.events.status("onReconnect operation completed.");
        }
        catch (NoClassDefFoundError e) {
            this.events.status("onReconnect operation failed.");
            LOGGER.log(Level.WARNING, "Reconnection error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRun(IOHub hub, SSLContext context, ExecutorService service) {
        List<JnlpProtocolHandler<? extends JnlpConnectionState>> protocols = new JnlpProtocolHandlerFactory(service).withIOHub(hub).withSSLContext(context).withPreferNonBlockingIO(false).handlers();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Node-Name", this.agentName);
        headers.put("Secret-Key", this.secretKey);
        ArrayList<String> jenkinsUrls = new ArrayList<String>();
        for (URL url : this.candidateUrls) {
            jenkinsUrls.add(url.toExternalForm());
        }
        JnlpEndpointResolver resolver = this.createEndpointResolver(jenkinsUrls);
        try {
            boolean first = true;
            while (true) {
                JnlpAgentEndpoint endpoint;
                if (first) {
                    first = false;
                } else if (this.noReconnect) {
                    return;
                }
                this.events.status("Locating server among " + this.candidateUrls);
                try {
                    endpoint = resolver.resolve();
                }
                catch (Exception e) {
                    if (Boolean.getBoolean(Engine.class.getName() + ".nonFatalJnlpAgentEndpointResolutionExceptions")) {
                        this.events.status("Could not resolve JNLP agent endpoint", e);
                    } else {
                        this.events.error(e);
                    }
                    return;
                }
                if (endpoint == null) {
                    this.events.status("Could not resolve server among " + this.candidateUrls);
                    return;
                }
                this.hudsonUrl = endpoint.getServiceUrl();
                this.events.status(String.format("Agent discovery successful%n  Agent address: %s%n  Agent port:    %d%n  Identity:      %s", endpoint.getHost(), endpoint.getPort(), KeyUtils.fingerprint(endpoint.getPublicKey())));
                PublicKeyMatchingX509ExtendedTrustManager delegate = new PublicKeyMatchingX509ExtendedTrustManager(new PublicKey[0]);
                RSAPublicKey publicKey = endpoint.getPublicKey();
                if (publicKey != null) {
                    delegate.add(publicKey);
                }
                this.agentTrustManager.setDelegate(delegate);
                this.events.status("Handshaking");
                Socket jnlpSocket = this.connectTcp(endpoint);
                Channel channel = null;
                try {
                    boolean triedAtLeastOneProtocol = false;
                    for (JnlpProtocolHandler<? extends JnlpConnectionState> protocol : protocols) {
                        if (!protocol.isEnabled()) {
                            this.events.status("Protocol " + protocol.getName() + " is not enabled, skipping");
                            continue;
                        }
                        if (jnlpSocket == null) {
                            jnlpSocket = this.connectTcp(endpoint);
                        }
                        if (!endpoint.isProtocolSupported(protocol.getName())) {
                            this.events.status("Server reports protocol " + protocol.getName() + " not supported, skipping");
                            continue;
                        }
                        triedAtLeastOneProtocol = true;
                        this.events.status("Trying protocol: " + protocol.getName());
                        try {
                            channel = protocol.connect(jnlpSocket, headers, new EngineJnlpConnectionStateListener(endpoint.getPublicKey(), headers)).get();
                        }
                        catch (IOException ioe) {
                            this.events.status("Protocol " + protocol.getName() + " failed to establish channel", ioe);
                        }
                        catch (RuntimeException e) {
                            this.events.status("Protocol " + protocol.getName() + " encountered a runtime error", e);
                        }
                        catch (Error e) {
                            this.events.status("Protocol " + protocol.getName() + " could not be completed due to an error", e);
                        }
                        catch (Throwable e) {
                            this.events.status("Protocol " + protocol.getName() + " encountered an unexpected exception", e);
                        }
                        if (channel != null) {
                            this.protocolName = protocol.getName();
                            break;
                        }
                        jnlpSocket.close();
                        jnlpSocket = null;
                    }
                    if (channel == null) {
                        if (triedAtLeastOneProtocol) {
                            this.onConnectionRejected("None of the protocols were accepted");
                            continue;
                        }
                        this.onConnectionRejected("None of the protocols are enabled");
                        return;
                    }
                    this.events.status("Connected");
                    channel.join();
                    this.events.status("Terminated");
                }
                finally {
                    if (jnlpSocket == null) continue;
                    try {
                        jnlpSocket.close();
                    }
                    catch (IOException e) {
                        this.events.status("Failed to close socket", e);
                    }
                    continue;
                }
                if (this.noReconnect) {
                    return;
                }
                this.events.onDisconnect();
                resolver.waitForReady();
                this.reconnect();
            }
        }
        catch (Throwable e) {
            this.events.error(e);
            return;
        }
    }

    private JnlpEndpointResolver createEndpointResolver(List<String> jenkinsUrls) {
        JnlpEndpointResolver resolver;
        if (this.directConnection == null) {
            SSLSocketFactory sslSocketFactory = null;
            try {
                sslSocketFactory = this.getSSLSocketFactory();
            }
            catch (Exception e) {
                this.events.error(e);
            }
            resolver = new JnlpAgentEndpointResolver(jenkinsUrls, this.credentials, this.proxyCredentials, this.tunnel, sslSocketFactory, this.disableHttpsCertValidation);
        } else {
            resolver = new JnlpAgentEndpointConfigurator(this.directConnection, this.instanceIdentity, this.protocols);
        }
        return resolver;
    }

    private void onConnectionRejected(String greeting) throws InterruptedException {
        this.events.status("reconnect rejected, sleeping 10s: ", new Exception("The server rejected the connection: " + greeting));
        TimeUnit.SECONDS.sleep(10L);
    }

    private Socket connectTcp(@NonNull JnlpAgentEndpoint endpoint) throws IOException, InterruptedException {
        String msg = "Connecting to " + endpoint.getHost() + ":" + endpoint.getPort();
        this.events.status(msg);
        int retry = 1;
        while (true) {
            try {
                Socket s = endpoint.open(SOCKET_TIMEOUT);
                s.setKeepAlive(this.keepAlive);
                return s;
            }
            catch (IOException e) {
                if (retry++ > 10) {
                    throw e;
                }
                TimeUnit.SECONDS.sleep(10L);
                this.events.status(msg + " (retrying:" + retry + ")", e);
                continue;
            }
            break;
        }
    }

    public static Engine current() {
        return CURRENT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File path is loaded from system properties.")
    static KeyStore getCacertsKeyStore() throws PrivilegedActionException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException, IOException {
        Map properties = AccessController.doPrivileged(() -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
            result.put("javaHome", System.getProperty("java.home"));
            result.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
            result.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
            result.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
            return result;
        });
        KeyStore keystore = null;
        try (FileInputStream trustStoreStream = null;){
            String trustStore = (String)properties.get("trustStore");
            if (!"NONE".equals(trustStore)) {
                File trustStoreFile;
                if (trustStore != null) {
                    trustStoreFile = new File(trustStore);
                    trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                } else {
                    String javaHome = (String)properties.get("javaHome");
                    trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts");
                    trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                    if (trustStoreStream == null) {
                        trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
                        trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                    }
                }
                trustStore = trustStoreStream != null ? trustStoreFile.getPath() : "No File Available, using empty keystore.";
            }
            String trustStoreType = (String)properties.get("trustStoreType");
            String trustStoreProvider = (String)properties.get("trustStoreProvider");
            LOGGER.log(Level.FINE, "trustStore is: {0}", trustStore);
            LOGGER.log(Level.FINE, "trustStore type is: {0}", trustStoreType);
            LOGGER.log(Level.FINE, "trustStore provider is: {0}", trustStoreProvider);
            if (trustStoreType.length() != 0) {
                LOGGER.log(Level.FINE, "init truststore");
                keystore = trustStoreProvider.length() == 0 ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
                char[] trustStorePasswdChars = null;
                String trustStorePasswd = (String)properties.get("trustStorePasswd");
                if (trustStorePasswd.length() != 0) {
                    trustStorePasswdChars = trustStorePasswd.toCharArray();
                }
                keystore.load(trustStoreStream, trustStorePasswdChars);
                if (trustStorePasswdChars != null) {
                    Arrays.fill(trustStorePasswdChars, '\u0000');
                }
            }
        }
        return keystore;
    }

    @CheckForNull
    private static FileInputStream getFileInputStream(File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        });
    }

    private SSLSocketFactory getSSLSocketFactory() throws PrivilegedActionException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLSocketFactory sslSocketFactory = null;
        if (this.candidateCertificates != null && !this.candidateCertificates.isEmpty()) {
            KeyStore keyStore = Engine.getCacertsKeyStore();
            keyStore.load(null, null);
            int i = 0;
            for (X509Certificate c : this.candidateCertificates) {
                keyStore.setCertificateEntry(String.format("alias-%d", i++), c);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagerFactory.getTrustManagers(), null);
            sslSocketFactory = ctx.getSocketFactory();
        }
        return sslSocketFactory;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    private class EngineJnlpConnectionStateListener
    extends JnlpConnectionStateListener {
        private final RSAPublicKey publicKey;
        private final Map<String, String> headers;

        public EngineJnlpConnectionStateListener(RSAPublicKey publicKey, Map<String, String> headers) {
            this.publicKey = publicKey;
            this.headers = headers;
        }

        @Override
        public void beforeProperties(@NonNull JnlpConnectionState event) {
            X509Certificate certificate;
            if (event instanceof Jnlp4ConnectionState && (certificate = ((Jnlp4ConnectionState)event).getCertificate()) != null) {
                String fingerprint = KeyUtils.fingerprint(certificate.getPublicKey());
                if (!KeyUtils.equals(this.publicKey, certificate.getPublicKey())) {
                    event.reject(new ConnectionRefusalException("Expecting identity " + fingerprint));
                }
                Engine.this.events.status("Remote identity confirmed: " + fingerprint);
            }
        }

        @Override
        public void afterProperties(@NonNull JnlpConnectionState event) {
            event.approve();
        }

        @Override
        public void beforeChannel(@NonNull JnlpConnectionState event) {
            ChannelBuilder bldr = event.getChannelBuilder().withMode(Channel.Mode.BINARY);
            if (Engine.this.jarCache != null) {
                bldr.withJarCache(Engine.this.jarCache);
            }
        }

        @Override
        public void afterChannel(@NonNull JnlpConnectionState event) {
            String cookie = event.getProperty("JnlpAgentProtocol.cookie");
            if (cookie == null) {
                this.headers.remove("JnlpAgentProtocol.cookie");
            } else {
                this.headers.put("JnlpAgentProtocol.cookie", cookie);
            }
        }
    }
}

