/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.ProtocolLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.util.ByteBufferQueue;

public abstract class NetworkLayer
implements ProtocolLayer,
ProtocolLayer.Send {
    private static final Logger LOGGER = Logger.getLogger(NetworkLayer.class.getName());
    private static final int CAPACITY = 8192;
    @Nonnull
    private final IOHub ioHub;
    private ByteBufferQueue sendQueue;
    private ByteBufferQueue recvQueue;
    private ProtocolStack.Ptr ptr;

    public NetworkLayer(@Nonnull IOHub ioHub) {
        this.ioHub = ioHub;
        this.recvQueue = new ByteBufferQueue(8192);
        this.sendQueue = new ByteBufferQueue(8192);
    }

    @Override
    public final void doSend(@Nonnull ByteBuffer data) throws IOException {
        ByteBufferQueue sendQueue = this.sendQueue;
        if (this.ptr == null) {
            sendQueue.put(data);
        } else if (sendQueue != null && sendQueue.hasRemaining()) {
            sendQueue.put(data);
            this.flushSendQueue();
        } else {
            this.write(data);
        }
    }

    protected abstract void write(@Nonnull ByteBuffer var1) throws IOException;

    protected final void onRead(ByteBuffer data) throws IOException {
        ByteBufferQueue recvQueue = this.recvQueue;
        if (this.ptr == null) {
            recvQueue.put(data);
        } else if (recvQueue != null && recvQueue.hasRemaining()) {
            recvQueue.put(data);
            this.flushRecvQueue();
        } else {
            this.ptr.onRecv(data);
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected final void onRecvClosed() {
        if (this.ptr == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.ptr.isRecvOpen()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] RECV Closed", this.ptr.stack().name());
            }
            try {
                this.ptr.onRecvClosed(new ClosedChannelException());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract void doCloseRecv();

    protected final boolean isRecvOpen() {
        if (this.ptr == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.ptr.isRecvOpen();
    }

    private void flushRecvQueue() throws IOException {
        if (this.recvQueue == null) {
            return;
        }
        ByteBuffer tmp = this.recvQueue.newByteBuffer();
        while (this.recvQueue.hasRemaining()) {
            tmp.clear();
            this.recvQueue.get(tmp);
            tmp.flip();
            this.ptr.onRecv(tmp);
        }
        this.recvQueue = null;
    }

    private void flushSendQueue() throws IOException {
        if (this.sendQueue == null) {
            return;
        }
        ByteBuffer tmp = this.sendQueue.newByteBuffer();
        while (this.sendQueue.hasRemaining()) {
            tmp.clear();
            this.sendQueue.get(tmp);
            tmp.flip();
            while (tmp.hasRemaining()) {
                try {
                    this.write(tmp);
                }
                catch (IOException e) {
                    tmp.compact();
                    this.sendQueue.unget(tmp);
                    throw e;
                }
            }
        }
        this.sendQueue = null;
    }

    @Override
    public final void init(@Nonnull ProtocolStack.Ptr ptr) throws IOException {
        if (this.ptr != null && this.ptr != ptr) {
            throw new IllegalStateException("Already initialized");
        }
        this.ptr = ptr;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void start() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Starting", this.ptr.stack().name());
        }
        try {
            this.flushRecvQueue();
            this.flushSendQueue();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] Started", this.ptr.stack().name());
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LogRecord record = new LogRecord(Level.FINEST, "[{0}] Could not complete start");
                record.setParameters(new Object[]{this.ptr.stack().name()});
                record.setThrown(e);
                LOGGER.log(record);
            }
            throw e;
        }
    }

    public IOHub getIoHub() {
        return this.ioHub;
    }

    protected ByteBuffer acquire() {
        return this.ioHub.acquire(8192);
    }

    protected void release(ByteBuffer buffer) {
        this.ioHub.release(buffer);
    }

    protected ByteBufferQueue newByteBufferQueue() {
        return new ByteBufferQueue(8192);
    }

    protected ProtocolStack<?> stack() {
        return this.ptr == null ? null : this.ptr.stack();
    }
}

