/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.accmod.restrictions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kohsuke.accmod.impl.ErrorListener;
import org.kohsuke.accmod.impl.Location;
import org.kohsuke.accmod.impl.RestrictedElement;
import org.kohsuke.accmod.restrictions.None;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ProtectedExternally
extends None {
    @Override
    public void invoked(Location loc, RestrictedElement target, ErrorListener errorListener) {
        if (target.isInTheInspectedModule()) {
            return;
        }
        try (InputStream is = loc.getDependencyClassLoader().getResourceAsStream(loc.getClassName().replace('.', '/') + ".class");){
            if (is == null) {
                errorListener.onError(null, loc, "could not find class");
                return;
            }
            ClassReader cr = new ClassReader(is);
            final AtomicBoolean ok = new AtomicBoolean();
            final String supe = target.toString().replaceFirst("[.].+$", "");
            cr.accept(new ClassVisitor(327680){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (supe.equals(superName) || interfaces != null && Arrays.asList(interfaces).contains(supe)) {
                        ok.set(true);
                    }
                }
            }, 4);
            if (ok.get()) {
                return;
            }
        }
        catch (IOException x) {
            errorListener.onError(x, loc, "cannot inspect caller");
            return;
        }
        errorListener.onError(null, loc, target + " must not be called except as if protected");
    }
}

