/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.jenkinsci.remoting.protocol.ProtocolLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.util.ThrowableUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ApplicationLayer<T>
implements ProtocolLayer,
ProtocolLayer.Recv {
    private static final Logger LOGGER = Logger.getLogger(ApplicationLayer.class.getName());
    private final Object closedLock = new Object();
    private ProtocolStack.Ptr ptr;
    @GuardedBy(value="closedLock")
    private boolean sendClosed;
    @GuardedBy(value="closedLock")
    private boolean recvClosed;

    public abstract T get();

    public abstract boolean isReadOpen();

    public abstract void onRead(@Nonnull ByteBuffer var1) throws IOException;

    public abstract void onReadClosed(IOException var1) throws IOException;

    @Override
    public final void init(@Nonnull ProtocolStack.Ptr ptr) throws IOException {
        if (this.ptr != null && this.ptr != ptr) {
            throw new IllegalStateException("Already initialized");
        }
        this.ptr = ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isWriteOpen() {
        if (this.ptr == null) {
            throw new IllegalStateException();
        }
        Object object = this.closedLock;
        synchronized (object) {
            if (this.sendClosed) {
                return false;
            }
        }
        if (this.ptr.isSendOpen()) {
            return true;
        }
        object = this.closedLock;
        synchronized (object) {
            this.sendClosed = true;
            return false;
        }
    }

    public final void write(@Nonnull ByteBuffer data) throws IOException {
        this.ptr.doSend(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doCloseWrite() throws IOException {
        Object object = this.closedLock;
        synchronized (object) {
            this.sendClosed = true;
        }
        if (this.ptr.isSendOpen()) {
            LOGGER.log(Level.FINE, "[{0}] Closing SEND", this.ptr.stack().name());
            this.ptr.doCloseSend();
        }
    }

    public final void doCloseRead() throws IOException {
        if (this.ptr.stack().isRecvOpen()) {
            LOGGER.log(Level.FINE, "[{0}] Closing RECV", this.ptr.stack().name());
            this.ptr.stack().doCloseRecv();
        }
    }

    @Nullable
    protected ProtocolStack<?> stack() {
        return this.ptr == null ? null : this.ptr.stack();
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    public final void onRecv(@Nonnull ByteBuffer data) throws IOException {
        this.onRead(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Restricted(value={NoExternalUse.class})
    public final void onRecvClosed(IOException cause) throws IOException {
        LOGGER.log(Level.FINE, "[{0}] RECV Closed", this.ptr.stack().name());
        Object object = this.closedLock;
        synchronized (object) {
            this.recvClosed = true;
        }
        IOException ioe = null;
        try {
            this.onReadClosed(cause);
            this.stack().onClosed(cause);
        }
        catch (IOException e) {
            ioe = e;
        }
        finally {
            try {
                this.doCloseWrite();
            }
            catch (IOException e) {
                if (ioe != null) {
                    throw ThrowableUtils.addSuppressed(ioe, e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Restricted(value={NoExternalUse.class})
    public final boolean isRecvOpen() {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.recvClosed) {
                return false;
            }
        }
        if (this.isReadOpen()) {
            return true;
        }
        object = this.closedLock;
        synchronized (object) {
            this.recvClosed = true;
            return false;
        }
    }
}

