/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.plugins.swarm.XmlUtils;
import hudson.remoting.Launcher;
import hudson.remoting.jnlp.Main;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.codec.digest.DigestUtils;
import shaded.org.apache.commons.lang.StringUtils;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.auth.AuthScope;
import shaded.org.apache.http.auth.UsernamePasswordCredentials;
import shaded.org.apache.http.client.methods.CloseableHttpResponse;
import shaded.org.apache.http.client.methods.HttpGet;
import shaded.org.apache.http.client.methods.HttpPost;
import shaded.org.apache.http.client.methods.HttpUriRequest;
import shaded.org.apache.http.client.protocol.HttpClientContext;
import shaded.org.apache.http.impl.auth.BasicScheme;
import shaded.org.apache.http.impl.client.BasicAuthCache;
import shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import shaded.org.apache.http.impl.client.CloseableHttpClient;
import shaded.org.apache.http.impl.client.HttpClients;
import shaded.org.apache.http.util.EntityUtils;

public class SwarmClient {
    private static final Logger logger = Logger.getLogger(SwarmClient.class.getPackage().getName());
    private final Options options;
    private final String hash;
    private String name;

    @SuppressFBWarnings(value={"DM_EXIT"})
    public SwarmClient(Options options) {
        this.options = options;
        Map<String, String> env = System.getenv();
        if (env.containsKey("MESOS_TASK_ID") && StringUtils.isNotEmpty(env.get("MESOS_TASK_ID"))) {
            this.hash = env.get("MESOS_TASK_ID");
            logger.info("Using MESOS_TASK_ID: " + this.hash);
        } else {
            this.hash = !options.disableClientsUniqueId ? SwarmClient.hash(options.remoteFsRoot) : "";
        }
        this.name = options.name;
        if (options.labelsFile != null) {
            logger.info("Loading labels from " + options.labelsFile + "...");
            try {
                String labels = new String(Files.readAllBytes(Paths.get(options.labelsFile, new String[0])), StandardCharsets.UTF_8);
                options.labels.addAll(Arrays.asList(labels.split(" ")));
                logger.info("Labels found in file: " + labels);
                logger.info("Effective label list: " + Arrays.toString(options.labels.toArray()).replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Problem reading labels from file " + options.labelsFile, e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getName() {
        return this.name;
    }

    public Candidate discoverFromBroadcast() throws IOException, RetryException {
        logger.config("discoverFromBroadcast() invoked");
        DatagramSocket socket = new DatagramSocket();
        socket.setBroadcast(true);
        this.sendBroadcast(socket);
        List<DatagramPacket> responses = this.collectBroadcastResponses(socket);
        return this.getCandidateFromDatagramResponses(responses);
    }

    private Candidate getCandidateFromDatagramResponses(List<DatagramPacket> responses) throws RetryException {
        logger.finer("getCandidateFromDatagramResponses() invoked");
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (DatagramPacket recv : responses) {
            String url;
            Document xml;
            String responseXml = new String(recv.getData(), 0, recv.getLength(), StandardCharsets.UTF_8);
            String address = this.printable(recv.getAddress());
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(recv.getData());){
                xml = XmlUtils.parse(inputStream);
            }
            catch (IOException | SAXException e) {
                logger.severe("Invalid response XML from " + address + ": " + responseXml);
                continue;
            }
            if (!StringUtils.isBlank(this.options.candidateTag)) {
                logger.finer(address + this.options.candidateTag);
                continue;
            }
            String swarm = SwarmClient.getChildElementString(xml.getDocumentElement(), "swarm");
            if (swarm == null) {
                logger.warning(address + " doesn't support swarm");
                continue;
            }
            String string = url = this.options.master == null ? SwarmClient.getChildElementString(xml.getDocumentElement(), "url") : this.options.master;
            if (url == null) {
                logger.warning("Jenkins master at '" + address + "' doesn't have a valid Jenkins URL configuration set. Please go to <jenkins url>/configure and set a valid URL.");
                continue;
            }
            candidates.add(new Candidate(url, swarm));
        }
        if (candidates.isEmpty()) {
            logger.severe("No nearby Jenkins supports swarming");
            throw new RetryException("No nearby Jenkins supports swarming");
        }
        logger.finer("Found " + candidates.size() + " eligible Jenkins.");
        return (Candidate)candidates.get(new Random().nextInt(candidates.size()));
    }

    protected void sendBroadcast(DatagramSocket socket) throws IOException {
        logger.fine("sendBroadcast() invoked");
        byte[] buffer = new byte[128];
        Arrays.fill(buffer, (byte)1);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        packet.setAddress(InetAddress.getByName(this.options.autoDiscoveryAddress));
        packet.setPort(Integer.getInteger("jenkins.udp", Integer.getInteger("hudson.udp", 33848)));
        socket.send(packet);
    }

    protected List<DatagramPacket> collectBroadcastResponses(DatagramSocket socket) throws IOException, RetryException {
        ArrayList<DatagramPacket> responses = new ArrayList<DatagramPacket>();
        logger.fine("collectBroadcastResponses() invoked");
        long limit = System.currentTimeMillis() + 5000L;
        try {
            while (true) {
                socket.setSoTimeout(Math.max(1, (int)(limit - System.currentTimeMillis())));
                DatagramPacket recv = new DatagramPacket(new byte[2048], 2048);
                socket.receive(recv);
                responses.add(recv);
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.FINEST, "SocketTimeoutException occurred, may be normal.", e);
            if (responses.isEmpty()) {
                String msg = "Failed to receive a reply to broadcast.";
                logger.log(Level.WARNING, msg, e);
                throw new RetryException(msg);
            }
            return responses;
        }
    }

    public Candidate discoverFromMasterUrl() throws IOException, RetryException {
        String swarmSecret;
        URL masterURL;
        logger.config("discoverFromMasterUrl() invoked");
        if (!this.options.master.endsWith("/")) {
            this.options.master = this.options.master + "/";
        }
        try {
            masterURL = new URL(this.options.master);
        }
        catch (MalformedURLException e) {
            String msg = MessageFormat.format("The master URL \"{0}\" is invalid", this.options.master);
            logger.log(Level.SEVERE, msg, e);
            throw new RuntimeException(msg, e);
        }
        logger.config("Connecting to " + masterURL + " to configure swarm client.");
        CloseableHttpClient client = this.createHttpClient(masterURL);
        HttpClientContext context = this.createHttpClientContext(masterURL);
        String url = masterURL.toExternalForm() + "plugin/swarm/slaveInfo";
        HttpGet get = new HttpGet(url);
        get.addHeader("Connection", "close");
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)get, context);){
            Document xml;
            if (response.getStatusLine().getStatusCode() != 200) {
                if (response.getStatusLine().getStatusCode() == 404) {
                    String msg = "Failed to fetch swarm information from Jenkins, plugin not installed?";
                    logger.log(Level.SEVERE, msg);
                    throw new RetryException(msg);
                }
                String msg = "Failed to fetch slave info from Jenkins, HTTP response code: " + response.getStatusLine().getStatusCode();
                logger.log(Level.SEVERE, msg);
                throw new RetryException(msg);
            }
            try {
                xml = XmlUtils.parse(response.getEntity().getContent());
            }
            catch (SAXException e) {
                String msg = "Invalid XML received from " + url;
                logger.log(Level.SEVERE, msg, e);
                throw new RetryException(msg);
            }
            swarmSecret = SwarmClient.getChildElementString(xml.getDocumentElement(), "swarmSecret");
        }
        return new Candidate(masterURL.toExternalForm(), swarmSecret);
    }

    protected void connect(Candidate target) throws InterruptedException {
        logger.fine("connect() invoked");
        Launcher launcher = new Launcher();
        launcher.noReconnect = true;
        List<Object> jnlpArgs = Collections.emptyList();
        try {
            launcher.slaveJnlpURL = new URL(target.url + "computer/" + this.name + "/slave-agent.jnlp");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Failed to establish JNLP connection to " + target.url, e);
            Thread.sleep(10000L);
        }
        if (this.options.username != null && this.options.password != null) {
            launcher.auth = this.options.username + ":" + this.options.password;
            launcher.slaveJnlpCredentials = this.options.username + ":" + this.options.password;
        }
        try {
            jnlpArgs = launcher.parseJnlpArguments();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Failed to establish JNLP connection to " + target.url, e);
            Thread.sleep(10000L);
        }
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(jnlpArgs.get(0));
        args.add(jnlpArgs.get(1));
        args.add("-url");
        args.add(target.url);
        if (this.options.tunnel != null) {
            args.add("-tunnel");
            args.add(this.options.tunnel);
            logger.fine("Using tunnel through " + this.options.tunnel);
        }
        if (this.options.username != null && this.options.password != null) {
            args.add("-credentials");
            args.add(this.options.username + ":" + this.options.password);
        }
        args.add("-headless");
        args.add("-noreconnect");
        try {
            Main.main(args.toArray(new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Failed to establish JNLP connection to " + target.url, e);
            Thread.sleep(10000L);
        }
    }

    protected CloseableHttpClient createHttpClient(URL urlForAuth) {
        logger.fine("createHttpClient() invoked");
        if (this.options.disableSslVerification || !this.options.sslFingerprints.isEmpty()) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                String trusted = this.options.disableSslVerification ? "" : this.options.sslFingerprints;
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager(trusted)}, new SecureRandom());
                SSLContext.setDefault(ctx);
            }
            catch (KeyManagementException e) {
                logger.log(Level.SEVERE, "KeyManagementException occurred", e);
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.SEVERE, "NoSuchAlgorithmException occurred", e);
                throw new RuntimeException(e);
            }
        }
        return HttpClients.createSystem();
    }

    protected HttpClientContext createHttpClientContext(URL urlForAuth) {
        logger.fine("createHttpClientContext() invoked");
        HttpClientContext context = HttpClientContext.create();
        if (this.options.username != null && this.options.password != null) {
            logger.fine("Setting HttpClient credentials based on options passed");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(urlForAuth.getHost(), urlForAuth.getPort()), new UsernamePasswordCredentials(this.options.username, this.options.password));
            context.setCredentialsProvider(credsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(urlForAuth.getHost(), urlForAuth.getPort(), urlForAuth.getProtocol()), new BasicScheme());
            context.setAuthCache(authCache);
        }
        return context;
    }

    protected static synchronized Crumb getCsrfCrumb(CloseableHttpClient client, HttpClientContext context, Candidate target) throws IOException {
        String[] crumbResponse;
        logger.finer("getCsrfCrumb() invoked");
        HttpGet httpGet = new HttpGet(target.url + "crumbIssuer/api/xml?xpath=" + URLEncoder.encode("concat(//crumbRequestField,\":\",//crumb)", "UTF-8"));
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet, context);){
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.log(Level.SEVERE, "Could not obtain CSRF crumb. Response code: " + response.getStatusLine().getStatusCode());
                Crumb crumb = null;
                return crumb;
            }
            String crumbResponseString = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            crumbResponse = crumbResponseString.split(":");
            if (crumbResponse.length != 2) {
                logger.log(Level.SEVERE, "Unexpected CSRF crumb response: " + crumbResponseString);
                Crumb crumb = null;
                return crumb;
            }
        }
        return new Crumb(crumbResponse[0], crumbResponse[1]);
    }

    protected void createSwarmSlave(Candidate target) throws IOException, RetryException {
        String sMyLabels;
        logger.fine("createSwarmSlave() invoked");
        URL urlForAuth = new URL(target.url);
        CloseableHttpClient client = this.createHttpClient(urlForAuth);
        HttpClientContext context = this.createHttpClientContext(urlForAuth);
        String labelStr = StringUtils.join(this.options.labels, ' ');
        StringBuilder toolLocationBuilder = new StringBuilder();
        if (this.options.toolLocations != null) {
            for (Map.Entry<String, String> toolLocation : this.options.toolLocations.entrySet()) {
                toolLocationBuilder.append(SwarmClient.param("toolLocation", toolLocation.getKey() + ":" + toolLocation.getValue()));
            }
        }
        if ((sMyLabels = labelStr).length() > 1000) {
            sMyLabels = "";
        }
        Properties props = new Properties();
        HttpPost post = new HttpPost(target.url + "plugin/swarm/createSlave?name=" + this.options.name + "&executors=" + this.options.executors + SwarmClient.param("remoteFsRoot", this.options.remoteFsRoot.getAbsolutePath()) + SwarmClient.param("description", this.options.description) + SwarmClient.param("labels", sMyLabels) + toolLocationBuilder.toString() + "&secret=" + target.secret + SwarmClient.param("mode", this.options.mode.toUpperCase(Locale.ENGLISH)) + SwarmClient.param("hash", this.hash) + SwarmClient.param("deleteExistingClients", Boolean.toString(this.options.deleteExistingClients)));
        post.addHeader("Connection", "close");
        Crumb csrfCrumb = SwarmClient.getCsrfCrumb(client, context, target);
        if (csrfCrumb != null) {
            post.addHeader(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post, context);){
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = String.format("Failed to create a slave on Jenkins, response code: %s%n%s", response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8));
                logger.log(Level.SEVERE, msg);
                throw new RetryException(msg);
            }
            String[] stringArray = null;
            try (InputStream stream = response.getEntity().getContent();){
                props.load(stream);
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
        }
        String name = props.getProperty("name");
        if (name == null) {
            this.name = this.options.name;
            return;
        }
        if ((name = name.trim()).isEmpty()) {
            this.name = this.options.name;
            return;
        }
        this.name = name;
        if (sMyLabels.length() == 0 && labelStr.length() > 0) {
            String[] lLabels = labelStr.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String s : lLabels) {
                sb.append(s);
                sb.append(" ");
                if (sb.length() <= 1000) continue;
                SwarmClient.postLabelAppend(name, sb.toString(), client, context, target);
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                SwarmClient.postLabelAppend(name, sb.toString(), client, context, target);
            }
        }
    }

    protected static synchronized void postLabelRemove(String name, String labels, CloseableHttpClient client, HttpClientContext context, Candidate target) throws IOException, RetryException {
        HttpPost post = new HttpPost(target.url + "plugin/swarm/removeSlaveLabels?name=" + name + "&secret=" + target.secret + SwarmClient.param("labels", labels));
        post.addHeader("Connection", "close");
        Crumb csrfCrumb = SwarmClient.getCsrfCrumb(client, context, target);
        if (csrfCrumb != null) {
            post.addHeader(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post, context);){
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = String.format("Failed to remove slave labels. %s - %s", response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8));
                logger.log(Level.SEVERE, msg);
                throw new RetryException(msg);
            }
        }
    }

    protected static synchronized void postLabelAppend(String name, String labels, CloseableHttpClient client, HttpClientContext context, Candidate target) throws IOException, RetryException {
        HttpPost post = new HttpPost(target.url + "plugin/swarm/addSlaveLabels?name=" + name + "&secret=" + target.secret + SwarmClient.param("labels", labels));
        post.addHeader("Connection", "close");
        Crumb csrfCrumb = SwarmClient.getCsrfCrumb(client, context, target);
        if (csrfCrumb != null) {
            post.addHeader(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post, context);){
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = String.format("Failed to update slave labels. Slave is probably messed up. %s - %s", response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8));
                logger.log(Level.SEVERE, msg);
                throw new RetryException(msg);
            }
        }
    }

    private static synchronized String encode(String value) throws UnsupportedEncodingException {
        logger.finer("encode() invoked");
        return URLEncoder.encode(value, "UTF-8");
    }

    protected static synchronized String param(String name, String value) throws UnsupportedEncodingException {
        logger.finer("param() invoked");
        if (value == null) {
            return "";
        }
        return "&" + name + "=" + SwarmClient.encode(value);
    }

    protected void verifyThatUrlIsHudson(Candidate target) throws RetryException {
        logger.fine("verifyThatUrlIsHudson() invoked");
        try {
            logger.fine("Connecting to " + target.url);
            HttpURLConnection con = (HttpURLConnection)new URL(target.url).openConnection();
            con.connect();
            if (con.getResponseCode() == 403) {
                String msg = "This jenkins server requires Authentication!";
                logger.log(Level.SEVERE, msg);
                throw new RetryException(msg);
            }
            String v = con.getHeaderField("X-Hudson");
            if (v == null) {
                String msg = "This URL doesn't look like Jenkins.";
                logger.log(Level.SEVERE, msg);
                throw new RetryException(msg);
            }
        }
        catch (IOException e) {
            String msg = "Failed to connect to " + target.url;
            logger.log(Level.SEVERE, msg, e);
            throw new RetryException(msg, e);
        }
    }

    protected static String getChildElementString(Element parent, String tagName) {
        logger.finer("getChildElementString() invoked");
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getTagName().equals(tagName)) continue;
            StringBuilder buf = new StringBuilder();
            for (n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Text)) continue;
                buf.append(n.getTextContent());
            }
            return buf.toString();
        }
        return null;
    }

    private String printable(InetAddress ia) {
        logger.finer("printable() invoked");
        if (this.options.showHostName) {
            return ia.getHostName();
        }
        return ia.toString();
    }

    public static String hash(File remoteFsRoot) {
        logger.config("hash() invoked");
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(remoteFsRoot.getCanonicalPath()).append('\n');
        }
        catch (IOException e) {
            logger.log(Level.FINER, "hash() IOException - may be normal?", e);
            buf.append(remoteFsRoot.getAbsolutePath()).append('\n');
        }
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress ia : Collections.list(ni.getInetAddresses())) {
                    if (ia instanceof Inet4Address) {
                        buf.append(ia.getHostAddress()).append('\n');
                        continue;
                    }
                    if (!(ia instanceof Inet6Address)) continue;
                    buf.append(ia.getHostAddress()).append('\n');
                }
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (hardwareAddress == null) continue;
                buf.append(Arrays.toString(hardwareAddress));
            }
        }
        catch (SocketException e) {
            logger.log(Level.FINEST, "hash() SocketException - 'oh well we tried'", e);
        }
        return DigestUtils.md5Hex(buf.toString()).substring(0, 8);
    }

    public void exitWithStatus(int status) {
        System.exit(status);
    }

    public void sleepSeconds(int waitTime) throws InterruptedException {
        Thread.sleep(waitTime * 1000);
    }

    protected static class Crumb {
        protected final String crumb;
        protected final String crumbRequestField;

        Crumb(String crumbRequestField, String crumb) {
            this.crumbRequestField = crumbRequestField;
            this.crumb = crumb;
        }
    }

    protected static class DefaultTrustManager
    implements X509TrustManager {
        List<String> allowedFingerprints = new ArrayList<String>();
        List<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>();

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.allowedFingerprints.isEmpty()) {
                return;
            }
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (X509Certificate cert : x509Certificates) {
                String fingerprint = DigestUtils.sha256Hex(cert.getEncoded());
                logger.fine("Check fingerprint: " + fingerprint);
                if (!this.allowedFingerprints.contains(fingerprint)) continue;
                list.add(cert);
                logger.fine("Found allowed certificate: " + cert);
            }
            if (list.isEmpty()) {
                throw new CertificateException("Fingerprint mismatch");
            }
            this.acceptedIssuers.addAll(list);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.acceptedIssuers.toArray(new X509Certificate[0]);
        }

        public DefaultTrustManager(String fingerprints) {
            if (fingerprints.isEmpty()) {
                return;
            }
            for (String fingerprint : fingerprints.split("\\s+")) {
                String unified = StringUtils.remove(fingerprint.toLowerCase(), ':');
                logger.fine("Add allowed fingerprint: " + unified);
                this.allowedFingerprints.add(unified);
            }
        }
    }
}

