/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.plugins.swarm.SoftLabelUpdateException;
import hudson.plugins.swarm.SwarmClient;
import hudson.plugins.swarm.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.lang.StringUtils;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.auth.AuthScope;
import shaded.org.apache.http.auth.UsernamePasswordCredentials;
import shaded.org.apache.http.client.methods.CloseableHttpResponse;
import shaded.org.apache.http.client.methods.HttpGet;
import shaded.org.apache.http.client.methods.HttpUriRequest;
import shaded.org.apache.http.client.protocol.HttpClientContext;
import shaded.org.apache.http.impl.auth.BasicScheme;
import shaded.org.apache.http.impl.client.BasicAuthCache;
import shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import shaded.org.apache.http.impl.client.CloseableHttpClient;
import shaded.org.apache.http.impl.client.HttpClients;

public class LabelFileWatcher
implements Runnable {
    private final Logger logger = Logger.getLogger(LabelFileWatcher.class.getPackage().getName());
    private String sFileName;
    private boolean bRunning = false;
    private Options opts;
    private final String name;
    private String sLabels;
    private String[] sArgs;
    private Candidate targ;

    public LabelFileWatcher(Candidate target, Options options, String name, String ... args) throws IOException {
        this.logger.config("LabelFileWatcher() constructed with: " + options.labelsFile + ", and " + StringUtils.join(args));
        this.targ = target;
        this.opts = options;
        this.name = name;
        this.sFileName = options.labelsFile;
        this.sLabels = new String(Files.readAllBytes(Paths.get(this.sFileName, new String[0])), StandardCharsets.UTF_8);
        this.sArgs = args;
        this.logger.config("Labels loaded: " + this.sLabels);
    }

    private CloseableHttpClient createHttpClient(URL urlForAuth) {
        this.logger.fine("createHttpClient() invoked");
        if (this.opts.disableSslVerification || !this.opts.sslFingerprints.isEmpty()) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                String trusted = this.opts.disableSslVerification ? "" : this.opts.sslFingerprints;
                ctx.init(new KeyManager[0], new TrustManager[]{new SwarmClient.DefaultTrustManager(trusted)}, new SecureRandom());
                SSLContext.setDefault(ctx);
            }
            catch (KeyManagementException e) {
                this.logger.log(Level.SEVERE, "KeyManagementException occurred", e);
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.log(Level.SEVERE, "NoSuchAlgorithmException occurred", e);
                throw new RuntimeException(e);
            }
        }
        return HttpClients.createSystem();
    }

    protected HttpClientContext createHttpClientContext(URL urlForAuth) {
        this.logger.fine("createHttpClientContext() invoked");
        HttpClientContext context = HttpClientContext.create();
        if (this.opts.username != null && this.opts.password != null) {
            this.logger.fine("Setting HttpClient credentials based on options passed");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(urlForAuth.getHost(), urlForAuth.getPort()), new UsernamePasswordCredentials(this.opts.username, this.opts.password));
            context.setCredentialsProvider(credsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(urlForAuth.getHost(), urlForAuth.getPort(), urlForAuth.getProtocol()), new BasicScheme());
            context.setAuthCache(authCache);
        }
        return context;
    }

    private void softLabelUpdate(String sNewLabels) throws SoftLabelUpdateException, MalformedURLException {
        String msg;
        Document xml;
        this.logger.log(Level.CONFIG, "NOTICE: " + this.sFileName + " has changed.  Attempting soft label update (no node restart)");
        URL urlForAuth = new URL(this.targ.getURL());
        CloseableHttpClient h = this.createHttpClient(urlForAuth);
        HttpClientContext context = this.createHttpClientContext(urlForAuth);
        this.logger.log(Level.CONFIG, "Getting current labels from master");
        HttpGet get = new HttpGet(this.targ.getURL() + "/plugin/swarm/getSlaveLabels?name=" + this.name + "&secret=" + this.targ.getSecret());
        try (CloseableHttpResponse response = h.execute((HttpUriRequest)get, context);){
            if (response.getStatusLine().getStatusCode() != 200) {
                this.logger.log(Level.CONFIG, "Failed to retrieve labels from master -- Response code: " + response.getStatusLine().getStatusCode());
                throw new SoftLabelUpdateException("Unable to acquire labels from master to begin removal process.");
            }
            try {
                xml = XmlUtils.parse(response.getEntity().getContent());
            }
            catch (SAXException e) {
                String msg2 = "Invalid XML received from " + this.targ.getURL();
                this.logger.log(Level.SEVERE, msg2, e);
                throw new SoftLabelUpdateException(msg2);
            }
        }
        catch (IOException e) {
            String msg3 = "IOException when reading from " + this.targ.getURL();
            this.logger.log(Level.SEVERE, msg3, e);
            throw new SoftLabelUpdateException(msg3);
        }
        String labelStr = SwarmClient.getChildElementString(xml.getDocumentElement(), "labels");
        labelStr = labelStr.replace("swarm", "");
        this.logger.log(Level.CONFIG, "Labels to be removed: " + labelStr);
        List<String> lLabels = Arrays.asList(labelStr.split("\\s+"));
        StringBuilder sb = new StringBuilder();
        for (String s : lLabels) {
            sb.append(s);
            sb.append(" ");
            if (sb.length() <= 1000) continue;
            try {
                SwarmClient.postLabelRemove(this.name, sb.toString(), h, context, this.targ);
            }
            catch (RetryException | IOException e) {
                String msg4 = "Exception when removing label from " + this.targ.getURL();
                this.logger.log(Level.SEVERE, msg4, e);
                throw new SoftLabelUpdateException(msg4);
            }
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            try {
                SwarmClient.postLabelRemove(this.name, sb.toString(), h, context, this.targ);
            }
            catch (RetryException | IOException e) {
                msg = "Exception when removing label from " + this.targ.getURL();
                this.logger.log(Level.SEVERE, msg, e);
                throw new SoftLabelUpdateException(msg);
            }
        }
        this.logger.log(Level.CONFIG, "Labels to be added: " + sNewLabels);
        lLabels = Arrays.asList(sNewLabels.split("\\s+"));
        sb = new StringBuilder();
        for (String s : lLabels) {
            sb.append(s);
            sb.append(" ");
            if (sb.length() <= 1000) continue;
            try {
                SwarmClient.postLabelAppend(this.name, sb.toString(), h, context, this.targ);
            }
            catch (RetryException | IOException e) {
                String msg5 = "Exception when appending label to " + this.targ.getURL();
                this.logger.log(Level.SEVERE, msg5, e);
                throw new SoftLabelUpdateException(msg5);
            }
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            try {
                SwarmClient.postLabelAppend(this.name, sb.toString(), h, context, this.targ);
            }
            catch (RetryException | IOException e) {
                msg = "Exception when appending label to " + this.targ.getURL();
                this.logger.log(Level.SEVERE, msg, e);
                throw new SoftLabelUpdateException(msg);
            }
        }
    }

    private void hardLabelUpdate() throws IOException {
        this.logger.config("NOTICE: " + this.sFileName + " has changed.  Hard node restart attempt initiated.");
        this.bRunning = false;
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        try {
            File currentJar = new File(LabelFileWatcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!currentJar.getName().endsWith(".jar")) {
                throw new URISyntaxException(currentJar.getName(), "Doesn't end in .jar");
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            if (System.getProperty("java.util.logging.config.file") == null) {
                this.logger.warning("NOTE:  You do not have a -Djava.util.logging.config.file specified, but your labels file has changed.  You will lose logging for the new client instance. Although the client will continue to work, you will have no logging.");
            } else {
                command.add("-Djava.util.logging.config.file=" + System.getProperty("java.util.logging.config.file"));
            }
            command.add("-jar");
            command.add(currentJar.getPath());
            Collections.addAll(command, this.sArgs);
            String sCommandString = Arrays.toString(command.toArray());
            sCommandString = sCommandString.replaceAll("\n", "").replaceAll("\r", "").replaceAll(",", "");
            this.logger.config("Invoking: " + sCommandString);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            this.logger.config("New node instance started, ignore subsequent warning.");
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "ERROR: LabelFileWatcher unable to determine current running jar. Node failure. URISyntaxException.", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void run() {
        this.bRunning = true;
        this.logger.config("LabelFileWatcher running, monitoring file: " + this.sFileName);
        while (this.bRunning) {
            try {
                this.logger.log(Level.FINE, "LabelFileWatcher sleeping 10 secs");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "LabelFileWatcher InterruptedException occurred.", e);
            }
            try {
                String sTempLabels = new String(Files.readAllBytes(Paths.get(this.sFileName, new String[0])), StandardCharsets.UTF_8);
                if (sTempLabels.equalsIgnoreCase(this.sLabels)) {
                    this.logger.log(Level.FINEST, "Nothing to do. " + this.sFileName + " has not changed.");
                    continue;
                }
                try {
                    this.softLabelUpdate(sTempLabels);
                    this.sLabels = new String(Files.readAllBytes(Paths.get(this.sFileName, new String[0])), StandardCharsets.UTF_8);
                }
                catch (SoftLabelUpdateException e) {
                    this.logger.log(Level.WARNING, "WARNING: Normal process, soft label update failed. " + e.getLocalizedMessage() + ", forcing swarm client reboot.  This can be disruptive to Jenkins jobs.  Check your swarm client log files to see why this is happening.");
                    this.hardLabelUpdate();
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "WARNING: unable to read " + this.sFileName + ", node may not be reporting proper labels to master.", e);
            }
        }
        this.logger.warning("LabelFileWatcher no longer running. Shutting down this instance of Swarm Client.");
        System.exit(0);
    }
}

