/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.LabelFileWatcher;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.plugins.swarm.SwarmClient;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.OptionHandler;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getPackage().getName());
    private final Options options;

    public static void main(String ... args) throws InterruptedException, IOException {
        Options options = new Options();
        Client client = new Client(options);
        CmdLineParser p = new CmdLineParser(options);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            logger.log(Level.SEVERE, "CmdLineException occurred during parseArgument", e);
            p.printUsage(System.out);
            System.exit(1);
        }
        Client.logArguments(p);
        if (options.help) {
            p.printUsage(System.out);
            System.exit(0);
        }
        if (options.pidFile != null) {
            String pidName = ManagementFactory.getRuntimeMXBean().getName();
            String[] pidNameParts = pidName.split("@");
            String pid = pidNameParts[0];
            File pidFile = new File(options.pidFile);
            pidFile.deleteOnExit();
            try {
                Files.write(pidFile.toPath(), pid.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException exception) {
                logger.severe("Failed writing PID file: " + options.pidFile);
                System.exit(1);
            }
        }
        if (options.passwordEnvVariable != null) {
            options.password = System.getenv(options.passwordEnvVariable);
        }
        if (options.password == null && options.passwordFile != null) {
            options.password = new String(Files.readAllBytes(Paths.get(options.passwordFile, new String[0])), StandardCharsets.UTF_8).trim();
        }
        if (options.name == null) {
            try {
                client.options.name = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (IOException e) {
                logger.severe("Failed to lookup the canonical hostname of this slave, please check system settings.");
                logger.severe("If not possible to resolve please specify a node name using the '-name' option");
                System.exit(1);
            }
        }
        SwarmClient swarmClient = new SwarmClient(options);
        client.run(swarmClient, args);
    }

    public Client(Options options) {
        this.options = options;
    }

    public void run(SwarmClient swarmClient, String ... args) throws InterruptedException {
        logger.info("Discovering Jenkins master");
        int retry = 0;
        while (true) {
            block12: {
                try {
                    Candidate target;
                    if (this.options.master == null) {
                        logger.info("No Jenkins master supplied on command line, performing auto-discovery");
                        target = swarmClient.discoverFromBroadcast();
                    } else {
                        target = swarmClient.discoverFromMasterUrl();
                    }
                    if (this.options.password == null && this.options.username == null) {
                        swarmClient.verifyThatUrlIsHudson(target);
                    }
                    logger.info("Attempting to connect to " + target.url + " " + target.secret + " with ID " + swarmClient.getHash());
                    swarmClient.createSwarmSlave(target);
                    if (this.options.labelsFile != null) {
                        logger.info("Setting up LabelFileWatcher");
                        LabelFileWatcher l = new LabelFileWatcher(target, this.options, swarmClient.getName(), args);
                        Thread labelFileWatcherThread = new Thread((Runnable)l, "LabelFileWatcher");
                        labelFileWatcherThread.setDaemon(true);
                        labelFileWatcherThread.start();
                    }
                    swarmClient.connect(target);
                    if (this.options.noRetryAfterConnected) {
                        logger.warning("Connection closed, exiting...");
                        swarmClient.exitWithStatus(0);
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "IOException occurred", e);
                    e.printStackTrace();
                }
                catch (RetryException e) {
                    logger.log(Level.SEVERE, "RetryException occurred", e);
                    if (e.getCause() == null) break block12;
                    e.getCause().printStackTrace();
                }
            }
            int waitTime = this.options.retryBackOffStrategy.waitForRetry(retry++, this.options.retryInterval, this.options.maxRetryInterval);
            if (this.options.retry >= 0) {
                if (retry >= this.options.retry) {
                    logger.severe("Retry limit reached, exiting...");
                    swarmClient.exitWithStatus(1);
                } else {
                    logger.warning("Remaining retries: " + (this.options.retry - retry));
                }
            }
            logger.info("Retrying in " + waitTime + " seconds");
            swarmClient.sleepSeconds(waitTime);
        }
    }

    private static void logArguments(CmdLineParser parser) {
        Options defaultOptions = new Options();
        CmdLineParser defaultParser = new CmdLineParser(defaultOptions);
        StringBuilder sb = new StringBuilder("Client invoked with: ");
        for (OptionHandler argument : parser.getArguments()) {
            Client.logValue(sb, argument, null);
        }
        for (OptionHandler option : parser.getOptions()) {
            Client.logValue(sb, option, defaultParser);
        }
        logger.info(sb.toString());
    }

    private static void logValue(StringBuilder sb, OptionHandler handler, CmdLineParser defaultParser) {
        String key = Client.getKey(handler);
        Object value = Client.getValue(handler);
        if (key.equals("-help")) {
            return;
        }
        if (defaultParser != null && Client.isDefaultOption(key, value, defaultParser)) {
            return;
        }
        sb.append(key);
        sb.append(' ');
        if (key.equals("-username") || key.equals("-password")) {
            sb.append("*****");
        } else {
            sb.append(value);
        }
        sb.append(' ');
    }

    private static String getKey(OptionHandler optionHandler) {
        if (optionHandler.option instanceof NamedOptionDef) {
            NamedOptionDef namedOptionDef = (NamedOptionDef)optionHandler.option;
            return namedOptionDef.name();
        }
        return optionHandler.option.toString();
    }

    private static Object getValue(OptionHandler optionHandler) {
        FieldSetter setter = optionHandler.setter.asFieldSetter();
        return setter == null ? null : setter.getValue();
    }

    private static boolean isDefaultOption(String key, Object value, CmdLineParser defaultParser) {
        for (OptionHandler defaultOption : defaultParser.getOptions()) {
            String defaultKey = Client.getKey(defaultOption);
            if (!defaultKey.equals(key)) continue;
            Object defaultValue = Client.getValue(defaultOption);
            if (defaultValue == null && value == null) {
                return true;
            }
            return defaultValue != null && defaultValue.equals(value);
        }
        return false;
    }
}

