/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Request;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class Response<RSP, EXC extends Throwable>
extends Command {
    private final int id;
    private int lastIoId;
    final RSP returnValue;
    final EXC exception;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only supposed to be defined on one side.")
    private transient long totalTime;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Bound after deserialization, in execute.")
    private transient Request<?, ?> request;
    private static final long serialVersionUID = 1L;

    Response(Request request, int id, int lastIoId, RSP returnValue) {
        this.request = request;
        this.id = id;
        this.lastIoId = lastIoId;
        this.returnValue = returnValue;
        this.exception = null;
    }

    Response(Request request, int id, int lastIoId, EXC exception) {
        this.request = request;
        this.id = id;
        this.lastIoId = lastIoId;
        this.returnValue = null;
        this.exception = exception;
    }

    @Override
    void execute(Channel channel) {
        Request<?, ?> req = channel.pendingCalls.get(this.id);
        if (req == null) {
            return;
        }
        req.responseIoId = this.lastIoId;
        req.onCompleted(this);
        channel.pendingCalls.remove(this.id);
        this.request = req;
        long startTime = req.startTime;
        if (startTime != 0L) {
            long time;
            this.totalTime = time = System.nanoTime() - startTime;
            channel.notifyResponse(req, this, time);
        }
    }

    @Override
    public String toString() {
        return "Response" + (this.request != null ? ":" + this.request : "") + "(" + (this.returnValue != null ? this.returnValue.getClass().getName() : (this.exception != null ? this.exception.getClass().getName() : null)) + ")";
    }

    @CheckForNull
    public Request<?, ?> getRequest() {
        return this.request;
    }

    @Nullable
    public RSP getReturnValue() {
        return this.returnValue;
    }

    @Nullable
    public EXC getException() {
        return this.exception;
    }

    public long getTotalTime() {
        return this.totalTime;
    }
}

