/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class KeyUtils {
    private KeyUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean equals(Key key1, Key key2) {
        if (key1 == key2) {
            return true;
        }
        if (key1 == null || key2 == null) {
            return false;
        }
        if (key1.equals(key2)) {
            return true;
        }
        if (!KeyUtils.equals(key1.getAlgorithm(), key1.getAlgorithm())) {
            return false;
        }
        if (!KeyUtils.equals(key1.getFormat(), key1.getFormat())) {
            return false;
        }
        byte[] encoded1 = key1.getEncoded();
        byte[] encoded2 = key2.getEncoded();
        if (encoded1 == null || encoded2 == null) {
            return false;
        }
        return Arrays.equals(key1.getEncoded(), key2.getEncoded());
    }

    private static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    @Nonnull
    public static String fingerprint(@CheckForNull Key key) {
        if (key == null) {
            return "null";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.reset();
            byte[] bytes = digest.digest(key.getEncoded());
            StringBuilder result = new StringBuilder(Math.max(0, bytes.length * 3 - 1));
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    result.append(':');
                }
                result.append(Character.forDigit(bytes[i] >> 4 & 0xF, 16));
                result.append(Character.forDigit(bytes[i] & 0xF, 16));
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JLS mandates MD5 support");
        }
    }
}

