/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public final class ConnectionHeaders {
    private ConnectionHeaders() {
        throw new IllegalAccessError("Utility class");
    }

    @Nonnull
    public static String toString(@Nonnull Map<String, String> data) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        boolean first = true;
        for (Map.Entry<String, String> e : data.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append('\"');
            ConnectionHeaders.appendEscaped(b, e.getKey());
            b.append("\":");
            if (e.getValue() == null) {
                b.append("null");
                continue;
            }
            b.append('\"');
            ConnectionHeaders.appendEscaped(b, e.getValue());
            b.append('\"');
        }
        b.append('}');
        return b.toString();
    }

    @Nonnull
    public static Map<String, String> fromString(@Nonnull String data) throws ParseException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        int state = 0;
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        int n = data.length();
        block13: for (int i = 0; i < n; ++i) {
            char c = data.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    if (c != '{') {
                        throw new ParseException("Expecting '{' but got '" + c + "'");
                    }
                    state = 1;
                    continue block13;
                }
                case 1: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    if (c == '}') {
                        state = 9;
                        continue block13;
                    }
                    if (c != '\"') {
                        throw new ParseException("Expecting '\"' but got '" + c + "'");
                    }
                    state = 2;
                    continue block13;
                }
                case 2: {
                    if (c == '\\') {
                        state = 3;
                        continue block13;
                    }
                    if (c == '\"') {
                        state = 4;
                        continue block13;
                    }
                    key.append(c);
                    continue block13;
                }
                case 3: {
                    i = ConnectionHeaders.decodeEscape(key, c, data, i, n);
                    state = 2;
                    continue block13;
                }
                case 4: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    if (c != ':') {
                        throw new ParseException("Expecting ':' but got '" + c + "'");
                    }
                    state = 5;
                    continue block13;
                }
                case 5: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    if (c == 'n' && i + 3 < n && data.charAt(i + 1) == 'u' && data.charAt(i + 2) == 'l' && data.charAt(i + 3) == 'l') {
                        i += 3;
                        result.put(key.toString(), null);
                        key.setLength(0);
                        state = 8;
                        continue block13;
                    }
                    if (c != '\"') {
                        throw new ParseException("Expecting '\"' or 'null' but got '" + c + "'");
                    }
                    state = 6;
                    continue block13;
                }
                case 6: {
                    if (c == '\\') {
                        state = 7;
                        continue block13;
                    }
                    if (c == '\"') {
                        result.put(key.toString(), val.toString());
                        key.setLength(0);
                        val.setLength(0);
                        state = 8;
                        continue block13;
                    }
                    val.append(c);
                    continue block13;
                }
                case 7: {
                    i = ConnectionHeaders.decodeEscape(val, c, data, i, n);
                    state = 6;
                    continue block13;
                }
                case 8: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    if (c == '}') {
                        state = 9;
                        continue block13;
                    }
                    if (c == ',') {
                        state = 10;
                        continue block13;
                    }
                    throw new ParseException("Expecting '}' or ',' but got '" + c + "'");
                }
                case 9: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    throw new ParseException("Non-whitespace after '}'");
                }
                case 10: {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\b') continue block13;
                    if (c != '\"') {
                        throw new ParseException("Expecting '\"' but got '" + c + "'");
                    }
                    state = 2;
                    continue block13;
                }
                default: {
                    throw new ParseException("Unexpected parser state machine state: " + state);
                }
            }
        }
        return result;
    }

    public static void appendEscaped(StringBuilder b, String str) {
        int n = str.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    continue block8;
                }
                case '\t': {
                    b.append("\\t");
                    continue block8;
                }
                case '\f': {
                    b.append("\\f");
                    continue block8;
                }
                case '\n': {
                    b.append("\\n");
                    continue block8;
                }
                case '\r': {
                    b.append("\\r");
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    b.append('\\').append(c);
                    continue block8;
                }
                default: {
                    if (c <= '\u001f') {
                        b.append(ConnectionHeaders.encodeEscape(c));
                        continue block8;
                    }
                    b.append(c);
                }
            }
        }
    }

    private static int decodeEscape(StringBuilder val, char c, String str, int i, int n) throws ParseException {
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                val.append(c);
                return i;
            }
            case 'b': {
                val.append('\b');
                return i;
            }
            case 'f': {
                val.append('\f');
                return i;
            }
            case 'n': {
                val.append('\n');
                return i;
            }
            case 'r': {
                val.append('\r');
                return i;
            }
            case 't': {
                val.append('\t');
                return i;
            }
            case 'u': {
                if (i + 4 < n) {
                    int n1 = Character.digit(str.charAt(i + 1), 16);
                    int n2 = Character.digit(str.charAt(i + 2), 16);
                    int n3 = Character.digit(str.charAt(i + 3), 16);
                    int n4 = Character.digit(str.charAt(i + 4), 16);
                    if (n1 == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
                        throw new ParseException("Malformed unicode escape");
                    }
                    val.append((char)(n1 << 12 | n2 << 8 | n3 << 4 | n4));
                    return i + 4;
                }
                throw new ParseException("Malformed unicode escape");
            }
        }
        throw new ParseException("Unknown character escape '" + c + "'");
    }

    public static String encodeEscape(int c) {
        return "\\u" + Character.forDigit(c >> 12 & 0xF, 16) + Character.forDigit(c >> 8 & 0xF, 16) + Character.forDigit(c >> 4 & 0xF, 16) + Character.forDigit(c & 0xF, 16);
    }

    public static class ParseException
    extends Exception {
        public ParseException(String message) {
            super(message);
        }
    }
}

