/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.AsyncFutureImpl;
import hudson.remoting.AtmostOneThreadExecutor;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Checksum;
import hudson.remoting.DaemonThreadFactory;
import hudson.remoting.Future;
import hudson.remoting.JarCache;
import hudson.remoting.JarLoader;
import hudson.remoting.NamingThreadFactory;
import hudson.remoting.RequestAbortedException;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.util.ExecutorServiceUtils;

public abstract class JarCacheSupport
extends JarCache {
    private final ConcurrentMap<Checksum, Future<URL>> inprogress = new ConcurrentHashMap<Checksum, Future<URL>>();
    private final ExecutorService downloader = new AtmostOneThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), JarCacheSupport.class.getSimpleName()));
    private static final Logger LOGGER = Logger.getLogger(JarCacheSupport.class.getName());

    protected abstract URL lookInCache(Channel var1, long var2, long var4) throws IOException, InterruptedException;

    protected abstract URL retrieve(Channel var1, long var2, long var4) throws IOException, InterruptedException;

    @Override
    public Future<URL> resolve(Channel channel, long sum1, long sum2) throws IOException, InterruptedException {
        URL jar = this.lookInCache(channel, sum1, sum2);
        if (jar != null) {
            return new AsyncFutureImpl<URL>(jar);
        }
        Checksum key;
        Future cur;
        while ((cur = (Future)this.inprogress.get(key = new Checksum(sum1, sum2))) == null) {
            try {
                AsyncFutureImpl<URL> promise = new AsyncFutureImpl<URL>();
                ExecutorServiceUtils.submitAsync(this.downloader, new DownloadRunnable(channel, sum1, sum2, key, promise));
                this.inprogress.putIfAbsent(key, promise);
                continue;
            }
            catch (ExecutorServiceUtils.ExecutionRejectedException ex) {
                String message = "Downloader executor service has rejected the download command for checksum " + key;
                LOGGER.log(Level.SEVERE, message, ex);
                if (ex.isFatal()) {
                    throw new IOException(message, ex);
                }
                Thread.sleep(100L);
                continue;
            }
            break;
        }
        return cur;
    }

    protected JarLoader getJarLoader(Channel channel) throws InterruptedException {
        JarLoader jl = channel.getProperty(JarLoader.THEIRS);
        if (jl == null) {
            jl = (JarLoader)channel.waitForRemoteProperty(JarLoader.OURS);
            channel.setProperty(JarLoader.THEIRS, jl);
        }
        return jl;
    }

    private class DownloadRunnable
    implements Runnable {
        final Channel channel;
        final long sum1;
        final long sum2;
        final Checksum key;
        final AsyncFutureImpl<URL> promise;

        public DownloadRunnable(Channel channel, long sum1, long sum2, Checksum key, AsyncFutureImpl<URL> promise) {
            this.channel = channel;
            this.sum1 = sum1;
            this.sum2 = sum2;
            this.key = key;
            this.promise = promise;
        }

        @Override
        public void run() {
            try {
                Future inprogressDownload = (Future)JarCacheSupport.this.inprogress.get(this.key);
                if (this.promise != inprogressDownload) {
                    return;
                }
                URL url = JarCacheSupport.this.retrieve(this.channel, this.sum1, this.sum2);
                JarCacheSupport.this.inprogress.remove(this.key);
                this.promise.set(url);
            }
            catch (ChannelClosedException e) {
                this.bailout(e);
            }
            catch (RequestAbortedException e) {
                this.bailout(e);
            }
            catch (InterruptedException e) {
                this.bailout(e);
                LOGGER.log(Level.WARNING, String.format("Interrupted while resolving a jar %016x%016x", this.sum1, this.sum2), e);
            }
            catch (Throwable e) {
                this.promise.set(e);
                LOGGER.log(Level.WARNING, String.format("Failed to resolve a jar %016x%016x", this.sum1, this.sum2), e);
            }
        }

        private void bailout(Exception e) {
            JarCacheSupport.this.inprogress.remove(this.key);
            this.promise.set(e);
        }
    }
}

