/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.HexDump;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import javax.annotation.Nonnull;

public class DiagnosedStreamCorruptionException
extends StreamCorruptedException {
    private final Exception diagnoseFailure;
    @Nonnull
    private final byte[] readBack;
    @Nonnull
    private final byte[] readAhead;

    DiagnosedStreamCorruptionException(Exception cause, Exception diagnoseFailure, @Nonnull byte[] readBack, @Nonnull byte[] readAhead) {
        this.initCause(cause);
        this.diagnoseFailure = diagnoseFailure;
        this.readBack = readBack;
        this.readAhead = readAhead;
    }

    public Exception getDiagnoseFailure() {
        return this.diagnoseFailure;
    }

    @Nonnull
    public byte[] getReadBack() {
        return (byte[])this.readBack.clone();
    }

    @Nonnull
    public byte[] getReadAhead() {
        return (byte[])this.readAhead.clone();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()).append("\n");
        buf.append("Read back: ").append(HexDump.toHex(this.readBack)).append('\n');
        buf.append("Read ahead: ").append(HexDump.toHex(this.readAhead));
        if (this.diagnoseFailure != null) {
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            this.diagnoseFailure.printStackTrace(p);
            p.flush();
            buf.append("\nDiagnosis problem:\n    ");
            buf.append(w.toString().trim().replace("\n", "\n    "));
        }
        return buf.toString();
    }
}

