/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.remoting.BinarySafeStream;
import hudson.remoting.Callable;
import hudson.remoting.CallableDecoratorAdapter;
import hudson.remoting.CallableDecoratorList;
import hudson.remoting.CallableFilter;
import hudson.remoting.Capability;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.ChannelProperty;
import hudson.remoting.ClassFilter;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import hudson.remoting.ExportTable;
import hudson.remoting.Future;
import hudson.remoting.FutureAdapter;
import hudson.remoting.GCCommand;
import hudson.remoting.IChannel;
import hudson.remoting.ImportedClassLoaderTable;
import hudson.remoting.InterceptingExecutorService;
import hudson.remoting.JarCache;
import hudson.remoting.JarLoader;
import hudson.remoting.JarLoaderImpl;
import hudson.remoting.PipeWindow;
import hudson.remoting.PipeWriter;
import hudson.remoting.PreloadJarTask;
import hudson.remoting.RemoteClassLoader;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.Request;
import hudson.remoting.Response;
import hudson.remoting.SingleLaneExecutorService;
import hudson.remoting.SynchronousExecutorService;
import hudson.remoting.UserRequest;
import hudson.remoting.UserResponse;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.remoting.forward.ForwarderFactory;
import hudson.remoting.forward.ListeningPort;
import hudson.remoting.forward.PortForwarder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.CallableDecorator;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class Channel
implements VirtualChannel,
IChannel,
Closeable {
    private final CommandTransport transport;
    @Deprecated
    private final OutputStream underlyingOutput;
    private final String name;
    private volatile boolean remoteClassLoadingAllowed;
    private volatile boolean arbitraryCallableAllowed;
    final CallableDecoratorList decorators = new CallableDecoratorList();
    @Restricted(value={NoExternalUse.class})
    public final ExecutorService executor;
    private volatile Throwable inClosed = null;
    private volatile Throwable outClosed = null;
    final Map<Integer, Request<?, ?>> pendingCalls = new Hashtable();
    private final ThreadLocal<int[]> lastIoId = new ThreadLastIoId();
    final Map<Integer, Request<?, ?>> executingCalls = Collections.synchronizedMap(new Hashtable());
    final ImportedClassLoaderTable importedClassLoaders = new ImportedClassLoaderTable(this);
    final ExportTable exportedObjects = new ExportTable();
    private final WeakHashMap<PipeWindow.Key, WeakReference<PipeWindow>> pipeWindows = new WeakHashMap();
    private final Ref reference;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private int gcCounter;
    private volatile long commandsSent;
    private volatile long commandsReceived;
    private volatile long lastCommandSentAt;
    private volatile long lastCommandReceivedAt;
    private final long createdAt = System.currentTimeMillis();
    public final AtomicLong classLoadingTime = new AtomicLong();
    public final AtomicInteger classLoadingCount = new AtomicInteger();
    public final AtomicInteger classLoadingPrefetchCacheCount = new AtomicInteger();
    public final AtomicLong resourceLoadingTime = new AtomicLong();
    public final AtomicInteger resourceLoadingCount = new AtomicInteger();
    private final AtomicInteger ioId = new AtomicInteger();
    private final ConcurrentHashMap<Object, Object> properties = new ConcurrentHashMap();
    private final IChannel remoteChannel;
    public final Capability remoteCapability;
    final PipeWriter pipeWriter;
    final ClassLoader baseClassLoader;
    @CheckForNull
    private JarCache jarCache;
    final JarLoaderImpl jarLoader;
    short maximumBytecodeLevel = (short)Short.MAX_VALUE;
    @Nonnull
    final ClassFilter classFilter;
    private boolean closeRequested = false;
    @CheckForNull
    private Throwable closeRequestCause = null;
    private static final ThreadLocal<Channel> CURRENT = new ThreadLocal();
    private static final Logger logger = Logger.getLogger(Channel.class.getName());
    public static final int PIPE_WINDOW_SIZE = Integer.getInteger(Channel.class.getName() + ".pipeWindowSize", 0x100000);
    private static final Map<Channel, Ref> ACTIVE_CHANNELS = Collections.synchronizedMap(new WeakHashMap());
    static final Class jarLoaderProxy = RemoteInvocationHandler.getProxyClass(JarLoader.class);

    @Deprecated
    public Channel(String name, ExecutorService exec, InputStream is, OutputStream os) throws IOException {
        this(name, exec, Mode.BINARY, is, os, null);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os) throws IOException {
        this(name, exec, mode, is, os, null);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, InputStream is, OutputStream os, OutputStream header) throws IOException {
        this(name, exec, Mode.BINARY, is, os, header);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header) throws IOException {
        this(name, exec, mode, is, os, header, false);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted) throws IOException {
        this(name, exec, mode, is, os, header, restricted, null);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted, ClassLoader base) throws IOException {
        this(name, exec, mode, is, os, header, restricted, base, new Capability());
    }

    Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted, ClassLoader base, Capability capability) throws IOException {
        this(new ChannelBuilder(name, exec).withMode(mode).withBaseLoader(base).withCapability(capability).withHeaderStream(header).withRestricted(restricted), is, os);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, CommandTransport transport, boolean restricted, ClassLoader base) throws IOException {
        this(new ChannelBuilder(name, exec).withBaseLoader(base).withRestricted(restricted), transport);
    }

    Channel(ChannelBuilder settings, InputStream is, OutputStream os) throws IOException {
        this(settings, settings.negotiate(is, os));
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, CommandTransport transport, boolean restricted, ClassLoader base, JarCache jarCache) throws IOException {
        this(new ChannelBuilder(name, exec).withBaseLoader(base).withRestricted(restricted).withJarCache(jarCache), transport);
    }

    protected Channel(@Nonnull ChannelBuilder settings, @Nonnull CommandTransport transport) throws IOException {
        this.name = settings.getName();
        this.reference = new Ref(this);
        this.executor = new InterceptingExecutorService(settings.getExecutors(), this.decorators);
        this.arbitraryCallableAllowed = settings.isArbitraryCallableAllowed();
        this.remoteClassLoadingAllowed = settings.isRemoteClassLoadingAllowed();
        this.underlyingOutput = transport.getUnderlyingStream();
        this.jarCache = settings.getJarCache();
        if (this.jarCache == null) {
            logger.log(Level.CONFIG, "JAR Cache is not defined for channel {0}", this.name);
        }
        this.baseClassLoader = settings.getBaseLoader();
        this.classFilter = settings.getClassFilter();
        if (this.internalExport(IChannel.class, this, false) != 1) {
            throw new AssertionError();
        }
        this.remoteChannel = RemoteInvocationHandler.wrap(this, 1, IChannel.class, true, false, false, true);
        this.remoteCapability = transport.getRemoteCapability();
        this.pipeWriter = new PipeWriter(this.createPipeWriterExecutor());
        this.transport = transport;
        this.jarLoader = new JarLoaderImpl();
        this.setProperty(JarLoader.OURS, this.jarLoader);
        this.decorators.addAll(settings.getDecorators());
        this.properties.putAll(settings.getProperties());
        transport.setup(this, new CommandTransport.CommandReceiver(){

            @Override
            public void handle(Command cmd) {
                Channel.this.commandsReceived++;
                long receivedAt = System.currentTimeMillis();
                Channel.this.lastCommandReceivedAt = receivedAt;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Received " + cmd);
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Received command " + cmd, cmd.createdAt);
                }
                try {
                    cmd.execute(Channel.this);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Completed command {0}. It took {1}ms", new Object[]{cmd, System.currentTimeMillis() - receivedAt});
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed to execute command " + cmd + " (channel " + Channel.this.name + ")", t);
                    logger.log(Level.SEVERE, "This command is created here", cmd.createdAt);
                }
            }

            @Override
            public void terminate(IOException e) {
                Channel.this.terminate(e);
            }
        });
        ACTIVE_CHANNELS.put(this, this.ref());
    }

    @Nonnull
    Ref ref() {
        return this.reference;
    }

    public boolean isOutClosed() {
        return this.outClosed != null;
    }

    @CheckForNull
    public final Throwable getSenderCloseCause() {
        return this.outClosed;
    }

    public boolean isClosingOrClosed() {
        return this.closeRequested || this.inClosed != null || this.outClosed != null;
    }

    @CheckForNull
    public Throwable getCloseRequestCause() {
        return this.outClosed != null ? this.outClosed : this.closeRequestCause;
    }

    private ExecutorService createPipeWriterExecutor() {
        if (this.remoteCapability.supportsPipeThrottling()) {
            return new SingleLaneExecutorService(this.executor);
        }
        return new SynchronousExecutorService();
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="The method is synchronized, no other usages. See https://sourceforge.net/p/findbugs/bugs/1032/")
    synchronized void send(Command cmd) throws IOException {
        if (this.outClosed != null) {
            throw new ChannelClosedException(this, this.outClosed);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Send " + cmd);
        }
        this.transport.write(cmd, cmd instanceof CloseCommand);
        ++this.commandsSent;
        this.lastCommandSentAt = System.currentTimeMillis();
    }

    @Override
    public <T> T export(Class<T> type, T instance) {
        return this.export(type, instance, true, true, true);
    }

    @Nullable
    <T> T export(Class<T> type, @CheckForNull T instance, boolean userProxy, boolean userScope, boolean recordCreatedAt) {
        if (instance == null) {
            return null;
        }
        if (++this.gcCounter % 10000 == 0) {
            try {
                this.send(new GCCommand());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to send GC command", e);
            }
        }
        boolean autoUnexportByCaller = this.exportedObjects.isRecording();
        int id = this.internalExport(type, instance, autoUnexportByCaller);
        return RemoteInvocationHandler.wrap(null, id, type, userProxy, autoUnexportByCaller, userScope, recordCreatedAt);
    }

    <T> int internalExport(Class<T> clazz, T instance) {
        return this.exportedObjects.export(clazz, instance);
    }

    <T> int internalExport(Class<T> clazz, T instance, boolean automaticUnexport) {
        return this.exportedObjects.export(clazz, instance, automaticUnexport);
    }

    @Nonnull
    Object getExportedObject(int oid) throws ExecutionException {
        return this.exportedObjects.get(oid);
    }

    @CheckForNull
    Object getExportedObjectOrNull(int oid) {
        return this.exportedObjects.getOrNull(oid);
    }

    @Nonnull
    Class[] getExportedTypes(int oid) throws ExecutionException {
        return this.exportedObjects.type(oid);
    }

    void unexport(int id, @CheckForNull Throwable cause) {
        this.unexport(id, cause, true);
    }

    void unexport(int id, @CheckForNull Throwable cause, boolean severeErrorIfMissing) {
        this.exportedObjects.unexportByOid(id, cause, severeErrorIfMissing);
    }

    public void pin(@Nonnull Object instance) {
        this.exportedObjects.pin(instance);
    }

    public void pinClassLoader(ClassLoader cl) {
        RemoteClassLoader.pin(cl, this);
    }

    public boolean preloadJar(Callable<?, ?> classLoaderRef, Class ... classesInJar) throws IOException, InterruptedException {
        return this.preloadJar(UserRequest.getClassLoader(classLoaderRef), classesInJar);
    }

    public boolean preloadJar(ClassLoader local, Class ... classesInJar) throws IOException, InterruptedException {
        URL[] jars = new URL[classesInJar.length];
        for (int i = 0; i < classesInJar.length; ++i) {
            jars[i] = Which.jarFile(classesInJar[i]).toURI().toURL();
        }
        return this.call(new PreloadJarTask(jars, local));
    }

    public boolean preloadJar(ClassLoader local, URL ... jars) throws IOException, InterruptedException {
        return this.call(new PreloadJarTask(jars, local));
    }

    @CheckForNull
    public JarCache getJarCache() {
        return this.jarCache;
    }

    public void setJarCache(@Nonnull JarCache jarCache) {
        this.jarCache = jarCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PipeWindow getPipeWindow(int oid) {
        WeakHashMap<PipeWindow.Key, WeakReference<PipeWindow>> weakHashMap = this.pipeWindows;
        synchronized (weakHashMap) {
            PipeWindow w;
            PipeWindow.Key k = new PipeWindow.Key(oid);
            WeakReference<PipeWindow> v = this.pipeWindows.get(k);
            if (v != null && (w = (PipeWindow)v.get()) != null) {
                return w;
            }
            w = this.remoteCapability.supportsPipeThrottling() ? new PipeWindow.Real(k, PIPE_WINDOW_SIZE) : new PipeWindow.Fake();
            this.pipeWindows.put(k, new WeakReference<PipeWindow>(w));
            return w;
        }
    }

    @Override
    public <V, T extends Throwable> V call(Callable<V, T> callable) throws IOException, T, InterruptedException {
        if (this.isClosingOrClosed()) {
            throw new ChannelClosedException("Remote call on " + this.name + " failed. The channel is closing down or has closed down", this.getCloseRequestCause());
        }
        UserRequest request = null;
        try {
            request = new UserRequest(this, callable);
            UserResponse r = (UserResponse)request.call(this);
            Object RSP = r.retrieve(this, UserRequest.getClassLoader(callable));
            return (V)RSP;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Remote call on " + this.name + " failed", e);
        }
        catch (Error e) {
            throw new IOException("Remote call on " + this.name + " failed", e);
        }
        catch (SecurityException e) {
            throw new IOException("Failed to deserialize response to " + request + ": " + e, e);
        }
        finally {
            if (request != null) {
                request.releaseExports();
            }
        }
    }

    @Override
    public <V, T extends Throwable> Future<V> callAsync(final Callable<V, T> callable) throws IOException {
        if (this.isClosingOrClosed()) {
            throw new ChannelClosedException("Remote call on " + this.name + " failed. The channel is closing down or has closed down", this.getCloseRequestCause());
        }
        Future f = new UserRequest(this, callable).callAsync(this);
        return new FutureAdapter<V, UserResponse<V, T>>(f){

            @Override
            protected V adapt(UserResponse<V, T> r) throws ExecutionException {
                try {
                    return r.retrieve(Channel.this, UserRequest.getClassLoader(callable));
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"ITA_INEFFICIENT_TO_ARRAY"})
    public void terminate(@Nonnull IOException e) {
        if (e == null) {
            throw new IllegalArgumentException("Cause is null. Channel cannot be closed properly in such case");
        }
        this.closeRequested = true;
        if (this.closeRequestCause == null) {
            this.closeRequestCause = e;
        }
        try {
            Channel channel = this;
            synchronized (channel) {
                this.outClosed = this.inClosed = e;
                RemoteInvocationHandler.notifyChannelTermination(this);
                try {
                    this.transport.closeRead();
                }
                catch (IOException x) {
                    logger.log(Level.WARNING, "Failed to close down the reader side of the transport", x);
                }
                try {
                    Map<Integer, Request<?, ?>> x = this.pendingCalls;
                    synchronized (x) {
                        for (Request<?, ?> req : this.pendingCalls.values()) {
                            req.abort(e);
                        }
                        this.pendingCalls.clear();
                    }
                    x = this.executingCalls;
                    synchronized (x) {
                        for (Request<?, ?> r : this.executingCalls.values()) {
                            java.util.concurrent.Future<?> f = r.future;
                            if (f == null) continue;
                            f.cancel(true);
                        }
                        this.executingCalls.clear();
                    }
                    this.exportedObjects.abort(e);
                    this.reference.clear(e);
                }
                finally {
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            if (e instanceof OrderlyShutdown) {
                e = null;
            }
            for (Listener l : this.listeners) {
                try {
                    l.onClosed(this, e);
                }
                catch (Throwable t) {
                    LogRecord lr = new LogRecord(Level.SEVERE, "Listener {0} propagated an exception for channel {1}'s close: {2}");
                    lr.setThrown(t);
                    lr.setParameters(new Object[]{l, this, t.getMessage()});
                    logger.log(lr);
                }
            }
            throw throwable;
        }
        if (e instanceof OrderlyShutdown) {
            e = null;
        }
        for (Listener l : this.listeners) {
            try {
                l.onClosed(this, e);
            }
            catch (Throwable t) {
                LogRecord lr = new LogRecord(Level.SEVERE, "Listener {0} propagated an exception for channel {1}'s close: {2}");
                lr.setThrown(t);
                lr.setParameters(new Object[]{l, this, t.getMessage()});
                logger.log(lr);
            }
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.listeners.remove(l);
    }

    public void addLocalExecutionInterceptor(CallableDecorator decorator) {
        this.decorators.add(decorator);
    }

    public void removeLocalExecutionInterceptor(CallableDecorator decorator) {
        this.decorators.remove(decorator);
    }

    @Deprecated
    public void addLocalExecutionInterceptor(CallableFilter filter) {
        this.addLocalExecutionInterceptor(new CallableDecoratorAdapter(filter));
    }

    @Deprecated
    public void removeLocalExecutionInterceptor(CallableFilter filter) {
        this.removeLocalExecutionInterceptor(new CallableDecoratorAdapter(filter));
    }

    @Override
    public synchronized void join() throws InterruptedException {
        while (this.inClosed == null || this.outClosed == null) {
            this.wait(30000L);
        }
    }

    public boolean isInClosed() {
        return this.inClosed != null;
    }

    @Deprecated
    public boolean isRestricted() {
        return !this.isRemoteClassLoadingAllowed() || !this.isArbitraryCallableAllowed();
    }

    @Deprecated
    public void setRestricted(boolean b) {
        this.setRemoteClassLoadingAllowed(!b);
        this.setArbitraryCallableAllowed(!b);
    }

    public boolean isRemoteClassLoadingAllowed() {
        return this.remoteClassLoadingAllowed;
    }

    public void setRemoteClassLoadingAllowed(boolean b) {
        this.remoteClassLoadingAllowed = b;
    }

    public boolean isArbitraryCallableAllowed() {
        return this.arbitraryCallableAllowed;
    }

    public void setArbitraryCallableAllowed(boolean b) {
        this.arbitraryCallableAllowed = b;
    }

    public void setMaximumBytecodeLevel(short level) throws IOException, InterruptedException {
        if (level < 5) {
            throw new IllegalArgumentException("Does not make sense to specify JDK 1.4 or below since remoting itself requires JDK 5+");
        }
        this.call(new SetMaximumBytecodeLevel(level));
    }

    @Override
    public synchronized void join(long timeout) throws InterruptedException {
        long now = System.nanoTime();
        long end = now + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (end - now > 0L && (this.inClosed == null || this.outClosed == null)) {
            this.wait(TimeUnit.NANOSECONDS.toMillis(end - now));
            now = System.nanoTime();
        }
    }

    public void resetPerformanceCounters() {
        this.classLoadingCount.set(0);
        this.classLoadingTime.set(0L);
        this.classLoadingPrefetchCacheCount.set(0);
        this.resourceLoadingCount.set(0);
        this.resourceLoadingTime.set(0L);
    }

    public void dumpPerformanceCounters(PrintWriter w) throws IOException {
        int l = this.classLoadingCount.get();
        int p = this.classLoadingPrefetchCacheCount.get();
        w.printf(Locale.ENGLISH, "Class loading count=%d%n", l);
        w.printf(Locale.ENGLISH, "Class loading prefetch hit=%s (%d%%)%n", p, p * 100 / l);
        w.printf(Locale.ENGLISH, "Class loading time=%,dms%n", this.classLoadingTime.get() / 1000000L);
        w.printf(Locale.ENGLISH, "Resource loading count=%d%n", this.resourceLoadingCount.get());
        w.printf(Locale.ENGLISH, "Resource loading time=%,dms%n", this.resourceLoadingTime.get() / 1000000L);
    }

    @Restricted(value={NoExternalUse.class})
    public void dumpDiagnostics(@Nonnull PrintWriter w) throws IOException {
        w.printf("Channel %s%n", this.name);
        w.printf("  Created=%s%n", new Date(this.createdAt));
        w.printf("  Commands sent=%d%n", this.commandsSent);
        w.printf("  Commands received=%d%n", this.commandsReceived);
        w.printf("  Last command sent=%s%n", new Date(this.lastCommandSentAt));
        w.printf("  Last command received=%s%n", new Date(this.lastCommandReceivedAt));
        w.printf("  Pending calls=%d%n", this.pendingCalls.size());
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(@CheckForNull Throwable diagnosis) throws IOException {
        if (this.outClosed != null) {
            return;
        }
        this.closeRequested = true;
        if (this.closeRequestCause == null) {
            this.closeRequestCause = new IOException(diagnosis);
        }
        Channel channel = this;
        synchronized (channel) {
            if (this.outClosed != null) {
                return;
            }
            try {
                this.send(new CloseCommand(this, diagnosis));
            }
            catch (ChannelClosedException e) {
                logger.log(Level.FINEST, "Channel is already closed", e);
                this.terminate(e);
                return;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Having to terminate early", e);
                this.terminate(e);
                return;
            }
            this.outClosed = new IOException(diagnosis);
            this.notifyAll();
            try {
                this.transport.closeWrite();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public <T> T getProperty(ChannelProperty<T> key) {
        return key.type.cast(this.getProperty((Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Object waitForProperty(@Nonnull Object key) throws InterruptedException {
        Object v;
        Object prop = this.properties.get(key);
        if (prop != null) {
            return prop;
        }
        if (this.isInClosed()) {
            throw new IllegalStateException("Channel was already closed", this.inClosed);
        }
        if (this.isOutClosed()) {
            throw new IllegalStateException("Channel was already closed", this.outClosed);
        }
        do {
            Channel channel = this;
            synchronized (channel) {
                if (this.isInClosed()) {
                    throw new IllegalStateException("Channel was already closed", this.inClosed);
                }
                if (this.isOutClosed()) {
                    throw new IllegalStateException("Channel was already closed", this.outClosed);
                }
                this.wait(1000L);
            }
        } while ((v = this.properties.get(key)) == null);
        return v;
    }

    public <T> T waitForProperty(ChannelProperty<T> key) throws InterruptedException {
        return key.type.cast(this.waitForProperty((Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Object setProperty(@Nonnull Object key, @CheckForNull Object value) {
        if (value == null) {
            return this.properties.remove(key);
        }
        Channel channel = this;
        synchronized (channel) {
            Object old = this.properties.put(key, value);
            this.notifyAll();
            return old;
        }
    }

    public <T> T setProperty(ChannelProperty<T> key, T value) {
        return key.type.cast(this.setProperty((Object)key, (Object)value));
    }

    @CheckForNull
    public Object getRemoteProperty(Object key) {
        return this.remoteChannel.getProperty(key);
    }

    @CheckForNull
    public <T> T getRemoteProperty(ChannelProperty<T> key) {
        return key.type.cast(this.getRemoteProperty((Object)key));
    }

    public Object waitForRemoteProperty(Object key) throws InterruptedException {
        return this.remoteChannel.waitForProperty(key);
    }

    @Deprecated
    public <T> T waitForRemoteProperty(ChannelProperty<T> key) throws InterruptedException {
        return key.type.cast(this.waitForRemoteProperty((Object)key));
    }

    @Deprecated
    public OutputStream getUnderlyingOutput() {
        return this.underlyingOutput;
    }

    public ListeningPort createLocalToRemotePortForwarding(int recvPort, String forwardHost, int forwardPort) throws IOException, InterruptedException {
        PortForwarder portForwarder = new PortForwarder(recvPort, ForwarderFactory.create(this, forwardHost, forwardPort));
        portForwarder.start();
        return portForwarder;
    }

    public ListeningPort createRemoteToLocalPortForwarding(int recvPort, String forwardHost, int forwardPort) throws IOException, InterruptedException {
        return PortForwarder.create(this, recvPort, ForwarderFactory.create(forwardHost, forwardPort));
    }

    int newIoId() {
        int v;
        this.lastIoId.get()[0] = v = this.ioId.incrementAndGet();
        return v;
    }

    int lastIoId() {
        return this.lastIoId.get()[0];
    }

    public void syncIO() throws IOException, InterruptedException {
        this.call(new IOSyncer());
    }

    @Override
    public void syncLocalIO() throws InterruptedException {
        Thread t = Thread.currentThread();
        String old = t.getName();
        t.setName("I/O sync: " + old);
        try {
            this.pipeWriter.submit(0, new Runnable(){

                @Override
                public void run() {
                }
            }).get();
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            t.setName(old);
        }
    }

    void attachCallSiteStackTrace(Throwable t) {
        t.addSuppressed(new CallSiteStackTrace(this.name));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + ":" + this.name;
    }

    public void dumpExportTable(PrintWriter w) throws IOException {
        this.exportedObjects.dump(w);
    }

    public ExportTable.ExportList startExportRecording() {
        return this.exportedObjects.startRecording();
    }

    public long getLastHeard() {
        return this.lastCommandReceivedAt;
    }

    static Channel setCurrent(Channel channel) {
        Channel old = CURRENT.get();
        if (channel == null) {
            CURRENT.remove();
        } else {
            CURRENT.set(channel);
        }
        return old;
    }

    @CheckForNull
    public static Channel current() {
        return CURRENT.get();
    }

    @Nonnull
    public static Channel currentOrFail() throws IllegalStateException {
        Channel ch = CURRENT.get();
        if (ch == null) {
            Thread t = Thread.currentThread();
            throw new IllegalStateException("The calling thread " + t + " has no associated channel");
        }
        return ch;
    }

    @Restricted(value={NoExternalUse.class})
    public static void dumpDiagnosticsForAll(@Nonnull PrintWriter w) {
        Ref[] channels = ACTIVE_CHANNELS.values().toArray(new Ref[0]);
        int processedCount = 0;
        for (Ref ref : channels) {
            if (w.checkError()) {
                logger.log(Level.WARNING, String.format("Cannot dump diagnostics for all channels, because output stream encountered an error. Processed %d of %d channels, first unprocessed channel reference is %s.", processedCount, channels.length, ref));
                break;
            }
            Channel ch = ref.channel();
            if (ch != null) {
                try {
                    ch.dumpDiagnostics(w);
                }
                catch (Throwable ex) {
                    if (ex instanceof Error) {
                        throw (Error)ex;
                    }
                    w.printf("Cannot dump diagnostics for the channel %s. %s. See Error stacktrace in system logs", ch.getName(), ex.getMessage());
                    logger.log(Level.WARNING, String.format("Cannot dump diagnostics for the channel %s", ch.getName()), ex);
                }
            }
            ++processedCount;
        }
    }

    void notifyRead(Command cmd, long blockSize) {
        for (Listener listener : this.listeners) {
            try {
                listener.onRead(this, cmd, blockSize);
            }
            catch (Throwable x) {
                logger.log(Level.WARNING, null, x);
            }
        }
    }

    void notifyWrite(Command cmd, long blockSize) {
        for (Listener listener : this.listeners) {
            try {
                listener.onWrite(this, cmd, blockSize);
            }
            catch (Throwable x) {
                logger.log(Level.WARNING, null, x);
            }
        }
    }

    void notifyResponse(Request<?, ?> req, Response<?, ?> rsp, long totalTime) {
        for (Listener listener : this.listeners) {
            try {
                listener.onResponse(this, req, rsp, totalTime);
            }
            catch (Throwable x) {
                logger.log(Level.WARNING, null, x);
            }
        }
    }

    void notifyJar(File jar) {
        for (Listener listener : this.listeners) {
            try {
                listener.onJar(this, jar);
            }
            catch (Throwable x) {
                logger.log(Level.WARNING, null, x);
            }
        }
    }

    static final class Ref {
        @Nonnull
        private final String name;
        @CheckForNull
        private Channel channel;
        private Exception cause;

        private Ref(@CheckForNull Channel channel) {
            this.name = channel != null ? channel.getName() : "unknown (null reference)";
            this.channel = channel;
        }

        @CheckForNull
        public Channel channel() {
            return this.channel;
        }

        @CheckForNull
        public Exception cause() {
            return this.cause;
        }

        @Nonnull
        public String name() {
            return this.name;
        }

        public void clear(@Nonnull Exception cause) {
            this.channel = null;
            this.cause = cause;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Channel.Ref{");
            sb.append("channel=").append(this.channel);
            sb.append(",name=").append(this.name);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ThreadLastIoId
    extends ThreadLocal<int[]> {
        private ThreadLastIoId() {
        }

        @Override
        protected int[] initialValue() {
            return new int[1];
        }
    }

    private static final class CallSiteStackTrace
    extends Exception {
        public CallSiteStackTrace(String message) {
            super("Remote call to " + message);
        }
    }

    private static final class IOSyncer
    implements Callable<Object, InterruptedException> {
        private static final long serialVersionUID = 1L;

        private IOSyncer() {
        }

        @Override
        public Object call() throws InterruptedException {
            Channel.currentOrFail().syncLocalIO();
            return null;
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    private static final class OrderlyShutdown
    extends IOException {
        private static final long serialVersionUID = 1L;

        private OrderlyShutdown(@CheckForNull Throwable cause) {
            super(cause);
        }
    }

    private static final class CloseCommand
    extends Command {
        static final long serialVersionUID = 972857271608138115L;

        private CloseCommand(Channel channel, @CheckForNull Throwable cause) {
            super(channel, cause);
        }

        @Override
        protected void execute(Channel channel) {
            try {
                channel.close();
                channel.terminate(new OrderlyShutdown(this.createdAt));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "close command failed on " + channel.name, e);
                logger.log(Level.INFO, "close command created at", this.createdAt);
            }
        }

        @Override
        public String toString() {
            return "Close";
        }
    }

    private static final class SetMaximumBytecodeLevel
    implements Callable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final short level;

        SetMaximumBytecodeLevel(short level) {
            this.level = level;
        }

        @Override
        public Void call() throws RuntimeException {
            Channel.currentOrFail().maximumBytecodeLevel = this.level;
            return null;
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    public static abstract class Listener {
        public void onClosed(Channel channel, IOException cause) {
        }

        public void onRead(Channel channel, Command cmd, long blockSize) {
        }

        public void onWrite(Channel channel, Command cmd, long blockSize) {
        }

        public void onResponse(Channel channel, Request<?, ?> req, Response<?, ?> rsp, long totalTime) {
        }

        public void onJar(Channel channel, File jar) {
        }
    }

    public static enum Mode {
        BINARY(new byte[]{0, 0, 0, 0}),
        TEXT("<===[HUDSON TRANSMISSION BEGINS]===>"){

            @Override
            protected OutputStream wrap(OutputStream os) {
                return BinarySafeStream.wrap(os);
            }

            @Override
            protected InputStream wrap(InputStream is) {
                return BinarySafeStream.wrap(is);
            }
        }
        ,
        NEGOTIATE(new byte[0]);

        final byte[] preamble;

        private Mode(String preamble) {
            try {
                this.preamble = preamble.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        private Mode(byte[] preamble) {
            this.preamble = preamble;
        }

        protected OutputStream wrap(OutputStream os) {
            return os;
        }

        protected InputStream wrap(InputStream is) {
            return is;
        }
    }
}

