/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.plugins.swarm.SwarmClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import javax.xml.parsers.ParserConfigurationException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class Client {
    protected final Options options;

    public static void main(String ... args) throws InterruptedException, IOException {
        Options options = new Options();
        Client client = new Client(options);
        CmdLineParser p = new CmdLineParser((Object)options);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.out.println(e.getMessage());
            p.printUsage((OutputStream)System.out);
            System.exit(-1);
        }
        if (options.help) {
            p.printUsage((OutputStream)System.out);
            System.exit(0);
        }
        if (options.passwordEnvVariable != null) {
            options.password = System.getenv(options.passwordEnvVariable);
        }
        if (options.name == null) {
            try {
                client.options.name = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (IOException e) {
                System.out.println("Failed to lookup the canonical hostname of this slave, please check system settings.");
                System.out.println("If not possible to resolve please specify a node name using the '-name' option");
                System.exit(-1);
            }
        }
        client.run();
    }

    public Client(Options options) {
        this.options = options;
    }

    public void run() throws InterruptedException {
        System.out.println("Discovering Jenkins master");
        SwarmClient swarmClient = new SwarmClient(this.options);
        while (true) {
            block12: {
                try {
                    Candidate target;
                    if (this.options.master == null) {
                        System.out.println("No Jenkins master supplied on command line, performing auto-discovery");
                        target = swarmClient.discoverFromBroadcast();
                    } else {
                        target = swarmClient.discoverFromMasterUrl();
                    }
                    if (this.options.password == null && this.options.username == null) {
                        swarmClient.verifyThatUrlIsHudson(target);
                    }
                    System.out.println("Attempting to connect to " + target.url + " " + target.secret + " with ID " + swarmClient.getHash());
                    swarmClient.createSwarmSlave(target);
                    swarmClient.connect(target);
                    if (this.options.noRetryAfterConnected) {
                        System.out.println("Connection closed, exiting...");
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (RetryException e) {
                    System.out.println(e.getMessage());
                    if (e.getCause() == null) break block12;
                    e.getCause().printStackTrace();
                }
            }
            if (this.options.retry >= 0) {
                if (this.options.retry == 0) {
                    System.out.println("Retry limit reached, exiting...");
                    System.exit(-1);
                } else {
                    System.out.println("Remaining retries: " + this.options.retry);
                    --this.options.retry;
                }
            }
            System.out.println("Retrying in 10 seconds");
            Thread.sleep(10000L);
        }
    }
}

