/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.remoting.Launcher;
import hudson.remoting.jnlp.Main;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwarmClient {
    private final Options options;
    private final String hash;
    private String name;

    public SwarmClient(Options options) {
        this.options = options;
        this.hash = SwarmClient.hash(options.remoteFsRoot);
        this.name = options.name;
    }

    public String getHash() {
        return this.hash;
    }

    public Candidate discoverFromBroadcast() throws IOException, RetryException, ParserConfigurationException {
        DatagramSocket socket = new DatagramSocket();
        socket.setBroadcast(true);
        this.sendBroadcast(socket);
        List<DatagramPacket> responses = this.collectBroadcastResponses(socket);
        return this.getCandidateFromDatagramResponses(responses);
    }

    private Candidate getCandidateFromDatagramResponses(List<DatagramPacket> responses) throws ParserConfigurationException, IOException, RetryException {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (DatagramPacket recv : responses) {
            String url;
            Document xml;
            String responseXml = new String(recv.getData(), 0, recv.getLength());
            System.out.println();
            String address = this.printable(recv.getAddress());
            try {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(recv.getData(), 0, recv.getLength()));
            }
            catch (SAXException e) {
                System.out.println("Invalid response XML from " + address + ": " + responseXml);
                continue;
            }
            if (!StringUtils.isBlank((String)this.options.candidateTag)) {
                System.out.println(address + this.options.candidateTag);
                continue;
            }
            String swarm = SwarmClient.getChildElementString(xml.getDocumentElement(), "swarm");
            if (swarm == null) {
                System.out.println(address + " doesn't support swarm");
                continue;
            }
            String string = url = this.options.master == null ? SwarmClient.getChildElementString(xml.getDocumentElement(), "url") : this.options.master;
            if (url == null) {
                System.out.println("Jenkins master at '" + address + "' doesn't have a valid Jenkins URL configuration set. Please go to <jenkins url>/configure and set a valid URL.");
                continue;
            }
            candidates.add(new Candidate(url, swarm));
        }
        if (candidates.isEmpty()) {
            throw new RetryException("No nearby Jenkins supports swarming");
        }
        System.out.println("Found " + candidates.size() + " eligible Jenkins.");
        return (Candidate)candidates.get(new Random().nextInt(candidates.size()));
    }

    protected void sendBroadcast(DatagramSocket socket) throws IOException {
        byte[] buffer = new byte[128];
        Arrays.fill(buffer, (byte)1);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        packet.setAddress(InetAddress.getByName(this.options.autoDiscoveryAddress));
        packet.setPort(Integer.getInteger("jenkins.udp", Integer.getInteger("hudson.udp", 33848)));
        socket.send(packet);
    }

    protected List<DatagramPacket> collectBroadcastResponses(DatagramSocket socket) throws IOException, RetryException {
        ArrayList<DatagramPacket> responses = new ArrayList<DatagramPacket>();
        long limit = System.currentTimeMillis() + 5000L;
        try {
            while (true) {
                socket.setSoTimeout(Math.max(1, (int)(limit - System.currentTimeMillis())));
                DatagramPacket recv = new DatagramPacket(new byte[2048], 2048);
                socket.receive(recv);
                responses.add(recv);
            }
        }
        catch (SocketTimeoutException e) {
            if (responses.isEmpty()) {
                throw new RetryException("Failed to receive a reply to broadcast.");
            }
            return responses;
        }
    }

    public Candidate discoverFromMasterUrl() throws IOException, ParserConfigurationException, RetryException {
        Document xml;
        URL masterURL;
        if (!this.options.master.endsWith("/")) {
            this.options.master = this.options.master + "/";
        }
        try {
            masterURL = new URL(this.options.master);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(MessageFormat.format("The master URL \"{0}\" is invalid", this.options.master), e);
        }
        HttpClient client = this.createHttpClient(masterURL);
        String url = masterURL.toExternalForm() + "plugin/swarm/slaveInfo";
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(true);
        get.addRequestHeader("Connection", "close");
        int responseCode = client.executeMethod((HttpMethod)get);
        if (responseCode != 200) {
            throw new RetryException("Failed to fetch slave info from Jenkins CODE: " + responseCode);
        }
        try {
            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(get.getResponseBody()));
        }
        catch (SAXException e) {
            throw new RetryException("Invalid XML received from " + url);
        }
        String swarmSecret = SwarmClient.getChildElementString(xml.getDocumentElement(), "swarmSecret");
        return new Candidate(masterURL.toExternalForm(), swarmSecret);
    }

    protected void connect(Candidate target) throws InterruptedException {
        try {
            Launcher launcher = new Launcher();
            launcher.slaveJnlpURL = new URL(target.url + "computer/" + this.name + "/slave-agent.jnlp");
            if (this.options.username != null && this.options.password != null) {
                launcher.auth = this.options.username + ":" + this.options.password;
                launcher.slaveJnlpCredentials = this.options.username + ":" + this.options.password;
            }
            List jnlpArgs = launcher.parseJnlpArguments();
            LinkedList args = new LinkedList();
            args.add(jnlpArgs.get(0));
            args.add(jnlpArgs.get(1));
            args.add("-url");
            args.add(target.url);
            if (this.options.tunnel != null) {
                args.add("-tunnel");
                args.add(this.options.tunnel);
                System.out.println("Using tunnel through " + this.options.tunnel);
            }
            if (this.options.username != null && this.options.password != null) {
                args.add("-credentials");
                args.add(this.options.username + ":" + this.options.password);
            }
            args.add("-headless");
            args.add("-noreconnect");
            Main.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to establish JNLP connection to " + target.url);
            Thread.sleep(10000L);
        }
    }

    protected HttpClient createHttpClient(URL urlForAuth) {
        if (this.options.disableSslVerification) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(ctx);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        HttpClient client = new HttpClient();
        if (this.options.username != null && this.options.password != null) {
            client.getState().setCredentials(new AuthScope(urlForAuth.getHost(), urlForAuth.getPort()), (Credentials)new UsernamePasswordCredentials(this.options.username, this.options.password));
        }
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private Crumb getCsrfCrumb(HttpClient client, Candidate target) throws IOException {
        GetMethod httpGet = new GetMethod(target.url + "crumbIssuer/api/xml?xpath=" + URLEncoder.encode("concat(//crumbRequestField,\":\",//crumb)", "UTF-8"));
        httpGet.setDoAuthentication(true);
        int responseCode = client.executeMethod((HttpMethod)httpGet);
        if (responseCode != 200) {
            System.out.println("Could not obtain CSRF crumb. Response code: " + responseCode);
            return null;
        }
        String[] crumbResponse = httpGet.getResponseBodyAsString().split(":");
        if (crumbResponse.length != 2) {
            System.out.println("Unexpected CSRF crumb response: " + httpGet.getResponseBodyAsString());
            return null;
        }
        return new Crumb(crumbResponse[0], crumbResponse[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSwarmSlave(Candidate target) throws IOException, InterruptedException, RetryException {
        String name;
        int responseCode;
        HttpClient client = this.createHttpClient(new URL(target.url));
        String labelStr = StringUtils.join(this.options.labels, (char)' ');
        String toolLocationsStr = StringUtils.join(this.options.toolLocations, (char)' ');
        PostMethod post = new PostMethod(target.url + "/plugin/swarm/createSlave?name=" + this.options.name + "&executors=" + this.options.executors + this.param("remoteFsRoot", this.options.remoteFsRoot.getAbsolutePath()) + this.param("description", this.options.description) + this.param("labels", labelStr) + this.param("toolLocations", toolLocationsStr) + "&secret=" + target.secret + this.param("mode", this.options.mode.toUpperCase(Locale.ENGLISH)) + this.param("hash", this.hash));
        post.setDoAuthentication(true);
        post.addRequestHeader("Connection", "close");
        Crumb csrfCrumb = this.getCsrfCrumb(client, target);
        if (csrfCrumb != null) {
            post.addRequestHeader(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        if ((responseCode = client.executeMethod((HttpMethod)post)) != 200) {
            throw new RetryException(String.format("Failed to create a slave on Jenkins CODE: %s%n%s", responseCode, post.getResponseBodyAsString()));
        }
        Properties props = new Properties();
        InputStream stream = post.getResponseBodyAsStream();
        if (stream != null) {
            try {
                props.load(stream);
            }
            finally {
                stream.close();
            }
        }
        if ((name = props.getProperty("name")) == null) {
            this.name = this.options.name;
            return;
        }
        if ((name = name.trim()).isEmpty()) {
            this.name = this.options.name;
            return;
        }
        this.name = name;
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    private String param(String name, String value) throws UnsupportedEncodingException {
        if (value == null) {
            return "";
        }
        return "&" + name + "=" + this.encode(value);
    }

    protected void verifyThatUrlIsHudson(Candidate target) throws InterruptedException, RetryException {
        try {
            System.out.println("Connecting to " + target.url);
            HttpURLConnection con = (HttpURLConnection)new URL(target.url).openConnection();
            con.connect();
            if (con.getResponseCode() == 403) {
                throw new RetryException("This jenkins server requires Authentication!.");
            }
            String v = con.getHeaderField("X-Hudson");
            if (v == null) {
                throw new RetryException("This URL doesn't look like Jenkins.");
            }
        }
        catch (IOException e) {
            throw new RetryException("Failed to connect to " + target.url, e);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    private static String getChildElementString(Element parent, String tagName) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getTagName().equals(tagName)) continue;
            StringBuilder buf = new StringBuilder();
            for (n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Text)) continue;
                buf.append(n.getTextContent());
            }
            return buf.toString();
        }
        return null;
    }

    private String printable(InetAddress ia) {
        if (this.options.showHostName) {
            return ia.getHostName();
        }
        return ia.toString();
    }

    public static String hash(File remoteFsRoot) {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(remoteFsRoot.getCanonicalPath()).append('\n');
        }
        catch (IOException e) {
            buf.append(remoteFsRoot.getAbsolutePath()).append('\n');
        }
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress ia : Collections.list(ni.getInetAddresses())) {
                    if (ia instanceof Inet4Address) {
                        buf.append(ia.getHostAddress()).append('\n');
                        continue;
                    }
                    if (!(ia instanceof Inet6Address)) continue;
                    buf.append(ia.getHostAddress()).append('\n');
                }
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (hardwareAddress == null) continue;
                buf.append(Arrays.toString(hardwareAddress));
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return DigestUtils.md5Hex((String)buf.toString()).substring(0, 8);
    }

    private static class Crumb {
        private final String crumb;
        private final String crumbRequestField;

        Crumb(String crumbRequestField, String crumb) {
            this.crumbRequestField = crumbRequestField;
            this.crumb = crumb;
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

