/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.ModeOptionHandler;
import hudson.plugins.swarm.RetryException;
import hudson.remoting.Launcher;
import hudson.remoting.jnlp.Main;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    protected Candidate target;
    @Option(name="-name", usage="Name of the slave")
    public String name;
    @Option(name="-description", usage="Description to be put on the slave")
    public String description;
    @Option(name="-labels", usage="Whitespace-separated list of labels to be assigned for this slave. Multiple options are allowed.")
    public List<String> labels = new ArrayList<String>();
    @Option(name="-fsroot", usage="Directory where Jenkins places files")
    public File remoteFsRoot = new File(".");
    @Option(name="-executors", usage="Number of executors")
    public int executors = Runtime.getRuntime().availableProcessors();
    @Option(name="-master", usage="The complete target Jenkins URL like 'http://server:8080/jenkins/'. If this option is specified, auto-discovery will be skipped")
    public String master;
    @Option(name="-autoDiscoveryAddress", usage="Use this address for udp-based auto-discovery (default 255.255.255.255)")
    public String autoDiscoveryAddress = "255.255.255.255";
    @Option(name="-disableSslVerification", usage="Disables SSL verification in the HttpClient.")
    public boolean disableSslVerification;
    @Option(name="-noRetryAfterConnected", usage="Do not retry if a successful connection gets closed.")
    public boolean noRetryAfterConnected;
    @Option(name="-retry", usage="Number of retries before giving up. Unlimited if not specified.")
    public int retry = -1;
    @Option(name="-mode", usage="The mode controlling how Jenkins allocates jobs to slaves. Can be either 'normal' (utilize this slave as much as possible) or 'exclusive' (leave this machine for tied jobs only). Default is normal.", handler=ModeOptionHandler.class)
    public String mode = "normal";
    @Option(name="-username", usage="The Jenkins username for authentication")
    public String username;
    @Option(name="-password", usage="The Jenkins user password")
    public String password;
    @Option(name="-help", aliases={"--help"}, usage="Show the help screen")
    public boolean help;

    public static void main(String ... args) throws InterruptedException, IOException {
        Client client = new Client();
        CmdLineParser p = new CmdLineParser((Object)client);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.out.println(e.getMessage());
            p.printUsage((OutputStream)System.out);
            System.exit(-1);
        }
        if (client.help) {
            p.printUsage((OutputStream)System.out);
            System.exit(0);
        }
        client.run();
    }

    public Client() throws IOException {
        this.name = InetAddress.getLocalHost().getCanonicalHostName();
    }

    public void run() throws InterruptedException {
        System.out.println("Discovering Jenkins master");
        while (true) {
            block10: {
                try {
                    this.target = this.master == null ? this.discoverFromBroadcast() : this.discoverFromMasterUrl();
                    if (this.password == null && this.username == null) {
                        this.verifyThatUrlIsHudson();
                    }
                    System.out.println("Attempting to connect to " + this.target.url + " " + this.target.secret);
                    this.createSwarmSlave();
                    this.connect();
                    if (this.noRetryAfterConnected) {
                        System.out.println("Connection closed, exiting...");
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (RetryException e) {
                    System.out.println(e.getMessage());
                    if (e.getCause() == null) break block10;
                    e.getCause().printStackTrace();
                }
            }
            if (this.retry >= 0) {
                if (this.retry == 0) {
                    System.out.println("Retry limit reached, exiting...");
                    System.exit(-1);
                } else {
                    System.out.println("Remaining retries: " + this.retry);
                    --this.retry;
                }
            }
            System.out.println("Retrying in 10 seconds");
            Thread.sleep(10000L);
        }
    }

    protected Candidate discoverFromBroadcast() throws IOException, InterruptedException, RetryException, ParserConfigurationException {
        DatagramSocket socket = new DatagramSocket();
        socket.setBroadcast(true);
        this.sendBroadcast(socket);
        List<DatagramPacket> responses = this.collectBroadcastResponses(socket);
        return this.getCandidateFromDatagramResponses(responses);
    }

    private Candidate getCandidateFromDatagramResponses(List<DatagramPacket> responses) throws ParserConfigurationException, IOException, RetryException {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (DatagramPacket recv : responses) {
            String url;
            Document xml;
            String responseXml = new String(recv.getData(), 0, recv.getLength());
            System.out.println();
            try {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(recv.getData(), 0, recv.getLength()));
            }
            catch (SAXException e) {
                System.out.println("Invalid response XML from " + recv.getAddress() + ": " + responseXml);
                continue;
            }
            String swarm = Client.getChildElementString(xml.getDocumentElement(), "swarm");
            if (swarm == null) {
                System.out.println(recv.getAddress() + " doesn't support swarm");
                continue;
            }
            String string = url = this.master == null ? Client.getChildElementString(xml.getDocumentElement(), "url") : this.master;
            if (url == null) {
                System.out.println(recv.getAddress() + " doesn't have the configuration set yet. Please go to the system configuration page of this Jenkins and submit it: " + responseXml);
                continue;
            }
            candidates.add(new Candidate(url, swarm));
        }
        if (candidates.isEmpty()) {
            throw new RetryException("No nearby Jenkins supports swarming");
        }
        System.out.println("Found " + candidates.size() + " eligible Jenkins.");
        return (Candidate)candidates.get(new Random().nextInt(candidates.size()));
    }

    protected void sendBroadcast(DatagramSocket socket) throws IOException {
        byte[] buffer = new byte[128];
        Arrays.fill(buffer, (byte)1);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        packet.setAddress(InetAddress.getByName(this.autoDiscoveryAddress));
        packet.setPort(Integer.getInteger("jenkins.udp", Integer.getInteger("hudson.udp", 33848)));
        socket.send(packet);
    }

    protected List<DatagramPacket> collectBroadcastResponses(DatagramSocket socket) throws IOException, RetryException {
        ArrayList<DatagramPacket> responses = new ArrayList<DatagramPacket>();
        long limit = System.currentTimeMillis() + 5000L;
        try {
            while (true) {
                socket.setSoTimeout(Math.max(1, (int)(limit - System.currentTimeMillis())));
                DatagramPacket recv = new DatagramPacket(new byte[2048], 2048);
                socket.receive(recv);
                responses.add(recv);
            }
        }
        catch (SocketTimeoutException e) {
            if (responses.isEmpty()) {
                throw new RetryException("Failed to receive a reply to broadcast.");
            }
            return responses;
        }
    }

    private Candidate discoverFromMasterUrl() throws IOException, ParserConfigurationException, RetryException {
        Document xml;
        URL masterURL;
        if (!this.master.endsWith("/")) {
            this.master = this.master + "/";
        }
        try {
            masterURL = new URL(this.master);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(MessageFormat.format("The master URL \"{0}\" is invalid", this.master), e);
        }
        HttpClient client = this.createHttpClient(masterURL);
        String url = masterURL.toExternalForm() + "plugin/swarm/slaveInfo";
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(true);
        int responseCode = client.executeMethod((HttpMethod)get);
        if (responseCode != 200) {
            throw new RetryException("Failed to fetch slave info from Jenkins CODE: " + responseCode);
        }
        try {
            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(get.getResponseBody()));
        }
        catch (SAXException e) {
            throw new RetryException("Invalid XML received from " + url);
        }
        String swarmSecret = Client.getChildElementString(xml.getDocumentElement(), "swarmSecret");
        return new Candidate(masterURL.toExternalForm(), swarmSecret);
    }

    protected void connect() throws InterruptedException {
        try {
            Launcher launcher = new Launcher();
            launcher.slaveJnlpURL = new URL(this.target.url + "computer/" + this.name + "/slave-agent.jnlp");
            if (this.username != null && this.password != null) {
                launcher.auth = this.username + ":" + this.password;
                launcher.slaveJnlpCredentials = this.username + ":" + this.password;
            }
            List jnlpArgs = launcher.parseJnlpArguments();
            LinkedList args = new LinkedList();
            args.add(jnlpArgs.get(0));
            args.add(jnlpArgs.get(1));
            args.add("-url");
            args.add(this.target.url);
            if (this.username != null && this.password != null) {
                args.add("-credentials");
                args.add(this.username + ":" + this.password);
            }
            args.add("-headless");
            args.add("-noreconnect");
            Main.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to establish JNLP connection to " + this.target.url);
            Thread.sleep(10000L);
        }
    }

    protected HttpClient createHttpClient(URL urlForAuth) {
        if (this.disableSslVerification) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(ctx);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        HttpClient client = new HttpClient();
        if (this.username != null && this.password != null) {
            client.getState().setCredentials(new AuthScope(urlForAuth.getHost(), urlForAuth.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        }
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private Crumb getCsrfCrumb(HttpClient client) throws IOException {
        GetMethod httpGet = new GetMethod(this.target.url + "crumbIssuer/api/xml?xpath=" + URLEncoder.encode("concat(//crumbRequestField,\":\",//crumb)", "UTF-8"));
        httpGet.setDoAuthentication(true);
        int responseCode = client.executeMethod((HttpMethod)httpGet);
        if (responseCode != 200) {
            System.out.println("Could not obtain CSRF crumb. Response code: " + responseCode);
            return null;
        }
        String[] crumbResponse = httpGet.getResponseBodyAsString().split(":");
        if (crumbResponse.length != 2) {
            System.out.println("Unexpected CSRF crumb response: " + httpGet.getResponseBodyAsString());
            return null;
        }
        return new Crumb(crumbResponse[0], crumbResponse[1]);
    }

    protected void createSwarmSlave() throws IOException, InterruptedException, RetryException {
        int responseCode;
        HttpClient client = this.createHttpClient(new URL(this.target.url));
        StringBuilder labelStr = new StringBuilder();
        for (String l : this.labels) {
            if (labelStr.length() > 0) {
                labelStr.append(' ');
            }
            labelStr.append(l);
        }
        PostMethod post = new PostMethod(this.target.url + "/plugin/swarm/createSlave?name=" + this.name + "&executors=" + this.executors + this.param("remoteFsRoot", this.remoteFsRoot.getAbsolutePath()) + this.param("description", this.description) + this.param("labels", labelStr.toString()) + "&secret=" + this.target.secret + this.param("mode", this.mode.toUpperCase()));
        post.setDoAuthentication(true);
        Crumb csrfCrumb = this.getCsrfCrumb(client);
        if (csrfCrumb != null) {
            post.addRequestHeader(csrfCrumb.crumbRequestField, csrfCrumb.crumb);
        }
        if ((responseCode = client.executeMethod((HttpMethod)post)) != 200) {
            throw new RetryException("Failed to create a slave on Jenkins CODE: " + responseCode);
        }
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    private String param(String name, String value) throws UnsupportedEncodingException {
        if (value == null) {
            return "";
        }
        return "&" + name + "=" + this.encode(value);
    }

    protected void verifyThatUrlIsHudson() throws InterruptedException, RetryException {
        try {
            System.out.println("Connecting to " + this.target.url);
            HttpURLConnection con = (HttpURLConnection)new URL(this.target.url).openConnection();
            con.connect();
            if (con.getResponseCode() == 403) {
                throw new RetryException("This jenkins server requires Authentication!.");
            }
            String v = con.getHeaderField("X-Hudson");
            if (v == null) {
                throw new RetryException("This URL doesn't look like Jenkins.");
            }
        }
        catch (IOException e) {
            throw new RetryException("Failed to connect to " + this.target.url, e);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    private static String getChildElementString(Element parent, String tagName) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getTagName().equals(tagName)) continue;
            StringBuilder buf = new StringBuilder();
            for (n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Text)) continue;
                buf.append(n.getTextContent());
            }
            return buf.toString();
        }
        return null;
    }

    private static class Crumb {
        private final String crumb;
        private final String crumbRequestField;

        Crumb(String crumbRequestField, String crumb) {
            this.crumbRequestField = crumbRequestField;
            this.crumb = crumb;
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    class Candidate {
        final String url;
        final String secret;

        Candidate(String url, String secret) {
            this.url = url;
            this.secret = secret;
        }
    }
}

