/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.utility;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.AuditEventTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.EventSourceEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.LogTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import com.sumologic.jenkins.jenkinssumologicplugin.model.AgentModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.AuditModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.TestCaseModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.TestCaseResultModel;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.TestCaseReport;
import hudson.Util;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.util.VersionNumber;
import java.io.BufferedReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.metrics.impl.TimeInQueueAction;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class CommonModelFactory {
    private static final Logger LOG = Logger.getLogger(CommonModelFactory.class.getName());
    private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();

    public static void populateGeneric(BuildModel buildModel, Run buildInfo, PluginDescriptorImpl pluginDescriptor, boolean isSpecificJobFlagEnabled) {
        TimeInQueueAction timeInQueueAction;
        Map<String, Object> parameters;
        VersionNumber version;
        buildModel.setLogType(LogTypeEnum.JOB_STATUS.getValue());
        buildModel.setName(buildInfo.getParent().getFullName());
        buildModel.setNumber(buildInfo.getNumber());
        buildModel.setDescription(buildInfo.getParent().getDescription());
        if (Objects.nonNull(Hudson.getVersion()) && (version = Hudson.getVersion()) != null) {
            buildModel.setHudsonVersion(version.toString());
        }
        if (buildInfo.getParent() instanceof Describable) {
            String jobType = ((Describable)buildInfo.getParent()).getDescriptor().getDisplayName();
            buildModel.setJobType(jobType);
        }
        if (Objects.nonNull(buildInfo.getResult())) {
            Result result = buildInfo.getResult();
            buildModel.setResult(result != null ? result.toString() : "Unknown");
        } else {
            buildModel.setResult("Unknown");
        }
        buildModel.setUser(CommonModelFactory.getUserId(buildInfo));
        buildModel.setDuration(System.currentTimeMillis() - buildInfo.getStartTimeInMillis());
        buildModel.setStart(buildInfo.getStartTimeInMillis());
        buildModel.setJobStartTime(SumoConstants.DATETIME_FORMATTER.format(buildInfo.getTimestamp()));
        buildModel.setJobRunDuration(CommonModelFactory.getJobRunDuration(buildInfo));
        buildModel.setJobBuildURL(CommonModelFactory.getAbsoluteUrl(buildInfo));
        buildModel.setUpstreamJobURL(CommonModelFactory.getUpStreamUrl(buildInfo));
        buildModel.setTriggerCauses(CommonModelFactory.getJobTriggerCauses(buildInfo));
        CommonModelFactory.getLabelAndNodeName(buildInfo, buildModel);
        TestCaseModel testCaseModel = CommonModelFactory.getTestResultSummary(buildInfo);
        if (testCaseModel != null && (pluginDescriptor.isJobStatusLogEnabled() || isSpecificJobFlagEnabled) && StringUtils.isNotEmpty((String)buildModel.getJobType())) {
            LogSenderHelper.sendTestResult(testCaseModel, buildModel);
            testCaseModel.setTestResults(null);
            buildModel.setTestResult(testCaseModel);
        }
        if (!(parameters = CommonModelFactory.getBuildVariables(buildInfo)).isEmpty()) {
            buildModel.setJobMetaData(parameters);
        }
        if ((timeInQueueAction = (TimeInQueueAction)buildInfo.getAction(TimeInQueueAction.class)) != null) {
            LinkedHashMap<String, Float> timing = new LinkedHashMap<String, Float>();
            timing.put("WaitingTime", Float.valueOf((float)timeInQueueAction.getWaitingTimeMillis() / 1000.0f));
            timing.put("BlockedTime", Float.valueOf((float)timeInQueueAction.getBlockedTimeMillis() / 1000.0f));
            timing.put("BuildableTime", Float.valueOf((float)timeInQueueAction.getBuildableTimeMillis() / 1000.0f));
            timing.put("QueueTime", Float.valueOf((float)timeInQueueAction.getQueuingTimeMillis() / 1000.0f));
            timing.put("ExecutingTime", Float.valueOf((float)timeInQueueAction.getExecutingTimeMillis() / 1000.0f));
            timing.put("BuildingTime", Float.valueOf((float)timeInQueueAction.getBuildingDurationMillis() / 1000.0f));
            timing.put("TotalTime", Float.valueOf((float)timeInQueueAction.getTotalDurationMillis() / 1000.0f));
            buildModel.setTimingInformation(timing);
        }
    }

    public static String getUserId(Run buildInfo) {
        String userName = "anonymous";
        for (CauseAction action : buildInfo.getActions(CauseAction.class)) {
            if (action == null || action.getCauses() == null) continue;
            for (Cause cause : action.getCauses()) {
                String triggerUserName = CommonModelFactory.getUsernameOrTimerORScm(cause);
                if (triggerUserName != null) {
                    return triggerUserName;
                }
                if (!(cause instanceof Cause.UpstreamCause)) continue;
                return CommonModelFactory.getUpStreamUser((Cause.UpstreamCause)cause);
            }
        }
        if (buildInfo.getParent().getClass().getName().equals("hudson.maven.MavenModule")) {
            return "(maven)";
        }
        return userName;
    }

    private static String getUsernameOrTimerORScm(Cause cause) {
        if (cause instanceof Cause.UserIdCause) {
            return ((Cause.UserIdCause)cause).getUserId();
        }
        if (cause instanceof TimerTrigger.TimerTriggerCause) {
            return "(timer)";
        }
        if (cause instanceof SCMTrigger.SCMTriggerCause) {
            return "(scm)";
        }
        return null;
    }

    private static String getUpStreamUser(Cause.UpstreamCause upstreamCause) {
        for (Cause upCause : upstreamCause.getUpstreamCauses()) {
            if (upCause instanceof Cause.UpstreamCause) {
                return CommonModelFactory.getUpStreamUser((Cause.UpstreamCause)upCause);
            }
            String userName = CommonModelFactory.getUsernameOrTimerORScm(upCause);
            if (userName == null) continue;
            return userName;
        }
        return null;
    }

    public static float getJobRunDuration(Run buildInfo) {
        float duration = (float)buildInfo.getDuration() / 1000.0f;
        if (duration < 0.01f || buildInfo.isBuilding()) {
            duration = Math.max(0.0f, (float)(System.currentTimeMillis() - buildInfo.getStartTimeInMillis()) / 1000.0f);
        }
        return duration;
    }

    private static String getJobTriggerCauses(Run buildInfo) {
        ArrayList<String> causes = new ArrayList<String>();
        for (CauseAction action : buildInfo.getActions(CauseAction.class)) {
            if (action == null || action.getCauses() == null) continue;
            for (Cause cause : action.getCauses()) {
                causes.add(cause.getShortDescription());
            }
        }
        for (CauseAction action : buildInfo.getActions(InterruptedBuildAction.class)) {
            if (action == null || action.getCauses() == null) continue;
            for (Cause cause : action.getCauses()) {
                causes.add(cause.getShortDescription());
            }
        }
        return StringUtils.join(causes, (String)", ");
    }

    public static String getAbsoluteUrl(Run buildInfo) {
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl == null) {
            return buildInfo.getUrl();
        }
        return Util.encode((String)(rootUrl + buildInfo.getUrl()));
    }

    public static String getUpStreamUrl(Run buildInfo) {
        for (CauseAction action : buildInfo.getActions(CauseAction.class)) {
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)action.findCause(Cause.UpstreamCause.class);
            if (upstreamCause == null) continue;
            return upstreamCause.getUpstreamUrl() + upstreamCause.getUpstreamBuild() + "/";
        }
        return "";
    }

    public static void getLabelAndNodeName(Run buildInfo, BuildModel BuildModel2) {
        Node node;
        Computer owner;
        Executor executor = buildInfo.getExecutor();
        if (executor != null && Objects.nonNull((owner = executor.getOwner()).getNode()) && (node = owner.getNode()) != null) {
            BuildModel2.setLabel(node.getLabelString());
        }
        if (buildInfo instanceof AbstractBuild) {
            String builtOnStr = ((AbstractBuild)buildInfo).getBuiltOnStr();
            if ("".equals(builtOnStr)) {
                BuildModel2.setNodeName("master");
            } else {
                BuildModel2.setNodeName(builtOnStr);
            }
        } else if (executor != null && StringUtils.isEmpty((String)executor.getOwner().getName())) {
            BuildModel2.setNodeName("master");
        }
    }

    private static TestCaseModel getTestResultSummary(Run buildInfo) {
        AbstractTestResultAction action = (AbstractTestResultAction)buildInfo.getAction(AbstractTestResultAction.class);
        if (action != null) {
            TestCaseModel testCaseModel = new TestCaseModel(action.getFailCount(), action.getTotalCount() - action.getFailCount() - action.getSkipCount(), action.getSkipCount(), action.getTotalCount());
            testCaseModel.getTestResults().addAll(TestCaseReport.getTestCaseReport(buildInfo));
            testCaseModel.setTotalDuration(testCaseModel.getTestResults().stream().mapToDouble(TestCaseResultModel::getDuration).sum());
            return testCaseModel;
        }
        return null;
    }

    private static Map<String, Object> getBuildVariables(Run run) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        List parameterActions = run.getActions(ParametersAction.class);
        for (ParametersAction parameters : parameterActions) {
            for (ParameterValue p : parameters) {
                if (p == null) continue;
                if (!p.isSensitive()) {
                    values.put(p.getName(), p.getValue());
                    continue;
                }
                values.put(p.getName(), "***");
            }
        }
        return values;
    }

    public static void captureUserLoginEvent(String userName, AuditEventTypeEnum auditEventTypeEnum) {
        try {
            String message = String.format(auditEventTypeEnum.getMessage(), userName);
            CommonModelFactory.captureAuditEvent(userName, auditEventTypeEnum, message, null);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "An error occurred while Capturing user login Event", exception);
        }
    }

    public static void captureItemAuditEvent(AuditEventTypeEnum auditEventTypeEnum, String itemName, String itemOldValue) {
        try {
            String userName = CommonModelFactory.getUserId();
            String message = AuditEventTypeEnum.COPIED.equals((Object)auditEventTypeEnum) || AuditEventTypeEnum.LOCATION_CHANGED.equals((Object)auditEventTypeEnum) ? String.format(auditEventTypeEnum.getMessage(), userName, itemName, itemOldValue) : String.format(auditEventTypeEnum.getMessage(), userName, itemName);
            CommonModelFactory.captureAuditEvent(userName, auditEventTypeEnum, message, null);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "An error occurred while Capturing Item Audit Event", exception);
        }
    }

    public static void captureConfigChanges(String fileData, String oldFileData, AuditEventTypeEnum auditEventTypeEnum, String fileName) {
        String userName = CommonModelFactory.getUserId();
        String message = String.format(AuditEventTypeEnum.CHANGES_IN_CONFIG.getMessage(), userName, fileName);
        HashMap<String, Object> fileDetails = new HashMap<String, Object>();
        fileDetails.put("Current_File_Data", fileData);
        fileDetails.put("Old_File_Data", oldFileData);
        CommonModelFactory.captureAuditEvent(userName, auditEventTypeEnum, message, fileDetails);
    }

    public static void captureAuditEvent(String userId, AuditEventTypeEnum auditEventTypeEnum, String message, Map<String, Object> fileDetails) {
        String userFullName;
        try {
            User user = User.getById((String)userId, (boolean)false);
            userFullName = user != null ? user.getFullName() : userId;
        }
        catch (Exception exception) {
            userFullName = userId;
        }
        AuditModel auditModel = new AuditModel(userFullName, userId, auditEventTypeEnum.getValue(), SumoConstants.DATETIME_FORMATTER.format(new Date()), message, LogTypeEnum.AUDIT_EVENT.getValue(), fileDetails);
        logSenderHelper.sendAuditLogs(auditModel.toString());
    }

    private static String getUserId() {
        User user = User.current();
        if (user == null) {
            return "anonymous";
        }
        return user.getId();
    }

    public static String getRelativeJenkinsHomePath(String configPath) {
        String jenkinsHome = Jenkins.get().getRootDir().getPath();
        String relativePath = configPath;
        if (configPath.startsWith(jenkinsHome)) {
            relativePath = configPath.substring(jenkinsHome.length() + 1);
        }
        return relativePath;
    }

    public static void updateStatus(Computer computer, String eventSource) {
        try {
            AgentModel agentModel = new AgentModel();
            agentModel.setLogType(LogTypeEnum.AGENT_EVENT.getValue());
            agentModel.setEventTime(SumoConstants.DATETIME_FORMATTER.format(new Date()));
            agentModel.setEventSource(eventSource);
            CommonModelFactory.getComputerStatus(computer, agentModel);
            logSenderHelper.sendLogsToPeriodicSourceCategory(agentModel.toString());
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "An error occurred while Capturing Agent Event", exception);
        }
    }

    public static List<AgentModel> getNodeMonitorsDetails() {
        ArrayList<AgentModel> agentModels = new ArrayList<AgentModel>();
        Computer[] computers = Jenkins.get().getComputers();
        if (computers == null || computers.length == 0) {
            return agentModels;
        }
        for (Computer computer : computers) {
            if (computer == null) continue;
            AgentModel agentModel = new AgentModel();
            agentModel.setLogType(LogTypeEnum.AGENT_EVENT.getValue());
            agentModel.setEventTime(SumoConstants.DATETIME_FORMATTER.format(new Date()));
            agentModel.setEventSource(EventSourceEnum.PERIODIC_UPDATE.getValue());
            CommonModelFactory.getComputerStatus(computer, agentModel);
            computer.getMonitorData().forEach((key, value) -> {
                String monitorName = key.split("\\.")[2];
                String monitorData = null;
                if (value != null) {
                    Pattern compile;
                    Matcher matcher;
                    Method method = MethodUtils.getAccessibleMethod(value.getClass(), (String)"toHtml", (Class[])new Class[0]);
                    if (method != null) {
                        try {
                            monitorData = (String)method.invoke(value, new Object[0]);
                        }
                        catch (Exception e) {
                            monitorData = value.toString();
                        }
                    } else {
                        monitorData = value.toString();
                    }
                    if ((matcher = (compile = Pattern.compile("error.*?>(.*?)</span>", 2)).matcher(monitorData)).find()) {
                        monitorData = matcher.group(1);
                    }
                }
                agentModel.getMonitorData().put(monitorName, monitorData);
            });
            agentModels.add(agentModel);
        }
        return agentModels;
    }

    public static void getComputerStatus(Computer computer, AgentModel agentModel) {
        agentModel.setNodeName(CommonModelFactory.getNodeName(computer));
        Node agentNode = computer.getNode();
        if (agentNode != null) {
            agentModel.setNodeLabel(agentNode.getLabelString());
        }
        agentModel.setNodeStatus("updated");
        agentModel.setNumberOfExecutors(computer.getNumExecutors());
        agentModel.setIdle(computer.isIdle());
        AtomicInteger countFreeExecutors = new AtomicInteger();
        if (computer.getExecutors() != null) {
            computer.getExecutors().forEach(executor -> {
                if (executor.isIdle()) {
                    countFreeExecutors.incrementAndGet();
                }
            });
        }
        agentModel.setNumberOfFreeExecutors(countFreeExecutors.get());
        agentModel.setOnline(computer.isOnline());
        if (computer.isOffline()) {
            agentModel.setNumberOfExecutors(0);
            agentModel.setRemoved(true);
            agentModel.setReasonOffline(computer.getOfflineCauseReason());
            agentModel.setConnecting(computer.isConnecting());
        }
        agentModel.setNodeURL(CommonModelFactory.getAbsoluteUrl(computer));
    }

    private static String getAbsoluteUrl(Computer computer) {
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl == null) {
            return computer.getUrl();
        }
        return Util.encode((String)(rootUrl + computer.getUrl()));
    }

    private static String getNodeName(Computer computer) {
        if (computer instanceof Jenkins.MasterComputer) {
            return "master";
        }
        return computer.getName();
    }

    public static String getAbsoluteUrl(String relativeURL) {
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl == null) {
            return relativeURL;
        }
        return Util.encode((String)(rootUrl + relativeURL));
    }

    public static void sendConsoleLogs(Run run, TaskListener listener) {
        try (BufferedReader bufferedReader = new BufferedReader(run.getLogReader());){
            AtomicReference<StringBuilder> stringBuilder = new AtomicReference<StringBuilder>(new StringBuilder());
            AtomicInteger count = new AtomicInteger();
            count.addAndGet(1);
            AtomicBoolean sendLogs = new AtomicBoolean(true);
            bufferedReader.lines().forEach(s -> {
                String s1 = ConsoleNote.removeNotes((String)s);
                if (s1.startsWith("[Pipeline] Start of Pipeline")) {
                    sendLogs.set(false);
                }
                if (!s1.startsWith("[Pipeline]") && sendLogs.get()) {
                    ((StringBuilder)stringBuilder.get()).append("[").append(SumoConstants.DATETIME_FORMATTER.format(new Date())).append("] ").append(" ").append(s1).append("\n");
                    if (count.get() % 100 == 0) {
                        logSenderHelper.sendConsoleLogs(stringBuilder.toString(), run.getParent().getFullName(), run.getNumber(), null);
                        stringBuilder.set(new StringBuilder());
                    }
                    count.incrementAndGet();
                }
                if (s1.startsWith("[Pipeline] End of Pipeline")) {
                    sendLogs.set(true);
                }
            });
            logSenderHelper.sendConsoleLogs(stringBuilder.toString(), run.getParent().getFullName(), run.getNumber(), null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Job Console Logs Sender ended with exception as " + e.getMessage();
            LOG.log(Level.WARNING, errorMessage, e);
            listener.error(errorMessage);
        }
    }
}

