/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.sdo;

import com.google.gson.Gson;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class SdoEventDeliveryStep
extends Step {
    private String eventType;
    private HashMap<String, Object> keyValueMap = new HashMap();
    private HashMap<String, String> fields = new HashMap();

    public HashMap<String, Object> getKeyValueMap() {
        return this.keyValueMap;
    }

    @DataBoundSetter
    public void setKeyValueMap(HashMap<String, Object> keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    public HashMap<String, String> getFields() {
        return this.fields;
    }

    @DataBoundSetter
    public void setFields(HashMap<String, String> fields) {
        this.fields = fields;
    }

    public String getEventType() {
        return this.eventType;
    }

    @DataBoundSetter
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @DataBoundConstructor
    public SdoEventDeliveryStep() {
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new Execution(this, stepContext);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        protected static final long serialVersionUID = 1L;
        protected final transient SdoEventDeliveryStep step;
        private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();

        protected Execution(SdoEventDeliveryStep sdoEventDeliveryStep, @Nonnull StepContext context) {
            super(context);
            this.step = sdoEventDeliveryStep;
        }

        protected String run() throws Exception {
            HashMap<String, Object> keyValueMap = this.step.getKeyValueMap();
            HashMap<String, String> fields = this.step.getFields();
            String eventType = this.step.getEventType();
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            if (envVars != null && !envVars.isEmpty()) {
                Run<?, ?> run;
                FlowNode parentStage;
                HashMap<String, Object> data = new HashMap<String, Object>();
                Gson gson = new Gson();
                envVars.forEach((key, value) -> {
                    if (key.toLowerCase().equals("sumo_event_type")) {
                        if (StringUtils.isBlank((String)eventType)) {
                            data.put("event_type", value);
                        } else {
                            data.put("event_type", eventType);
                        }
                    } else if (key.toLowerCase().startsWith("sumo_")) {
                        data.put(key.replaceFirst("(?i)" + Pattern.quote("sumo_"), ""), value);
                    }
                });
                if (!keyValueMap.isEmpty()) {
                    data.putAll(keyValueMap);
                }
                if ((parentStage = this.getParentStage()) != null && (run = Execution.runFor(parentStage.getExecution())) != null) {
                    data.put("name", run.getParent().getFullName());
                    data.put("number", run.getNumber());
                    data.put("stageId", parentStage.getId());
                    data.put("stageName", parentStage.getDisplayName());
                    data.put("stageStartTime", Execution.getStartTime(parentStage));
                    data.put("jobBuildURL", CommonModelFactory.getAbsoluteUrl(run));
                    data.put("upstreamJobURL", CommonModelFactory.getUpStreamUrl(run));
                }
                logSenderHelper.sendDataWithFields(gson.toJson(data).getBytes(), fields);
            }
            return null;
        }

        private FlowNode getParentStage() {
            try {
                FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
                if (flowNode != null) {
                    if (this.isStage(flowNode)) {
                        return flowNode;
                    }
                    return this.getFlowNodeFromParents(flowNode);
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }

        private boolean isStage(FlowNode node) {
            if (node instanceof StepAtomNode) {
                return false;
            }
            return node != null && (node.getAction(StageAction.class) != null || node.getAction(LabelAction.class) != null && node.getAction(ThreadNameAction.class) == null);
        }

        private FlowNode getFlowNodeFromParents(FlowNode flownode) {
            List parents = flownode.getParents();
            Iterator iterator = parents.iterator();
            if (iterator.hasNext()) {
                FlowNode parentNode = (FlowNode)iterator.next();
                if (this.isStage(parentNode)) {
                    return parentNode;
                }
                return this.getFlowNodeFromParents(parentNode);
            }
            return flownode;
        }

        static long getStartTime(FlowNode node) {
            TimingAction startTime = (TimingAction)node.getAction(TimingAction.class);
            if (startTime != null) {
                return startTime.getStartTime();
            }
            return 0L;
        }

        @CheckForNull
        private static Run<?, ?> runFor(FlowExecution exec) {
            Queue.Executable executable;
            try {
                executable = exec.getOwner().getExecutable();
            }
            catch (IOException x) {
                return null;
            }
            if (executable instanceof Run) {
                return (Run)executable;
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet();
        }

        public String getFunctionName() {
            return "SumoSDOEvent";
        }

        @Nonnull
        public String getDisplayName() {
            return "Upload Events specific to Software Delivery Optimization Solution to Sumo Logic.";
        }
    }
}

