/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.pipeline;

import com.cloudbees.workflow.rest.external.ChunkVisitor;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.ParallelNodeTypeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class ExecutionNodeExtractor
extends ChunkVisitor {
    private static final Logger LOG = Logger.getLogger(ExecutionNodeExtractor.class.getName());
    private final Map<String, String> workspaceNodes = new HashMap<String, String>();
    private final Map<String, Set<String>> parallelNodes = new HashMap<String, Set<String>>();
    private String execNodeName = null;
    private String execNodeStartId = null;

    ExecutionNodeExtractor(@Nonnull WorkflowRun run) {
        super(run);
    }

    Map<String, String> getWorkspaceNodes() {
        return this.workspaceNodes;
    }

    Map<String, Set<String>> getParallelNodes() {
        return this.parallelNodes;
    }

    public void atomNode(@CheckForNull FlowNode before, @Nonnull FlowNode atomNode, @CheckForNull FlowNode after, @Nonnull ForkScanner scan) {
        try {
            this.findWhereCurrentNodeIsExecuting(atomNode);
            this.findParallelNode(scan, atomNode);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "failed to extract plugin extension info", ex);
        }
        super.atomNode(before, atomNode, after, scan);
    }

    private void findWhereCurrentNodeIsExecuting(FlowNode atomNode) {
        if (this.execNodeName == null) {
            WorkspaceAction workspaceAction;
            StepStartNode nodeStep = this.getPipelineBlockBoundaryStartNode(atomNode);
            if (nodeStep != null && (workspaceAction = (WorkspaceAction)nodeStep.getPersistentAction(WorkspaceAction.class)) != null) {
                this.execNodeName = workspaceAction.getNode();
                this.execNodeStartId = nodeStep.getId();
                if (StringUtils.isEmpty((String)this.execNodeName)) {
                    this.execNodeName = "(master)";
                }
            }
        } else if (atomNode instanceof StepStartNode && atomNode.getId().equals(this.execNodeStartId)) {
            this.execNodeName = null;
        }
        if (this.execNodeName != null) {
            this.workspaceNodes.put(atomNode.getId(), this.execNodeName);
        }
    }

    private void findParallelNode(@Nonnull ForkScanner scan, FlowNode atomNode) {
        FlowNode currentParallelStartNode;
        if (ParallelNodeTypeEnum.NORMAL.toString().equals(String.valueOf(scan.getCurrentType())) && ParallelNodeTypeEnum.PARALLEL_BRANCH_START.toString().equals(String.valueOf(scan.getNextType())) && scan.getCurrentParallelStartNode() != null && (currentParallelStartNode = scan.getCurrentParallelStartNode()) != null) {
            List<String> parentIds = currentParallelStartNode.getParents().stream().map(FlowNode::getId).collect(Collectors.toList());
            Set childrenInParallel = atomNode.getParents().stream().map(FlowNode::getId).collect(Collectors.toSet());
            parentIds.forEach(parentId -> {
                if (this.parallelNodes.containsKey(parentId)) {
                    this.parallelNodes.get(parentId).addAll(childrenInParallel);
                } else {
                    this.parallelNodes.put((String)parentId, childrenInParallel);
                }
            });
        }
    }

    private StepStartNode getPipelineBlockBoundaryStartNode(FlowNode atomNode) {
        StepDescriptor descriptor;
        StepEndNode stepEndNode;
        StepStartNode blockStart;
        StepStartNode startNode = null;
        if (atomNode instanceof StepEndNode && (blockStart = (StepStartNode)(stepEndNode = (StepEndNode)atomNode).getStartNode()).getDescriptor() != null && (descriptor = blockStart.getDescriptor()) != null && descriptor.getFunctionName() != null && "node".equals(descriptor.getFunctionName())) {
            if (blockStart.getParents().size() < 1) {
                return null;
            }
            FlowNode boundaryNode = (FlowNode)blockStart.getParents().get(0);
            if (boundaryNode instanceof StepStartNode) {
                startNode = (StepStartNode)boundaryNode;
            } else if (boundaryNode instanceof FlowStartNode) {
                startNode = blockStart;
            }
        }
        return startNode;
    }
}

