/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.sumologic.jenkins.jenkinssumologicplugin.listeners.SumoSCMListener;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SumoMetricReporter
extends ScheduledReporter {
    private static final Logger LOG = Logger.getLogger(SumoSCMListener.class.getName());
    private final Clock clock;
    private final String prefix;
    private final LogSenderHelper logSenderHelper;
    private static final String[] snapshotStatisticsKeys = new String[]{"max", "mean", "min"};

    public static Builder forRegistry(MetricRegistry metricRegistry) {
        return new Builder(metricRegistry);
    }

    private SumoMetricReporter(MetricRegistry metricRegistry, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, LogSenderHelper logSenderHelper) {
        super(metricRegistry, "sumo-metric-reporter", filter, rateUnit, durationUnit);
        this.clock = clock;
        this.prefix = prefix;
        this.logSenderHelper = logSenderHelper;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timeInSec = this.clock.getTime() / 1000L;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timeInSec, messages);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timeInSec, messages);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timeInSec, messages);
            }
            this.logSenderHelper.sendLogsToMetricDataCategory(messages);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "An error occurred while Sending Metrics", e);
        }
    }

    private void reportGauge(String name, Gauge gauge, long timestamp, List<String> messages) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            messages.add(this.buildMessage(this.prefix(name), value, timestamp));
        }
    }

    private void reportCounter(String name, Counter counter, long timestamp, List<String> messages) {
        messages.add(this.buildMessage(this.prefix(name, "count"), this.format(counter.getCount()), timestamp));
    }

    private void reportTimer(String name, Timer timer, long timestamp, List<String> messages) {
        double[] values = this.prepareDataFromSnapshotForStatistics(timer.getSnapshot());
        for (int i = 0; i < snapshotStatisticsKeys.length; ++i) {
            messages.add(this.buildMessage(this.prefix(name, snapshotStatisticsKeys[i]), this.format(this.convertDuration(values[i])), timestamp));
        }
    }

    private double[] prepareDataFromSnapshotForStatistics(Snapshot snapshot) {
        return new double[]{snapshot.getMax(), snapshot.getMean(), snapshot.getMin()};
    }

    private String buildMessage(String name, String value, long timeStamp) {
        return name + " " + value + " " + timeStamp;
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return null;
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    public static class Builder {
        private final MetricRegistry metricRegistry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public SumoMetricReporter build(LogSenderHelper logSenderHelper) {
            return new SumoMetricReporter(this.metricRegistry, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, logSenderHelper);
        }
    }
}

