/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.integration;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import hudson.model.Action;
import hudson.model.Run;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchAction
implements Action {
    private static final Logger LOG = Logger.getLogger(SearchAction.class.getName());
    private static final String URL_TEMPLATE = "https://%s/ui/index.html?reason=st#section/search/@%d,%d@%s";
    private static final int MILLIS_IN_MINUTE = 60000;
    private Run build;

    public SearchAction(Run build) {
        this.build = build;
    }

    public String getIconFileName() {
        return "/plugin/sumologic-publisher/sumologic.ico";
    }

    public String getDisplayName() {
        return "Search logs";
    }

    public String getUrlName() {
        long queryTo;
        long queryFrom = this.build.getStartTimeInMillis() - 60000L;
        if (this.build.isBuilding()) {
            Calendar cal = Calendar.getInstance();
            cal.add(10, 10);
            queryTo = cal.getTimeInMillis();
        } else {
            queryTo = queryFrom + this.build.getDuration() + 300000L;
        }
        String buildName = this.build.getParent().getFullName();
        int buildNumber = this.build.getNumber();
        PluginDescriptorImpl descriptor = PluginDescriptorImpl.getInstance();
        String queryPortal = descriptor.getQueryPortal();
        String sourceCategory = descriptor.getSourceCategory();
        String query = String.format(" _sourceName=%s#%s* _sourceCategory=%s", buildName, buildNumber, sourceCategory);
        String encodedQuery = "";
        try {
            encodedQuery = URLEncoder.encode(query, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.WARNING, "An error occurred while encoding query ", e);
        }
        return String.format(URL_TEMPLATE, queryPortal, queryFrom, queryTo, encodedQuery);
    }
}

