/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin;

import com.google.gson.Gson;
import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.integration.SearchAction;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.ModelFactory;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class SumoBuildNotifier
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOG = Logger.getLogger(SumoBuildNotifier.class.getName());
    private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();

    @DataBoundConstructor
    public SumoBuildNotifier() {
    }

    public static SumoBuildNotifier getNotifier(AbstractProject project) {
        Map map = project.getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof SumoBuildNotifier)) continue;
            return (SumoBuildNotifier)publisher;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            this.send((Run)build, null);
        }
        catch (Exception e) {
            String errorMessage = "Job Status Generation ended with exception as " + e.getMessage();
            LOG.log(Level.WARNING, errorMessage, e);
            listener.error(errorMessage);
        }
        return true;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) {
        try {
            this.send(run, taskListener);
        }
        catch (Exception e) {
            String errorMessage = "Job Status Generation ended with exception as " + e.getMessage();
            LOG.log(Level.WARNING, errorMessage, e);
            taskListener.error(errorMessage);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected void send(Run build, TaskListener taskListener) {
        try {
            PluginDescriptorImpl descriptor = PluginDescriptorImpl.getInstance();
            Gson gson = new Gson();
            BuildModel buildModel = ModelFactory.createBuildModel(build, descriptor);
            String json = gson.toJson((Object)buildModel);
            byte[] bytes = json.getBytes();
            if (StringUtils.isNotEmpty((String)buildModel.getJobType())) {
                if (!descriptor.isJobStatusLogEnabled()) {
                    LOG.info("Uploading build status to sumo logic: " + json);
                    logSenderHelper.sendData(bytes);
                }
                if (!descriptor.isJobConsoleLogEnabled()) {
                    build.addAction((Action)new SearchAction(build));
                    CommonModelFactory.sendConsoleLogs(build, taskListener);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Job Status Generation ended with exception as " + e.getMessage();
            LOG.log(Level.WARNING, errorMessage, e);
            taskListener.error(errorMessage);
        }
    }

    public PluginDescriptorImpl getDescriptor() {
        return (PluginDescriptorImpl)super.getDescriptor();
    }
}

